/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;

public class ThreadDumpTask
implements DiagnosticTask {
    @Override
    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = mbean.dumpAllThreads(true, true);
        long[] deadlockedThreadIds = mbean.findDeadlockedThreads();
        long[] monitorDeadlockThreadIds = mbean.findMonitorDeadlockedThreads();
        ArrayList<ThreadInfo> sortedInfos = new ArrayList<ThreadInfo>(infos.length);
        Collections.addAll(sortedInfos, infos);
        sortedInfos.sort(new Comparator<ThreadInfo>(this){

            @Override
            public int compare(ThreadInfo o1, ThreadInfo o2) {
                return o1.getThreadName().toLowerCase().compareTo(o2.getThreadName().toLowerCase());
            }
        });
        StringBuilder sb = new StringBuilder();
        for (ThreadInfo info : sortedInfos) {
            StackTraceElement[] stackTraces;
            sb.append("\n");
            sb.append("\"").append(info.getThreadName()).append("\" Id=");
            sb.append(info.getThreadId()).append(" ");
            sb.append(info.getThreadState().toString()).append(" ");
            switch (info.getThreadState()) {
                case BLOCKED: 
                case TIMED_WAITING: 
                case WAITING: {
                    sb.append(" on ");
                    sb.append(info.getLockInfo());
                    break;
                }
            }
            if (info.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (info.isInNative()) {
                sb.append(" (in native code)");
            }
            if (deadlockedThreadIds != null) {
                for (long id : deadlockedThreadIds) {
                    if (id != info.getThreadId()) continue;
                    sb.append(" ** DEADLOCKED THREAD **");
                }
            }
            if (monitorDeadlockThreadIds != null) {
                for (long id : monitorDeadlockThreadIds) {
                    if (id != info.getThreadId()) continue;
                    sb.append(" ** MONITOR-DEADLOCKED THREAD **");
                }
            }
            for (StackTraceElement element : stackTraces = info.getStackTrace()) {
                MonitorInfo[] monitors;
                sb.append("\n\tat ").append(element);
                for (MonitorInfo monitor : monitors = info.getLockedMonitors()) {
                    if (!Objects.equals(monitor.getLockedStackFrame(), element)) continue;
                    sb.append("\n\t- waiting on ").append(monitor);
                }
            }
            LockInfo[] lockInfos = info.getLockedSynchronizers();
            if (lockInfos.length > 0) {
                sb.append("\n\t");
                sb.append("Number of Locked Synchronizers: ").append(lockInfos.length);
                for (LockInfo lockInfo : lockInfos) {
                    sb.append("\n\t- ").append(lockInfo.toString());
                }
            }
            sb.append("\n");
        }
        if (deadlockedThreadIds != null && deadlockedThreadIds.length > 0) {
            sb.append("\n\nDEADLOCK DETECTED!");
            sb.append("\nThe following thread IDs are deadlocked:");
            for (Object id : (Object)deadlockedThreadIds) {
                sb.append("\n").append((long)id);
            }
        }
        if (monitorDeadlockThreadIds != null && monitorDeadlockThreadIds.length > 0) {
            sb.append("\n\nMONITOR DEADLOCK DETECTED!");
            sb.append("\nThe following thread IDs are deadlocked:");
            for (Object id : (Object)monitorDeadlockThreadIds) {
                sb.append("\n").append((long)id);
            }
        }
        return new StandardDiagnosticsDumpElement("Thread Dump", Collections.singletonList(sb.toString()));
    }
}

