/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ott;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.ott.GenerateOneTimeTokenRequest;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.security.authentication.ott.OneTimeTokenService;
import org.springframework.security.web.authentication.ott.DefaultGenerateOneTimeTokenRequestResolver;
import org.springframework.security.web.authentication.ott.GenerateOneTimeTokenRequestResolver;
import org.springframework.security.web.authentication.ott.OneTimeTokenGenerationSuccessHandler;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public final class GenerateOneTimeTokenFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_GENERATE_URL = "/ott/generate";
    private final OneTimeTokenService tokenService;
    private final OneTimeTokenGenerationSuccessHandler tokenGenerationSuccessHandler;
    private RequestMatcher requestMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, "/ott/generate");
    private GenerateOneTimeTokenRequestResolver requestResolver = new DefaultGenerateOneTimeTokenRequestResolver();

    public GenerateOneTimeTokenFilter(OneTimeTokenService tokenService, OneTimeTokenGenerationSuccessHandler tokenGenerationSuccessHandler) {
        Assert.notNull((Object)tokenService, (String)"tokenService cannot be null");
        Assert.notNull((Object)tokenGenerationSuccessHandler, (String)"tokenGenerationSuccessHandler cannot be null");
        this.tokenService = tokenService;
        this.tokenGenerationSuccessHandler = tokenGenerationSuccessHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        GenerateOneTimeTokenRequest generateRequest = this.requestResolver.resolve(request);
        if (generateRequest == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        OneTimeToken ott = this.tokenService.generate(generateRequest);
        this.tokenGenerationSuccessHandler.handle(request, response, ott);
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }

    public void setRequestResolver(GenerateOneTimeTokenRequestResolver requestResolver) {
        Assert.notNull((Object)requestResolver, (String)"requestResolver cannot be null");
        this.requestResolver = requestResolver;
    }
}

