/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.polaris.extension.auth.opa.token;

import static org.assertj.core.api.Assertions.assertThat;
import static org.assertj.core.api.Assertions.assertThatThrownBy;

import org.junit.jupiter.api.Test;

public class StaticBearerTokenProviderTest {

  @Test
  public void testStaticBearerTokenProvider() {
    String expectedToken = "static-bearer-token";
    try (StaticBearerTokenProvider provider = new StaticBearerTokenProvider(expectedToken)) {
      String actualToken = provider.getToken();
      assertThat(actualToken).isEqualTo(expectedToken);
    }
  }

  @Test
  public void testStaticBearerTokenProviderWithEmptyString() {
    // Empty strings should be rejected
    assertThatThrownBy(() -> new StaticBearerTokenProvider(""))
        .isInstanceOf(IllegalArgumentException.class);
  }

  @Test
  public void testStaticBearerTokenProviderWithNullString() {
    // Null tokens should be rejected
    assertThatThrownBy(() -> new StaticBearerTokenProvider(null))
        .isInstanceOf(IllegalArgumentException.class);
  }
}
