/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal.broker;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.service.auth.AuthenticationConfiguration;
import org.apache.polaris.service.auth.AuthenticationRealmConfiguration;
import org.apache.polaris.service.auth.internal.broker.KeyProvider;
import org.apache.polaris.service.auth.internal.broker.LocalRSAKeyProvider;
import org.apache.polaris.service.auth.internal.broker.PemUtils;
import org.apache.polaris.service.auth.internal.broker.RSAKeyPairJWTBroker;
import org.apache.polaris.service.auth.internal.broker.TokenBroker;
import org.apache.polaris.service.auth.internal.broker.TokenBrokerFactory;

@ApplicationScoped
@Identifier(value="rsa-key-pair")
public class RSAKeyPairJWTBrokerFactory
implements TokenBrokerFactory {
    private final AuthenticationConfiguration authenticationConfiguration;
    private final ConcurrentMap<String, KeyProvider> keyProviders;

    @Inject
    public RSAKeyPairJWTBrokerFactory(AuthenticationConfiguration authenticationConfiguration) {
        this.keyProviders = new ConcurrentHashMap<String, KeyProvider>();
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public TokenBroker create(PolarisMetaStoreManager metaStoreManager, PolarisCallContext polarisCallContext) {
        RealmContext realmContext = polarisCallContext.getRealmContext();
        AuthenticationRealmConfiguration config = this.authenticationConfiguration.forRealm(realmContext);
        Duration maxTokenGeneration = config.tokenBroker().maxTokenGeneration();
        KeyProvider keyProvider = this.keyProviders.computeIfAbsent(realmContext.getRealmIdentifier(), k -> config.tokenBroker().rsaKeyPair().map(this::fileSystemKeyPair).orElseGet(this::generateEphemeralKeyPair));
        return new RSAKeyPairJWTBroker(metaStoreManager, polarisCallContext, (int)maxTokenGeneration.toSeconds(), keyProvider);
    }

    private KeyProvider fileSystemKeyPair(AuthenticationRealmConfiguration.TokenBrokerConfiguration.RSAKeyPairConfiguration config) {
        return LocalRSAKeyProvider.fromFiles((Path)config.publicKeyFile(), (Path)config.privateKeyFile());
    }

    private KeyProvider generateEphemeralKeyPair() {
        try {
            return new LocalRSAKeyProvider(PemUtils.generateKeyPair());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public RSAKeyPairJWTBrokerFactory() {
    }
}

