/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.basicconfig.ExponentialBackoffConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class ExponentialBackoffConfigImpl
implements ExponentialBackoffConfig {
    private final String description;
    private final String configKey;
    private final ExponentialBackoff instance;
    private Integer _factor;
    private Long _maxDelay;
    private ChronoUnit _maxDelayUnit;

    private ExponentialBackoffConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(ExponentialBackoff.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.exponentialBackoff;
    }

    private ExponentialBackoffConfigImpl(String id, ExponentialBackoff instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static ExponentialBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.exponentialBackoff == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("exponential-backoff.enabled", "ExponentialBackoff/enabled", method.method)) {
            return null;
        }
        return new ExponentialBackoffConfigImpl(method);
    }

    public static ExponentialBackoffConfigImpl create(String id, Supplier<ExponentialBackoff> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("exponential-backoff.enabled", "ExponentialBackoff/enabled", id)) {
            return null;
        }
        return new ExponentialBackoffConfigImpl(id, supplier.get());
    }

    public Class<? extends Annotation> annotationType() {
        return ExponentialBackoff.class;
    }

    public int factor() {
        if (this._factor == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".exponential-backoff.factor";
            Object oldKey = this.configKey + "/ExponentialBackoff/factor";
            this._factor = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> ExponentialBackoffConfigImpl.lambda$factor$0(config, (String)oldKey)).orElse(null);
            if (this._factor == null) {
                newKey = "smallrye.faulttolerance.global.exponential-backoff.factor";
                oldKey = "ExponentialBackoff/factor";
                this._factor = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> ExponentialBackoffConfigImpl.lambda$factor$1(config, (String)oldKey)).orElse(null);
            }
            if (this._factor == null) {
                this._factor = this.instance.factor();
            }
        }
        return this._factor;
    }

    public long maxDelay() {
        if (this._maxDelay == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".exponential-backoff.max-delay";
            Object oldKey = this.configKey + "/ExponentialBackoff/maxDelay";
            this._maxDelay = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> ExponentialBackoffConfigImpl.lambda$maxDelay$2(config, (String)oldKey)).orElse(null);
            if (this._maxDelay == null) {
                newKey = "smallrye.faulttolerance.global.exponential-backoff.max-delay";
                oldKey = "ExponentialBackoff/maxDelay";
                this._maxDelay = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> ExponentialBackoffConfigImpl.lambda$maxDelay$3(config, (String)oldKey)).orElse(null);
            }
            if (this._maxDelay == null) {
                this._maxDelay = this.instance.maxDelay();
            }
        }
        return this._maxDelay;
    }

    public ChronoUnit maxDelayUnit() {
        if (this._maxDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".exponential-backoff.max-delay-unit";
            Object oldKey = this.configKey + "/ExponentialBackoff/maxDelayUnit";
            this._maxDelayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> ExponentialBackoffConfigImpl.lambda$maxDelayUnit$4(config, (String)oldKey)).orElse(null);
            if (this._maxDelayUnit == null) {
                newKey = "smallrye.faulttolerance.global.exponential-backoff.max-delay-unit";
                oldKey = "ExponentialBackoff/maxDelayUnit";
                this._maxDelayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> ExponentialBackoffConfigImpl.lambda$maxDelayUnit$5(config, (String)oldKey)).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                this._maxDelayUnit = this.instance.maxDelayUnit();
            }
        }
        return this._maxDelayUnit;
    }

    public void materialize() {
        this.factor();
        this.maxDelay();
        this.maxDelayUnit();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @ExponentialBackoff on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @ExponentialBackoff." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$maxDelayUnit$5(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$maxDelayUnit$4(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$maxDelay$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$maxDelay$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$factor$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$factor$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }
}

