/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.typedmessage.mimecontentconverter;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.typedmessage.TypedBytesContentWriter;
import org.apache.qpid.server.typedmessage.TypedBytesFormatException;

@PluggableService
public class MapToJmsMapMessage
implements ObjectToMimeContentConverter<Map> {
    @Override
    public String getType() {
        return this.getMimeType();
    }

    @Override
    public String getMimeType() {
        return "jms/map-message";
    }

    @Override
    public Class<Map> getObjectClass() {
        return Map.class;
    }

    @Override
    public int getRank() {
        return 10;
    }

    @Override
    public boolean isAcceptable(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    return false;
                }
                Object value = entry.getValue();
                if (value == null || value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Boolean || value instanceof byte[]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] toMimeContent(Map map) {
        TypedBytesContentWriter writer = new TypedBytesContentWriter();
        writer.writeIntImpl(map == null ? 0 : map.size());
        if (map != null) {
            try {
                for (Map.Entry entry : map.entrySet()) {
                    writer.writeNullTerminatedStringImpl((String)entry.getKey());
                    writer.writeObject(entry.getValue());
                }
            }
            catch (TypedBytesFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        ByteBuffer buf = writer.getData();
        int remaining = buf.remaining();
        byte[] data = new byte[remaining];
        buf.get(data);
        return data;
    }
}

