/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.util;

import java.nio.ByteBuffer;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;

public final class Functions {
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Functions() {
    }

    public static final int mod(int n, int m) {
        int r = n % m;
        return r < 0 ? m + r : r;
    }

    public static final byte lsb(int i) {
        return (byte)(0xFF & i);
    }

    public static final byte lsb(long l) {
        return (byte)(0xFFL & l);
    }

    public static final String str(ByteBuffer buf) {
        return Functions.str(buf, buf.remaining());
    }

    public static final String str(ByteBuffer buf, int limit) {
        return Functions.str(buf, limit, buf.position());
    }

    public static final String str(ByteBuffer buf, int limit, int start) {
        return Functions.str(QpidByteBuffer.wrap(buf), limit, start);
    }

    public static final String str(QpidByteBuffer buf) {
        return Functions.str(buf, buf.remaining());
    }

    public static final String str(QpidByteBuffer buf, int limit) {
        return Functions.str(buf, limit, buf.position());
    }

    public static final String str(QpidByteBuffer buf, int limit, int start) {
        StringBuilder str = new StringBuilder();
        str.append('\"');
        for (int i = start; i < Math.min(buf.limit(), limit); ++i) {
            byte c = buf.get(i);
            if (c > 31 && c < 127 && c != 92) {
                str.append((char)c);
                continue;
            }
            str.append(String.format("\\x%02x", c));
        }
        str.append('\"');
        if (limit < buf.remaining()) {
            str.append("...");
        }
        return str.toString();
    }

    public static final String str(byte[] bytes) {
        return Functions.str(ByteBuffer.wrap(bytes));
    }

    public static final String str(byte[] bytes, int limit) {
        return Functions.str(ByteBuffer.wrap(bytes), limit);
    }

    public static String hex(byte[] bytes, int limit) {
        return Functions.hex(bytes, limit, (CharSequence)"");
    }

    public static String hex(QpidByteBuffer bytes, int limit) {
        return Functions.hex(bytes, limit, (CharSequence)"");
    }

    public static String hex(byte[] bytes, int limit, CharSequence separator) {
        limit = Math.min(limit, bytes == null ? 0 : bytes.length);
        StringBuilder sb = new StringBuilder(3 + limit * 2);
        for (int i = 0; i < limit; ++i) {
            sb.append(HEX_CHARACTERS[(bytes[i] & 0xF0) >> 4]);
            sb.append(HEX_CHARACTERS[bytes[i] & 0xF]);
            if (i == bytes.length - 1) continue;
            sb.append(separator);
        }
        if (bytes != null && bytes.length > limit) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static String hex(QpidByteBuffer bytes, int limit, CharSequence separator) {
        limit = Math.min(limit, bytes == null ? 0 : bytes.remaining());
        StringBuilder sb = new StringBuilder(3 + limit * 2);
        for (int i = 0; i < limit; ++i) {
            sb.append(HEX_CHARACTERS[(bytes.get(bytes.position() + i) & 0xF0) >> 4]);
            sb.append(HEX_CHARACTERS[bytes.get(bytes.position() + i) & 0xF]);
            if (i == bytes.remaining() - 1) continue;
            sb.append(separator);
        }
        if (bytes != null && bytes.remaining() > limit) {
            sb.append("...");
        }
        return sb.toString();
    }
}

