/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.Put;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.WriteOptions;
import com.sleepycat.persist.BasicIterator;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityResult;
import com.sleepycat.persist.ValueAdapter;
import com.sleepycat.util.keyrange.RangeCursor;
import java.util.Iterator;

class BasicCursor<V>
implements EntityCursor<V> {
    RangeCursor cursor;
    ValueAdapter<V> adapter;
    boolean updateAllowed;
    DatabaseEntry key;
    DatabaseEntry pkey;
    DatabaseEntry data;

    BasicCursor(RangeCursor cursor, ValueAdapter<V> adapter, boolean updateAllowed) {
        this.cursor = cursor;
        this.adapter = adapter;
        this.updateAllowed = updateAllowed;
        this.key = adapter.initKey();
        this.pkey = adapter.initPKey();
        this.data = adapter.initData();
    }

    @Override
    public V first() throws DatabaseException {
        return this.first(null);
    }

    @Override
    public V first(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getFirst(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public V last() throws DatabaseException {
        return this.last(null);
    }

    @Override
    public V last(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getLast(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public V next() throws DatabaseException {
        return this.next(null);
    }

    @Override
    public V next(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getNext(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public V nextDup() throws DatabaseException {
        return this.nextDup(null);
    }

    @Override
    public V nextDup(LockMode lockMode) throws DatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getNextDup(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public V nextNoDup() throws DatabaseException {
        return this.nextNoDup(null);
    }

    @Override
    public V nextNoDup(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getNextNoDup(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public V prev() throws DatabaseException {
        return this.prev(null);
    }

    @Override
    public V prev(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getPrev(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public V prevDup() throws DatabaseException {
        return this.prevDup(null);
    }

    @Override
    public V prevDup(LockMode lockMode) throws DatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getPrevDup(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public V prevNoDup() throws DatabaseException {
        return this.prevNoDup(null);
    }

    @Override
    public V prevNoDup(LockMode lockMode) throws DatabaseException {
        return this.returnValue(this.cursor.getPrevNoDup(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public V current() throws DatabaseException {
        return this.current(null);
    }

    @Override
    public V current(LockMode lockMode) throws DatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getCurrent(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(lockMode)));
    }

    @Override
    public EntityResult<V> get(Get getType, ReadOptions options) throws DatabaseException {
        DbCompat.OpReadOptions opOptions = DbCompat.OpReadOptions.make(options);
        switch (getType) {
            case CURRENT: {
                return this.returnResult(this.cursor.getCurrent(this.key, this.pkey, this.data, opOptions));
            }
            case FIRST: {
                return this.returnResult(this.cursor.getFirst(this.key, this.pkey, this.data, opOptions));
            }
            case LAST: {
                return this.returnResult(this.cursor.getLast(this.key, this.pkey, this.data, opOptions));
            }
            case NEXT: {
                return this.returnResult(this.cursor.getNext(this.key, this.pkey, this.data, opOptions));
            }
            case NEXT_DUP: {
                return this.returnResult(this.cursor.getNextDup(this.key, this.pkey, this.data, opOptions));
            }
            case NEXT_NO_DUP: {
                return this.returnResult(this.cursor.getNextNoDup(this.key, this.pkey, this.data, opOptions));
            }
            case PREV: {
                return this.returnResult(this.cursor.getPrev(this.key, this.pkey, this.data, opOptions));
            }
            case PREV_DUP: {
                return this.returnResult(this.cursor.getPrevDup(this.key, this.pkey, this.data, opOptions));
            }
            case PREV_NO_DUP: {
                return this.returnResult(this.cursor.getPrevNoDup(this.key, this.pkey, this.data, opOptions));
            }
        }
        throw new IllegalArgumentException("getType not allowed: " + (Object)((Object)getType));
    }

    @Override
    public int count() throws DatabaseException {
        this.checkInitialized();
        return this.cursor.count();
    }

    @Override
    public long countEstimate() throws DatabaseException {
        this.checkInitialized();
        return this.cursor.getCursor().countEstimate();
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public Iterator<V> iterator(LockMode lockMode) {
        return new BasicIterator(this, lockMode);
    }

    @Override
    public boolean update(V entity) throws DatabaseException {
        return this.update(entity, null) != null;
    }

    @Override
    public OperationResult update(V entity, WriteOptions options) throws DatabaseException {
        if (!this.updateAllowed) {
            throw new UnsupportedOperationException("Update not allowed on a secondary index");
        }
        this.checkInitialized();
        this.adapter.valueToData(entity, this.data);
        return this.cursor.getCursor().put(null, this.data, Put.CURRENT, options);
    }

    @Override
    public boolean delete() throws DatabaseException {
        return this.delete(null) != null;
    }

    @Override
    public OperationResult delete(WriteOptions options) throws DatabaseException {
        this.checkInitialized();
        return this.cursor.getCursor().delete(options);
    }

    @Override
    public EntityCursor<V> dup() throws DatabaseException {
        return new BasicCursor<V>(this.cursor.dup(true), this.adapter, this.updateAllowed);
    }

    @Override
    public void close() throws DatabaseException {
        this.cursor.close();
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.cursor.getCursor().setCacheMode(cacheMode);
    }

    @Override
    public CacheMode getCacheMode() {
        return this.cursor.getCursor().getCacheMode();
    }

    void checkInitialized() throws IllegalStateException {
        if (!this.cursor.isInitialized()) {
            throw new IllegalStateException("Cursor is not initialized at a valid position");
        }
    }

    V returnValue(DbCompat.OpResult opResult) {
        V value = opResult.isSuccess() ? (V)this.adapter.entryToValue(this.key, this.pkey, this.data) : null;
        this.adapter.clearEntries(this.key, this.pkey, this.data);
        return value;
    }

    EntityResult<V> returnResult(DbCompat.OpResult opResult) {
        V value = this.returnValue(opResult);
        return value != null ? new EntityResult<V>(value, opResult.jeResult) : null;
    }
}

