/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.jdk8;

import java.util.stream.IntStream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public class IntStreamSerializer
extends StdSerializer<IntStream> {
    public static final IntStreamSerializer INSTANCE = new IntStreamSerializer();

    private IntStreamSerializer() {
        super(IntStream.class);
    }

    @Override
    public void serialize(IntStream stream, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        try (IntStream is = stream;){
            g.writeStartArray((Object)is);
            is.forEach(value -> g.writeNumber(value));
            g.writeEndArray();
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, (Object)stream, g.streamWriteContext().getCurrentIndex());
        }
    }
}

