/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.List;
import java.util.Locale;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;

abstract class DerivedGridCoverage
extends GridCoverage {
    protected final GridCoverage source;

    DerivedGridCoverage(GridCoverage source, GridGeometry domain) {
        super(source, domain);
        this.source = source;
    }

    DerivedGridCoverage(GridCoverage source, List<? extends SampleDimension> ranges) {
        super(source.getGridGeometry(), ranges);
        this.source = source;
    }

    boolean isNotRepleacable() {
        return false;
    }

    @Override
    DataType getBandType() {
        return this.source.getBandType();
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        return this.source.evaluator();
    }

    @Override
    public TreeTable toTree(Locale locale, int bitmask) {
        TreeTable tree = super.toTree(locale, bitmask);
        TreeTable.Node branch = tree.getRoot().newChild();
        Vocabulary vocabulary = Vocabulary.forLocale((Locale)locale);
        TableColumn column = TableColumn.VALUE_AS_TEXT;
        branch.setValue(column, (Object)vocabulary.getString((short)182));
        branch.newChild().setValue(column, (Object)DerivedGridCoverage.summary(this.source));
        return tree;
    }

    private static String summary(GridCoverage source) {
        StringBuilder b = new StringBuilder(Classes.getShortClassName((Object)source));
        GridExtent extent = source.gridGeometry.extent;
        if (extent != null) {
            b.append('[');
            int dimension = extent.getDimension();
            for (int i = 0; i < dimension; ++i) {
                if (i != 0) {
                    b.append(" \u00d7 ");
                }
                b.append(GridExtent.toSizeString(extent.getHigh(i) - extent.getLow(i) + 1L));
            }
            b.append(']');
        }
        return b.toString();
    }
}

