/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.CharacteristicTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.feature.builder.RemoveOnlyList;
import org.apache.sis.feature.internal.shared.AttributeConvention;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.internal.shared.AbstractIterator;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.SetOfUnknownSize;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;

public final class AttributeTypeBuilder<V>
extends PropertyTypeBuilder {
    private final Class<V> valueClass;
    private V defaultValue;
    private boolean isIdentifier;
    final List<CharacteristicTypeBuilder<?>> characteristics;
    private transient DefaultAttributeType<V> property;

    private AttributeTypeBuilder(AttributeTypeBuilder<?> builder, Class<V> valueClass) throws UnconvertibleObjectException {
        super(builder);
        this.valueClass = valueClass;
        this.defaultValue = ObjectConverters.convert(builder.defaultValue, valueClass);
        this.isIdentifier = builder.isIdentifier;
        this.characteristics = builder.characteristics;
    }

    AttributeTypeBuilder(FeatureTypeBuilder owner, Class<V> valueClass) {
        super(owner);
        this.valueClass = valueClass;
        this.characteristics = new ArrayList();
    }

    AttributeTypeBuilder(FeatureTypeBuilder owner, DefaultAttributeType<V> template) {
        super(owner);
        this.property = template;
        this.minimumOccurs = template.getMinimumOccurs();
        this.maximumOccurs = template.getMaximumOccurs();
        this.valueClass = template.getValueClass();
        this.defaultValue = template.getDefaultValue();
        Map<String, DefaultAttributeType<?>> tc = template.characteristics();
        this.characteristics = new ArrayList(tc.size());
        for (DefaultAttributeType<?> c : tc.values()) {
            this.characteristics.add(new CharacteristicTypeBuilder(this, c));
        }
        this.initialize(template);
    }

    @Override
    final void clearCache() {
        this.property = null;
        super.clearCache();
    }

    @Override
    final String getDefaultName() {
        return Classes.getShortName(this.valueClass);
    }

    @Override
    public AttributeTypeBuilder<V> setName(GenericName name) {
        super.setName(name);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setName(CharSequence localPart) {
        super.setName(localPart);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setName(CharSequence ... components) {
        super.setName(components);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setMinimumOccurs(int occurs) {
        super.setMinimumOccurs(occurs);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setMaximumOccurs(int occurs) {
        super.setMaximumOccurs(occurs);
        return this;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public <N> AttributeTypeBuilder<N> setValueClass(Class<N> type) throws UnconvertibleObjectException {
        FeatureTypeBuilder owner = this.owner();
        this.ensureNonNull("type", type);
        if (type == this.valueClass) {
            return this;
        }
        AttributeTypeBuilder<N> newb = new AttributeTypeBuilder<N>(this, type);
        for (CharacteristicTypeBuilder<N> characteristicTypeBuilder : this.characteristics) {
            characteristicTypeBuilder.owner(newb);
        }
        owner.replace(this, newb, true);
        this.dispose();
        return newb;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public AttributeTypeBuilder<V> setDefaultValue(V value) {
        if (!Objects.equals(this.defaultValue, value)) {
            this.defaultValue = value;
            this.clearCache();
        }
        return this;
    }

    public V[] getValidValues() {
        Collection c = CollectionsExt.nonNull((Collection)((Collection)this.getCharacteristic(AttributeConvention.VALID_VALUES_CHARACTERISTIC)));
        Object[] values = (Object[])Array.newInstance(this.valueClass, c.size());
        int index = 0;
        for (Object value : c) {
            values[index++] = value;
        }
        return values;
    }

    @SafeVarargs
    public final AttributeTypeBuilder<V> setValidValues(V ... values) {
        return this.setCharacteristic(AttributeConvention.VALID_VALUES_CHARACTERISTIC, Set.class, CollectionsExt.immutableSet((boolean)false, (Object[])values));
    }

    public Integer getMaximalLength() {
        return (Integer)this.getCharacteristic((GenericName)AttributeConvention.MAXIMAL_LENGTH_CHARACTERISTIC);
    }

    public AttributeTypeBuilder<V> setMaximalLength(Integer length) {
        return this.setCharacteristic((GenericName)AttributeConvention.MAXIMAL_LENGTH_CHARACTERISTIC, Integer.class, length);
    }

    public Unit<?> getUnit() {
        return (Unit)this.getCharacteristic((GenericName)AttributeConvention.UNIT_CHARACTERISTIC);
    }

    public AttributeTypeBuilder<V> setUnit(Unit<?> unit) {
        return this.setCharacteristic((GenericName)AttributeConvention.UNIT_CHARACTERISTIC, Unit.class, unit);
    }

    public CoordinateReferenceSystem getCRS() {
        return (CoordinateReferenceSystem)this.getCharacteristic((GenericName)AttributeConvention.CRS_CHARACTERISTIC);
    }

    public AttributeTypeBuilder<V> setCRS(CoordinateReferenceSystem crs) {
        return this.setCharacteristic((GenericName)AttributeConvention.CRS_CHARACTERISTIC, CoordinateReferenceSystem.class, crs);
    }

    private Object getCharacteristic(GenericName name) {
        for (CharacteristicTypeBuilder<?> characteristic : this.characteristics) {
            if (!name.equals((Object)characteristic.getName())) continue;
            return characteristic.getDefaultValue();
        }
        return null;
    }

    private <C> AttributeTypeBuilder<V> setCharacteristic(GenericName name, Class<C> type, C value) {
        for (CharacteristicTypeBuilder<?> characteristic : this.characteristics) {
            if (!name.equals((Object)characteristic.getName())) continue;
            characteristic.set(value);
            this.clearCache();
            return this;
        }
        this.addCharacteristic(type).setDefaultValue(value).setName(name);
        return this;
    }

    public CharacteristicTypeBuilder<?> getCharacteristic(String name) {
        return this.forName(this.characteristics, name, true);
    }

    public <C> CharacteristicTypeBuilder<C> addCharacteristic(Class<C> type) {
        this.ensureNonNull("type", type);
        CharacteristicTypeBuilder<C> characteristic = new CharacteristicTypeBuilder<C>(this, type);
        this.characteristics.add(characteristic);
        this.clearCache();
        return characteristic;
    }

    public <C> CharacteristicTypeBuilder<C> addCharacteristic(DefaultAttributeType<C> template) {
        this.ensureNonNull("template", template);
        CharacteristicTypeBuilder<C> characteristic = new CharacteristicTypeBuilder<C>(this, template);
        this.characteristics.add(characteristic);
        this.clearCache();
        return characteristic;
    }

    public List<CharacteristicTypeBuilder<?>> characteristics() {
        return new RemoveOnlyList(this.characteristics);
    }

    public Set<AttributeRole> roles() {
        return new SetOfUnknownSize<AttributeRole>(){

            public Iterator<AttributeRole> iterator() {
                return new RoleIter();
            }

            public boolean add(AttributeRole role) {
                return AttributeTypeBuilder.this.addRole(role);
            }
        };
    }

    public boolean addRole(AttributeRole role) {
        FeatureTypeBuilder owner = this.owner();
        this.ensureNonNull("role", (Object)role);
        switch (role) {
            case IDENTIFIER_COMPONENT: {
                if (this.isIdentifier) break;
                this.isIdentifier = true;
                ++owner.identifierCount;
                owner.clearCache();
                return true;
            }
            case DEFAULT_GEOMETRY: {
                if (owner.defaultGeometry == this) break;
                if (!Geometries.isKnownType(this.valueClass)) {
                    throw new IllegalStateException(this.errors().getString((short)197, this.valueClass));
                }
                if (owner.defaultGeometry != null) {
                    throw new IllegalStateException(this.resources().getString((short)58, owner.getDisplayName(), AttributeConvention.GEOMETRY_PROPERTY));
                }
                owner.defaultGeometry = this;
                owner.clearCache();
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isIdentifier() {
        return this.isIdentifier;
    }

    @Override
    public AttributeTypeBuilder<V> setDefinition(CharSequence definition) {
        super.setDefinition(definition);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setDesignation(CharSequence designation) {
        super.setDesignation(designation);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setDescription(CharSequence description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setDeprecated(boolean deprecated) {
        super.setDeprecated(deprecated);
        return this;
    }

    @Override
    final void toStringInternal(StringBuilder buffer) {
        buffer.append(" : ").append(Classes.getShortName(this.valueClass));
    }

    @Override
    public void remove() {
        if (this.isIdentifier) {
            this.isIdentifier = false;
            --this.owner().identifierCount;
        }
        super.remove();
    }

    @Override
    public DefaultAttributeType<V> build() {
        if (this.property == null) {
            DefaultAttributeType[] chrts = new DefaultAttributeType[this.characteristics.size()];
            for (int i = 0; i < chrts.length; ++i) {
                chrts[i] = this.characteristics.get(i).build();
            }
            this.property = new DefaultAttributeType<V>(this.identification(), this.valueClass, this.minimumOccurs, this.maximumOccurs, this.defaultValue, chrts);
        }
        return this.property;
    }

    private final class RoleIter
    extends AbstractIterator<AttributeRole> {
        private int index;

        private RoleIter() {
        }

        public boolean hasNext() {
            if (this.next == null) {
                switch (this.index) {
                    case 0: {
                        if (AttributeTypeBuilder.this.isIdentifier) {
                            this.next = AttributeRole.IDENTIFIER_COMPONENT;
                            break;
                        }
                        ++this.index;
                    }
                    case 1: {
                        if (AttributeTypeBuilder.this.owner().defaultGeometry == AttributeTypeBuilder.this) {
                            this.next = AttributeRole.DEFAULT_GEOMETRY;
                            break;
                        }
                        ++this.index;
                    }
                    default: {
                        return false;
                    }
                }
                ++this.index;
            }
            return true;
        }

        public void remove() {
            switch (this.index) {
                case 1: {
                    AttributeTypeBuilder.this.isIdentifier = false;
                    break;
                }
                case 2: {
                    AttributeTypeBuilder.this.owner().defaultGeometry = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

