/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal.shared;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.AssociationRoleBuilder;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjection;
import org.apache.sis.filter.Expression;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public final class FeatureProjectionBuilder
extends FeatureTypeBuilder {
    private DefaultFeatureType source;
    private boolean sourceIsDependency;
    private final List<Item> requested;
    private final Map<GenericName, Item> reservedNames;
    private boolean hasModifiedProperties;
    private int unnamedNumber;
    private final Map<String, List<Item>> dependencies;
    private boolean operationResultAsAttribute;

    public FeatureProjectionBuilder(DefaultFeatureType source, Locale locale) {
        super(null, null, locale);
        this.source = Objects.requireNonNull(source);
        this.requested = new ArrayList<Item>();
        this.dependencies = new HashMap<String, List<Item>>();
        this.reservedNames = new HashMap<GenericName, Item>();
    }

    public DefaultFeatureType source() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item using(DefaultFeatureType childType, FeatureExpression<?, ?> expression) {
        DefaultFeatureType previous = this.source;
        boolean status = this.sourceIsDependency;
        try {
            this.sourceIsDependency = true;
            this.source = Objects.requireNonNull(childType);
            Item item = expression.expectedType(this);
            return item;
        }
        finally {
            this.source = previous;
            this.sourceIsDependency = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item addTemplateProperty(FeatureExpression<?, ?> expression) {
        boolean status = this.operationResultAsAttribute;
        try {
            this.operationResultAsAttribute = true;
            Item item = expression.expectedType(this);
            return item;
        }
        finally {
            this.operationResultAsAttribute = status;
        }
    }

    private PropertyTypeBuilder addPropertyResult(AbstractIdentifiedType property, Collection<String> deferred) {
        if (property instanceof AbstractOperation) {
            GenericName name = property.getName();
            do {
                AbstractIdentifiedType result;
                if (deferred != null && property instanceof AbstractOperation) {
                    deferred.addAll(((AbstractOperation)property).getDependencies());
                }
                if ((result = ((AbstractOperation)property).getResult()) == property || !(result instanceof AbstractIdentifiedType)) {
                    if (result instanceof DefaultFeatureType) {
                        return this.addAssociation((DefaultFeatureType)result).setName(name);
                    }
                    return null;
                }
                property = result;
            } while (property instanceof AbstractOperation);
            return this.addProperty(property).setName(name);
        }
        return this.addProperty(property);
    }

    public Item addSourceProperty(AbstractIdentifiedType property, boolean named) {
        PropertyTypeBuilder builder;
        ArrayList<String> deferred;
        if (property == null) {
            return null;
        }
        if (this.sourceIsDependency) {
            this.reserve(property.getName(), null);
            deferred = new ArrayList();
            builder = this.addPropertyResult(property, deferred);
        } else if (!this.operationResultAsAttribute && property instanceof AbstractOperation) {
            deferred = ((AbstractOperation)property).getDependencies();
            builder = this.addProperty(property);
        } else {
            deferred = new ArrayList();
            builder = this.addPropertyResult(property, deferred);
        }
        Item item = new Item(named ? property.getName() : null, builder);
        this.requested.add(item);
        for (String dependency : deferred) {
            this.dependencies.computeIfAbsent(dependency, key -> new ArrayList(2)).add(item);
        }
        return item;
    }

    public Item addComputedProperty(PropertyTypeBuilder builder, boolean named) {
        if (builder == null) {
            return null;
        }
        assert (this.properties().contains(builder)) : builder;
        assert (this.requested.stream().noneMatch(item -> item.builder == builder)) : builder;
        Item item2 = new Item(named ? builder.getName() : null, builder);
        this.requested.add(item2);
        return item2;
    }

    private void reserve(GenericName name, Item owner) {
        if (name != null) {
            this.reservedNames.putIfAbsent(name, owner);
            GenericName genericName = name;
            name = name.tip();
            if (genericName != name) {
                this.reservedNames.putIfAbsent(name, owner);
            }
        }
    }

    private void resolveDependencies(List<AbstractIdentifiedType> deferred) {
        Iterator<Map.Entry<String, List<Item>>> it = this.dependencies.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<Item>> entry = it.next();
            AbstractIdentifiedType property = this.source.getProperty(entry.getKey());
            GenericName sourceName = property.getName();
            Item item = this.reservedNames.get(sourceName);
            if (item != null) {
                if (!sourceName.equals((Object)item.sourceName)) {
                    throw new UnsupportedOperationException(Resources.forLocale(this.getLocale()).getString((short)93, item.sourceName, sourceName));
                }
            } else {
                for (Item dependent : entry.getValue()) {
                    dependent.hasMissingDependency = true;
                }
                deferred.add(property);
            }
            it.remove();
        }
    }

    private boolean isIdentity() {
        if (this.hasModifiedProperties) {
            return false;
        }
        Iterator<Item> it = this.requested.iterator();
        for (AbstractIdentifiedType property : this.source.getProperties(true)) {
            if (it.hasNext() && it.next().equivalent(property)) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public DefaultFeatureType build() {
        return this.isIdentity() ? this.source : super.build();
    }

    public Optional<FeatureProjection> project() {
        DefaultFeatureType typeRequested;
        DefaultFeatureType typeWithDependencies;
        this.requested.forEach(rec$ -> ((Item)rec$).validateName());
        List<PropertyTypeBuilder> properties = this.properties();
        int count = properties.size();
        ArrayList<AbstractIdentifiedType> deferred = new ArrayList<AbstractIdentifiedType>();
        this.resolveDependencies(deferred);
        if (deferred.isEmpty()) {
            typeRequested = typeWithDependencies = this.build();
        } else {
            do {
                for (AbstractIdentifiedType property : deferred) {
                    Item item = this.addSourceProperty(property, true);
                    if (item == null) continue;
                    item.validateName();
                    item.setValueGetter(FeatureOperations.expressionOf(property), true);
                }
                deferred.clear();
                this.resolveDependencies(deferred);
            } while (!deferred.isEmpty());
            typeWithDependencies = this.build();
            properties.subList(count, properties.size()).clear();
            this.requested.forEach(rec$ -> ((Item)rec$).replaceIfMissingDependency());
            typeRequested = this.build();
        }
        if (this.source.equals(typeRequested) && this.source.equals(typeWithDependencies)) {
            return Optional.empty();
        }
        return Optional.of(new FeatureProjection(typeRequested, typeWithDependencies, this.requested));
    }

    public final class Item {
        final GenericName sourceName;
        private PropertyTypeBuilder builder;
        private boolean isNamed;
        private boolean preferCurrentName;
        private boolean hasMissingDependency;
        private Expression<? super AbstractFeature, ?> attributeValueGetter;

        private Item(GenericName sourceName, PropertyTypeBuilder builder) {
            this.sourceName = sourceName;
            this.builder = builder;
        }

        public String toString() {
            return Strings.toString(this.getClass(), (Object[])new Object[]{"sourceName", this.sourceName != null ? this.sourceName.toString() : null, "targetName", this.isNamed ? this.getName() : null, "valueClass", this.builder instanceof AttributeTypeBuilder ? ((AttributeTypeBuilder)this.builder).getValueClass() : null, null, this.hasMissingDependency ? "hasMissingDependency" : null});
        }

        public PropertyTypeBuilder builder() {
            FeatureProjectionBuilder.this.hasModifiedProperties = true;
            return this.builder;
        }

        private void replaceIfMissingDependency() {
            if (this.hasMissingDependency) {
                this.hasMissingDependency = false;
                FeatureProjectionBuilder.this.hasModifiedProperties = true;
                PropertyTypeBuilder old = this.builder;
                this.builder = FeatureProjectionBuilder.this.addPropertyResult(old.build(), null);
                old.replaceBy(this.builder);
            }
        }

        public boolean replaceValueClass(UnaryOperator<Class<?>> type) {
            Class c;
            Class r;
            AbstractIdentifiedType result;
            AbstractIdentifiedType property;
            if (this.builder instanceof AttributeTypeBuilder) {
                AttributeTypeBuilder ab = (AttributeTypeBuilder)this.builder;
                Class r2 = (Class)type.apply(ab.getValueClass());
                if (r2 != null) {
                    this.builder = ab.setValueClass(r2);
                    if (this.builder != this.builder) {
                        FeatureProjectionBuilder.this.hasModifiedProperties = true;
                    }
                    return true;
                }
            } else if (!(this.builder instanceof AssociationRoleBuilder) && (property = this.builder.build()) instanceof AbstractOperation && (result = ((AbstractOperation)property).getResult()) instanceof DefaultAttributeType && (r = (Class)type.apply(c = ((DefaultAttributeType)result).getValueClass())) != null) {
                if (Features.getLinkTarget(property).isPresent() ? r.isAssignableFrom(c) : r.equals(c)) {
                    return true;
                }
                throw new UnconvertibleObjectException(Errors.forLocale((Locale)FeatureProjectionBuilder.this.getLocale()).getString((short)11, c, (Object)r));
            }
            return false;
        }

        public void setValueGetter(Expression<? super AbstractFeature, ?> expression, boolean stored) {
            if (this.builder instanceof AttributeTypeBuilder) {
                if (stored) {
                    this.attributeValueGetter = expression;
                } else {
                    AbstractIdentifiedType candidate;
                    AttributeTypeBuilder atb = (AttributeTypeBuilder)this.builder;
                    AbstractIdentifiedType storedType = null;
                    if (expression instanceof ValueReference && (candidate = FeatureProjectionBuilder.this.source.getProperty(((ValueReference)expression).getXPath())) instanceof DefaultAttributeType) {
                        storedType = (DefaultAttributeType)candidate;
                    }
                    if (storedType == null) {
                        storedType = atb.build();
                    }
                    Map<String, GenericName> identification = Map.of("name", this.builder.getName());
                    this.builder = FeatureProjectionBuilder.this.addProperty(FeatureOperations.expression(identification, expression, storedType));
                    atb.replaceBy(this.builder);
                    FeatureProjectionBuilder.this.hasModifiedProperties = true;
                }
            }
        }

        final Expression<? super AbstractFeature, ?> attributeValueGetter() {
            return this.attributeValueGetter;
        }

        public Item setCRS(CoordinateReferenceSystem crs) {
            if (this.builder instanceof AttributeTypeBuilder) {
                this.builder = ((AttributeTypeBuilder)this.builder).setCRS(crs);
                FeatureProjectionBuilder.this.hasModifiedProperties = true;
            }
            return this;
        }

        private boolean equivalent(AbstractIdentifiedType property) {
            return this.builder.getName().equals((Object)property.getName());
        }

        public String getName() {
            return this.builder.getName().toString();
        }

        public void setName(GenericName targetName) {
            if (targetName == null) {
                FeatureProjectionBuilder.this.reserve(this.sourceName, null);
                this.preferCurrentName = true;
            } else if (targetName.equals((Object)this.sourceName)) {
                FeatureProjectionBuilder.this.reserve(this.sourceName, this);
                this.isNamed = true;
            } else {
                this.builder.setName(targetName);
                FeatureProjectionBuilder.this.reserve(targetName, this);
                FeatureProjectionBuilder.this.hasModifiedProperties = true;
                this.isNamed = true;
            }
        }

        private void validateName() {
            if (!this.isNamed) {
                Item owner = FeatureProjectionBuilder.this.reservedNames.get(this.sourceName);
                if (owner != this) {
                    GenericName name = this.sourceName;
                    if (owner != null || name == null || !this.preferCurrentName && FeatureProjectionBuilder.this.reservedNames.containsKey(name)) {
                        InternationalString text;
                        while (FeatureProjectionBuilder.this.reservedNames.containsKey(name = this.builder.setName((CharSequence)(text = Vocabulary.formatInternational((short)266, (Object)(++FeatureProjectionBuilder.this.unnamedNumber)))).getName())) {
                        }
                    }
                    FeatureProjectionBuilder.this.reserve(name, this);
                }
                this.isNamed = true;
            }
        }
    }
}

