/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import org.apache.sis.filter.Expression;
import org.apache.sis.filter.sqlmm.GeometryConstructor;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

abstract class GeometryParser<R, G>
extends GeometryConstructor<R, G> {
    private static final long serialVersionUID = -4636578226555118315L;

    GeometryParser(SQLMM operation, Expression<R, ?>[] parameters, Geometries<G> library) {
        super(operation, parameters, library);
    }

    @Override
    public abstract Expression<R, Object> recreate(Expression<R, ?>[] var1);

    @Override
    public final String getSyntax() {
        return String.valueOf(this.getFunctionName().tip()) + " ( <" + this.inputName() + "> [, <srid>] )";
    }

    abstract String inputName();

    @Override
    public final Object apply(R input) {
        Object value = this.geometry.apply(input);
        try {
            CoordinateReferenceSystem crs;
            GeometryWrapper parsed = this.parse(value);
            if (parsed == null) {
                return null;
            }
            GeometryWrapper result = parsed.toGeometryType(this.operation.getGeometryType().get());
            if (result != parsed) {
                switch (this.operation) {
                    case ST_BdPolyFromWKB: 
                    case ST_BdPolyFromText: 
                    case ST_BdMPolyFromWKB: 
                    case ST_BdMPolyFromText: {
                        break;
                    }
                    default: {
                        this.warning(new IllegalArgumentException(Errors.format((short)58, (Object)this.inputName(), this.getValueClass(), (Object)Classes.getClass((Object)this.library.getGeometry(result)))), true);
                    }
                }
            }
            if (this.srid != null && (crs = this.getTargetCRS(input)) != null) {
                result.setCoordinateReferenceSystem(crs);
            }
            return this.library.getGeometry(result);
        }
        catch (Exception e) {
            this.warning(Exceptions.unwrap((Exception)e), false);
            return null;
        }
    }

    protected abstract GeometryWrapper parse(Object var1) throws Exception;
}

