/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.sis.geometry.wrapper.Capability;
import org.apache.sis.geometry.wrapper.Dimensions;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.geometry.wrapper.jts.JTS;
import org.apache.sis.geometry.wrapper.jts.PackedCoordinateSequence;
import org.apache.sis.geometry.wrapper.jts.PackedCoordinateSequenceFactory;
import org.apache.sis.geometry.wrapper.jts.Wrapper;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;
import org.opengis.util.FactoryException;

public final class Factory
extends Geometries<Geometry> {
    private static final long serialVersionUID = 3457343016410620076L;
    public static final Factory INSTANCE = new Factory();
    private final transient GeometryFactory factory = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory(true));
    private final transient GeometryFactory fctry32 = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory(false));

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.JTS, Geometry.class, Point.class);
    }

    @Override
    public Object getGeometry(GeometryWrapper wrapper) {
        if (wrapper instanceof Wrapper) {
            return ((Wrapper)wrapper).implementation();
        }
        return super.getGeometry(wrapper);
    }

    @Override
    public Class<?> getGeometryClass(GeometryType type) {
        return Wrapper.getGeometryClass(type);
    }

    @Override
    public GeometryType getGeometryType(Class<?> type) {
        return Wrapper.getGeometryType(type);
    }

    @Override
    public GeometryWrapper castOrWrap(Object geometry) {
        if (geometry == null || geometry instanceof Wrapper) {
            return (Wrapper)geometry;
        }
        return this.createWrapper((Geometry)geometry);
    }

    @Override
    protected GeometryWrapper createWrapper(Geometry geometry) {
        try {
            return new Wrapper(geometry);
        }
        catch (FactoryException e) {
            throw new BackingStoreException((Throwable)e);
        }
    }

    @Override
    public boolean supports(Capability feature) {
        return true;
    }

    static boolean isFloat(CoordinateSequence cs) {
        return cs instanceof PackedCoordinateSequence.Float || cs instanceof PackedCoordinateSequence.Float;
    }

    static boolean isFloat(boolean previous, Point geometry) {
        return previous && Factory.isFloat(geometry.getCoordinateSequence());
    }

    public final GeometryFactory factory(boolean isFloat) {
        return isFloat ? this.fctry32 : this.factory;
    }

    @Override
    public Object createPoint(float x, float y) {
        return this.fctry32.createPoint((Coordinate)new CoordinateXY((double)x, (double)y));
    }

    @Override
    public Object createPoint(double x, double y) {
        return this.factory.createPoint((Coordinate)new CoordinateXY(x, y));
    }

    @Override
    public Object createPoint(double x, double y, double z) {
        return this.factory.createPoint(new Coordinate(x, y, z));
    }

    @Override
    public Object createPoint(boolean isFloat, Dimensions dimensions, DoubleBuffer coordinates) {
        return this.factory(isFloat).createPoint(Factory.createCoordinateTuple(dimensions, coordinates));
    }

    private static Coordinate createCoordinateTuple(Dimensions dimensions, DoubleBuffer coordinates) {
        double x = coordinates.get();
        double y = coordinates.get();
        if (dimensions.hasZ) {
            double z = coordinates.get();
            if (dimensions.hasM) {
                return new CoordinateXYZM(x, y, z, coordinates.get());
            }
            return new Coordinate(x, y, z);
        }
        if (dimensions.hasM) {
            return new CoordinateXYM(x, y, coordinates.get());
        }
        return new CoordinateXY(x, y);
    }

    @Override
    public Geometry createMultiPoint(boolean isFloat, Dimensions dimensions, DoubleBuffer coordinates) {
        Coordinate[] coordList = new Coordinate[coordinates.remaining() / dimensions.count];
        int n = 0;
        while (coordinates.hasRemaining()) {
            coordList[n++] = Factory.createCoordinateTuple(dimensions, coordinates);
        }
        return this.factory(isFloat).createMultiPointFromCoords(coordList);
    }

    @Override
    public Geometry createPolyline(boolean polygon, boolean isFloat, Dimensions dimensions, DoubleBuffer ... coordinates) {
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>(32);
        ArrayList<Geometry> lines = new ArrayList<Geometry>();
        for (DoubleBuffer v : coordinates) {
            if (v == null) continue;
            while (v.hasRemaining()) {
                Coordinate c = Factory.createCoordinateTuple(dimensions, v);
                if (!Double.isNaN(c.x) && !Double.isNaN(c.y)) {
                    coordList.add(c);
                    continue;
                }
                this.addPolyline(coordList, lines, polygon, isFloat);
                coordList.clear();
            }
        }
        this.addPolyline(coordList, lines, polygon, isFloat);
        return this.groupPolylines(lines, polygon, isFloat);
    }

    final void addPolyline(List<Coordinate> coordinates, List<Geometry> addTo, boolean polygon, boolean isFloat) {
        int s = coordinates.size();
        if (s >= 2) {
            Coordinate[] ca = coordinates.toArray(new Coordinate[s]);
            GeometryFactory gf = this.factory(isFloat);
            Object geometry = polygon ? gf.createPolygon(ca) : (ca.length > 3 && ca[0].equals2D(ca[s - 1]) ? gf.createLinearRing(ca) : gf.createLineString(ca));
            addTo.add((Geometry)geometry);
        }
    }

    final Geometry groupPolylines(List<Geometry> polylines, boolean polygon, boolean isFloat) {
        int s = polylines.size();
        switch (s) {
            case 0: {
                GeometryFactory gf = this.factory(isFloat);
                return polygon ? gf.createPolygon((Coordinate[])null) : gf.createLinearRing((Coordinate[])null);
            }
            case 1: {
                return polylines.get(0);
            }
        }
        GeometryFactory gf = this.factory(isFloat);
        return polygon ? gf.createMultiPolygon(polylines.toArray(new Polygon[s])) : gf.createMultiLineString(polylines.toArray(new LineString[s]));
    }

    private static Polygon createPolygon(GeometryFactory factory, LineString[] rings) {
        LinearRing shell = null;
        LinearRing[] holes = null;
        switch (rings.length) {
            default: {
                holes = (LinearRing[])Arrays.copyOfRange(rings, 1, rings.length, LinearRing[].class);
            }
            case 1: {
                shell = (LinearRing)rings[0];
            }
            case 0: 
        }
        return factory.createPolygon(shell, holes);
    }

    @Override
    public GeometryWrapper createMultiPolygon(Object[] geometries) {
        Polygon[] polygons = new Polygon[geometries.length];
        boolean isFloat = true;
        for (int i = 0; i < geometries.length; ++i) {
            Polygon polygon;
            Object polyline = Factory.implementation(geometries[i]);
            if (polyline instanceof Polygon) {
                polygon = (Polygon)polyline;
            } else {
                boolean fs;
                CoordinateSequence cs;
                if (polyline instanceof LinearRing) {
                    LinearRing ring = (LinearRing)polyline;
                    cs = ring.getCoordinateSequence();
                    fs = Factory.isFloat(cs);
                    polygon = this.factory(fs).createPolygon(ring);
                } else if (polyline instanceof LineString) {
                    cs = ((LineString)polyline).getCoordinateSequence();
                    fs = Factory.isFloat(cs);
                    polygon = this.factory(fs).createPolygon(cs);
                } else {
                    throw new ClassCastException(Errors.format((short)58, (Object)Strings.bracket((String)"geometries", (Object)i), Polygon.class, (Object)Classes.getClass((Object)polyline)));
                }
                JTS.copyMetadata((Geometry)polyline, (Geometry)polygon);
                isFloat &= fs;
            }
            polygons[i] = polygon;
        }
        return this.createWrapper((Geometry)this.factory(isFloat).createMultiPolygon(polygons));
    }

    @Override
    public GeometryWrapper createFromComponents(GeometryType type, Object components) {
        Geometry geometry;
        switch (type) {
            case POINT: {
                geometry = this.createFromCoordinateSequence(components, GeometryFactory::createMultiPoint).getCentroid();
                break;
            }
            case LINESTRING: {
                geometry = this.createFromCoordinateSequence(components, GeometryFactory::createLineString);
                break;
            }
            case POLYGON: {
                if (components instanceof LineString[]) {
                    geometry = this.createFromComponentArray((Geometry[])((LineString[])components), LineString::getCoordinateSequence, Factory::createPolygon);
                    break;
                }
                geometry = this.createFromCoordinateSequence(components, GeometryFactory::createPolygon);
                break;
            }
            case MULTIPOINT: {
                if (components instanceof Point[]) {
                    geometry = this.createFromComponentArray((Geometry[])((Point[])components), Point::getCoordinateSequence, GeometryFactory::createMultiPoint);
                    break;
                }
                geometry = this.createFromCoordinateSequence(components, GeometryFactory::createMultiPoint);
                break;
            }
            case MULTILINESTRING: {
                geometry = this.createFromComponentArray((Geometry[])((LineString[])components), LineString::getCoordinateSequence, GeometryFactory::createMultiLineString);
                break;
            }
            case MULTIPOLYGON: {
                geometry = this.createFromComponentArray((Geometry[])((Polygon[])components), g -> g.getExteriorRing().getCoordinateSequence(), GeometryFactory::createMultiPolygon);
                break;
            }
            case GEOMETRYCOLLECTION: {
                geometry = this.factory.createGeometryCollection((Geometry[])components);
                break;
            }
            case GEOMETRY: {
                return this.createFromComponents(components);
            }
            default: {
                throw new IllegalArgumentException(Errors.format((short)191, (Object)((Object)type)));
            }
        }
        return this.createWrapper(geometry);
    }

    private <G extends Geometry> Geometry createFromComponentArray(G[] components, Function<G, CoordinateSequence> cseqGetter, BiFunction<GeometryFactory, G[], Geometry> constructor) {
        boolean isFloat = true;
        for (G component : components) {
            if (Factory.isFloat(cseqGetter.apply(component))) continue;
            isFloat = false;
            break;
        }
        return constructor.apply(this.factory(isFloat), components);
    }

    private Geometry createFromCoordinateSequence(Object sequence, BiFunction<GeometryFactory, CoordinateSequence, Geometry> constructor) {
        GeometryFactory gf;
        CoordinateSequence cs;
        if (sequence instanceof CoordinateSequence) {
            cs = (CoordinateSequence)sequence;
            gf = this.factory(Factory.isFloat(cs));
        } else {
            Coordinate[] coordinates;
            if (sequence instanceof Coordinate[]) {
                coordinates = (Coordinate[])sequence;
                gf = this.factory;
            } else {
                List<Object> source = sequence instanceof Collection ? (List<Object>)sequence : Arrays.asList((Object[])sequence);
                coordinates = new Coordinate[source.size()];
                boolean isFloat = true;
                int n = 0;
                for (Object e : source) {
                    Coordinate c;
                    if (e instanceof Point) {
                        Point p = (Point)e;
                        isFloat = Factory.isFloat(isFloat, p);
                        c = p.getCoordinate();
                    } else {
                        c = (Coordinate)e;
                        isFloat = false;
                    }
                    coordinates[n++] = c;
                }
                gf = this.factory(isFloat);
            }
            cs = gf.getCoordinateSequenceFactory().create(coordinates);
        }
        return constructor.apply(gf, cs);
    }

    @Override
    public GeometryWrapper parseWKT(String wkt) throws ParseException, FactoryException {
        WKTReader reader = new WKTReader(this.factory);
        reader.setIsOldJtsCoordinateSyntaxAllowed(false);
        return new Wrapper(reader.read(wkt));
    }

    @Override
    public GeometryWrapper parseWKB(ByteBuffer data) throws ParseException, FactoryException {
        byte[] array;
        if (data.hasArray()) {
            array = data.array();
            int lower = data.arrayOffset();
            int upper = data.limit() + lower;
            if ((lower += data.position()) != 0 || upper != array.length) {
                array = Arrays.copyOfRange(array, lower, upper);
            }
        } else {
            array = new byte[data.remaining()];
            data.get(array);
        }
        return new Wrapper(new WKBReader(this.factory).read(array));
    }
}

