/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import org.apache.sis.geometry.wrapper.jts.GeometryTransform;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class GeometryCoordinateTransform
extends GeometryTransform {
    private final MathTransform transform;
    private double[] coordinates;

    GeometryCoordinateTransform(MathTransform transform, GeometryFactory factory) {
        super(factory);
        this.transform = transform;
    }

    @Override
    protected CoordinateSequence transform(CoordinateSequence sequence, int minPoints) throws TransformException {
        int n;
        int srcDim = this.transform.getSourceDimensions();
        int tgtDim = this.transform.getTargetDimensions();
        int maxDim = Math.max(srcDim, tgtDim);
        int count = sequence.size();
        int capacity = Math.max(4, Math.min(100, count));
        CoordinateSequence out = this.coordinateFactory.create(count, tgtDim);
        if (this.coordinates == null || this.coordinates.length / maxDim < capacity) {
            this.coordinates = new double[capacity * maxDim];
        }
        int base = 0;
        while ((n = Math.min(count - base, capacity)) > 0) {
            int i;
            int batch = n * srcDim;
            for (i = 0; i < batch; ++i) {
                this.coordinates[i] = sequence.getOrdinate(base + i / srcDim, i % srcDim);
            }
            this.transform.transform(this.coordinates, 0, this.coordinates, 0, n);
            batch = n * tgtDim;
            for (i = 0; i < batch; ++i) {
                out.setOrdinate(base + i / tgtDim, i % tgtDim, this.coordinates[i]);
            }
            base += n;
        }
        return out;
    }
}

