/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.awt.Shape;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.jts.GeometryCoordinateTransform;
import org.apache.sis.geometry.wrapper.jts.ShapeAdapter;
import org.apache.sis.geometry.wrapper.jts.ShapeConverter;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.logging.Logging;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class JTS {
    public static final String CRS_KEY = "CRS";

    private JTS() {
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(Geometry source) throws FactoryException {
        if (source != null) {
            Map map;
            Object value;
            Object userData = source.getUserData();
            if (userData instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)userData;
            }
            if (userData instanceof Map && (value = (map = (Map)userData).get(CRS_KEY)) instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)value;
            }
            int srid = source.getSRID();
            if (srid > 0) {
                CoordinateReferenceSystem crs = CRS.forCode((String)("EPSG:" + srid));
                crs = AbstractCRS.castOrCopy((CoordinateReferenceSystem)crs).forConvention(AxesConvention.RIGHT_HANDED);
                return crs;
            }
        }
        return null;
    }

    public static void setCoordinateReferenceSystem(Geometry target, CoordinateReferenceSystem crs) {
        target.setUserData((Object)crs);
        int epsg = 0;
        Identifier id = IdentifiedObjects.getIdentifier((IdentifiedObject)crs, (Citation)Citations.EPSG);
        if (id != null) {
            try {
                epsg = Integer.parseInt(id.getCode());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        target.setSRID(epsg);
    }

    static void copyMetadata(Geometry source, Geometry target) {
        target.setSRID(source.getSRID());
        Object crs = source.getUserData();
        if (!(crs instanceof CoordinateReferenceSystem)) {
            if (!(crs instanceof Map)) {
                return;
            }
            if (!((crs = ((Map)crs).get(CRS_KEY)) instanceof CoordinateReferenceSystem)) {
                return;
            }
        }
        target.setUserData(crs);
    }

    private static CoordinateOperation findOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Geometry areaOfInterest) throws FactoryException {
        DefaultGeographicBoundingBox bbox = null;
        if (!areaOfInterest.isEmpty()) {
            bbox = new DefaultGeographicBoundingBox();
            try {
                Envelope e = areaOfInterest.getEnvelopeInternal();
                GeneralEnvelope env = new GeneralEnvelope(sourceCRS);
                env.setRange(0, e.getMinX(), e.getMaxX());
                env.setRange(1, e.getMinY(), e.getMaxY());
                bbox.setBounds((org.opengis.geometry.Envelope)env);
            }
            catch (TransformException ex) {
                bbox = null;
                Logging.ignorableException((Logger)Geometries.LOGGER, JTS.class, (String)"transform", (Throwable)ex);
            }
        }
        return CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (GeographicBoundingBox)bbox);
    }

    public static Geometry transform(Geometry geometry, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS;
        if (geometry != null && targetCRS != null && (sourceCRS = JTS.getCoordinateReferenceSystem(geometry)) != null && !CRS.equivalent((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS)) {
            geometry = JTS.transform(geometry, JTS.findOperation(sourceCRS, targetCRS, geometry), false);
        }
        return geometry;
    }

    public static Geometry transform(Geometry geometry, CoordinateOperation operation, boolean validate) throws FactoryException, TransformException {
        if (geometry != null && operation != null) {
            CoordinateReferenceSystem crs;
            CoordinateReferenceSystem sourceCRS;
            if (validate && (sourceCRS = operation.getSourceCRS()) != null && (crs = JTS.getCoordinateReferenceSystem(geometry)) != null && !CRS.equivalent((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)crs)) {
                operation = JTS.findOperation(crs, operation.getTargetCRS(), geometry);
            }
            geometry = JTS.transform(geometry, operation.getMathTransform());
            geometry.setUserData((Object)operation.getTargetCRS());
        }
        return geometry;
    }

    public static Geometry transform(Geometry geometry, MathTransform transform) throws TransformException {
        if (geometry != null && transform != null && !transform.isIdentity()) {
            GeometryCoordinateTransform gct = new GeometryCoordinateTransform(transform, geometry.getFactory());
            geometry = gct.transform(geometry);
        }
        return geometry;
    }

    public static Shape asShape(Geometry geometry) {
        return new ShapeAdapter(geometry);
    }

    public static Geometry fromAWT(GeometryFactory factory, Shape shape, double flatness) {
        return ShapeConverter.create(factory, Objects.requireNonNull(shape), flatness);
    }

    public static Geometry ensureWinding(Geometry geometry, boolean clockwise) {
        if (geometry instanceof MultiPolygon) {
            MultiPolygon collection = (MultiPolygon)geometry;
            Polygon[] components = new Polygon[collection.getNumGeometries()];
            boolean changed = false;
            for (int i = 0; i < components.length; ++i) {
                Polygon c = (Polygon)geometry.getGeometryN(i);
                changed |= c != (components[i] = JTS.ensureWinding(c, clockwise));
            }
            if (changed) {
                return geometry.getFactory().createMultiPolygon(components);
            }
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            Geometry[] components = new Geometry[collection.getNumGeometries()];
            boolean changed = false;
            for (int i = 0; i < components.length; ++i) {
                Geometry c = geometry.getGeometryN(i);
                changed |= c != (components[i] = JTS.ensureWinding(c, clockwise));
            }
            if (changed) {
                return geometry.getFactory().createGeometryCollection(components);
            }
        } else {
            if (geometry instanceof Polygon) {
                return JTS.ensureWinding((Polygon)geometry, clockwise);
            }
            if (geometry instanceof LinearRing) {
                return JTS.ensureWinding((LinearRing)geometry, clockwise);
            }
        }
        return geometry;
    }

    public static Polygon ensureWinding(Polygon geometry, boolean clockwise) {
        LinearRing outer = geometry.getExteriorRing();
        boolean same = outer == (outer = JTS.ensureWinding(outer, clockwise));
        LinearRing[] holes = new LinearRing[geometry.getNumInteriorRing()];
        for (int i = 0; i < holes.length; ++i) {
            LinearRing inner = geometry.getInteriorRingN(i);
            holes[i] = JTS.ensureWinding(inner, !clockwise);
            same &= inner == holes[i];
        }
        if (same) {
            return geometry;
        }
        Polygon reversed = geometry.getFactory().createPolygon(outer, holes);
        JTS.copyMetadata((Geometry)geometry, (Geometry)reversed);
        return reversed;
    }

    public static LinearRing ensureWinding(LinearRing geometry, boolean clockwise) {
        CoordinateSequence cs = geometry.getCoordinateSequence();
        if (Orientation.isCCW((CoordinateSequence)cs) != clockwise) {
            return geometry;
        }
        cs = cs.copy();
        CoordinateSequences.reverse((CoordinateSequence)cs);
        LinearRing reversed = geometry.getFactory().createLinearRing(cs);
        JTS.copyMetadata((Geometry)geometry, (Geometry)reversed);
        return reversed;
    }
}

