/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;

final class BandSharedRaster
extends WritableRaster {
    private final Raster[] parents;
    private final WritableRenderedImage[] writableSources;
    private final int[] sourceTileIndices;

    BandSharedRaster(int[] sourceTileIndices, Raster[] parents, SampleModel model, DataBuffer buffer, Point location) {
        super(model, buffer, location);
        this.writableSources = new WritableRenderedImage[sourceTileIndices.length >>> 1];
        this.sourceTileIndices = sourceTileIndices;
        this.parents = parents;
        int numBands = 0;
        for (Raster source : parents) {
            int n;
            if (source == null || (n = source.getNumBands()) <= numBands) continue;
            numBands = n;
            this.parent = source;
        }
    }

    final boolean needCopy(int i) {
        return this.parents[i] == null;
    }

    final synchronized void acquireWritableTiles(RenderedImage[] sources) {
        int i;
        WritableRenderedImage[] pending = new WritableRenderedImage[sources.length];
        try {
            for (i = 0; i < sources.length; ++i) {
                Raster parent = this.parents[i];
                if (parent == null || this.writableSources[i] != null) continue;
                int n = i << 1;
                WritableRenderedImage target = (WritableRenderedImage)sources[i];
                WritableRaster tile = target.getWritableTile(this.sourceTileIndices[n], this.sourceTileIndices[n + 1]);
                pending[i] = target;
                if (parent == tile || parent.getDataBuffer() == tile.getDataBuffer() && parent.getSampleModel().equals(tile.getSampleModel())) continue;
                throw new RasterFormatException("DataBuffer replacement not yet supported.");
            }
        }
        catch (RuntimeException error) {
            this.releaseWritableTiles(pending, error);
        }
        for (i = 0; i < pending.length; ++i) {
            WritableRenderedImage target = pending[i];
            if (target == null) continue;
            this.writableSources[i] = target;
        }
    }

    final synchronized void releaseWritableTiles(RuntimeException error) {
        this.releaseWritableTiles(this.writableSources, error);
    }

    private void releaseWritableTiles(WritableRenderedImage[] sources, RuntimeException error) {
        for (int i = 0; i < sources.length; ++i) {
            WritableRenderedImage source = sources[i];
            if (source == null) continue;
            try {
                sources[i] = null;
                int n = i << 1;
                source.releaseWritableTile(this.sourceTileIndices[n], this.sourceTileIndices[n + 1]);
                continue;
            }
            catch (RuntimeException e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

