/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.NonMarshalledAuthority;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

@TitleProperty(name="title")
@XmlType(name="CI_Citation_Type", propOrder={"title", "alternateTitles", "dates", "edition", "editionDate", "identifiers", "citedResponsibleParties", "presentationForms", "series", "otherCitationDetails", "collectiveTitle", "ISBN", "ISSN", "onlineResource", "graphic"})
@XmlRootElement(name="CI_Citation")
public class DefaultCitation
extends ISOMetadata
implements Citation {
    private static final long serialVersionUID = -758307311682907327L;
    private InternationalString title;
    private Collection<InternationalString> alternateTitles;
    private Collection<CitationDate> dates;
    private InternationalString edition;
    private Temporal editionDate;
    private Collection<ResponsibleParty> citedResponsibleParties;
    private Collection<PresentationForm> presentationForms;
    private Series series;
    private InternationalString otherCitationDetails;
    @Deprecated(since="1.0")
    private InternationalString collectiveTitle;
    private Collection<OnlineResource> onlineResources;
    private Collection<BrowseGraphic> graphics;

    public DefaultCitation() {
    }

    public DefaultCitation(CharSequence title) {
        this.title = Types.toInternationalString(title);
    }

    public DefaultCitation(Citation object) {
        super(object);
        if (object != null) {
            this.title = object.getTitle();
            this.alternateTitles = DefaultCitation.copyCollection(object.getAlternateTitles(), InternationalString.class);
            this.dates = DefaultCitation.copyCollection(object.getDates(), CitationDate.class);
            this.edition = object.getEdition();
            this.editionDate = TemporalDate.toTemporal(object.getEditionDate());
            this.identifiers = DefaultCitation.copyCollection(object.getIdentifiers(), Identifier.class);
            this.citedResponsibleParties = DefaultCitation.copyCollection(object.getCitedResponsibleParties(), ResponsibleParty.class);
            this.presentationForms = DefaultCitation.copyCollection(object.getPresentationForms(), PresentationForm.class);
            this.series = object.getSeries();
            this.otherCitationDetails = object.getOtherCitationDetails();
            this.collectiveTitle = object.getCollectiveTitle();
            if (object instanceof DefaultCitation) {
                DefaultCitation c = (DefaultCitation)object;
                this.onlineResources = DefaultCitation.copyCollection(c.getOnlineResources(), OnlineResource.class);
                this.graphics = DefaultCitation.copyCollection(c.getGraphics(), BrowseGraphic.class);
            }
            String id1 = object.getISBN();
            String id2 = object.getISSN();
            if (id1 != null || id2 != null) {
                IdentifierMap map = super.getIdentifierMap();
                if (id1 != null) {
                    map.putSpecialized(Citations.ISBN, id1);
                }
                if (id2 != null) {
                    map.putSpecialized(Citations.ISSN, id2);
                }
            }
        }
    }

    public static DefaultCitation castOrCopy(Citation object) {
        if (object == null || object instanceof DefaultCitation) {
            return (DefaultCitation)object;
        }
        return new DefaultCitation(object);
    }

    @XmlElement(name="title", required=true)
    public InternationalString getTitle() {
        return this.title;
    }

    public void setTitle(InternationalString newValue) {
        this.checkWritePermission(this.title);
        this.title = newValue;
    }

    @XmlElement(name="alternateTitle")
    public Collection<InternationalString> getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return this.alternateTitles;
    }

    public void setAlternateTitles(Collection<? extends InternationalString> newValues) {
        this.alternateTitles = this.writeCollection(newValues, this.alternateTitles, InternationalString.class);
    }

    @XmlElement(name="date")
    public Collection<CitationDate> getDates() {
        this.dates = this.nonNullCollection(this.dates, CitationDate.class);
        return this.dates;
    }

    public void setDates(Collection<? extends CitationDate> newValues) {
        this.dates = this.writeCollection(newValues, this.dates, CitationDate.class);
    }

    @XmlElement(name="edition")
    public InternationalString getEdition() {
        return this.edition;
    }

    public void setEdition(InternationalString newValue) {
        this.checkWritePermission(this.edition);
        this.edition = newValue;
    }

    @XmlElement(name="editionDate")
    public Date getEditionDate() {
        return TemporalDate.toDate(this.editionDate);
    }

    public void setEditionDate(Temporal newValue) {
        this.checkWritePermission(this.editionDate);
        this.editionDate = newValue;
    }

    @Deprecated(since="1.5")
    public void setEditionDate(Date newValue) {
        this.setEditionDate(TemporalDate.toTemporal(newValue));
    }

    @Override
    @XmlElement(name="identifier")
    public Collection<Identifier> getIdentifiers() {
        return NonMarshalledAuthority.filterOnMarshalling(super.getIdentifiers());
    }

    public void setIdentifiers(Collection<? extends Identifier> newValues) {
        newValues = NonMarshalledAuthority.setMarshallables(this.identifiers, newValues);
        this.identifiers = this.writeCollection(newValues, this.identifiers, Identifier.class);
    }

    @XmlElement(name="citedResponsibleParty")
    public Collection<ResponsibleParty> getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return this.citedResponsibleParties;
    }

    public void setCitedResponsibleParties(Collection<? extends ResponsibleParty> newValues) {
        this.citedResponsibleParties = this.writeCollection(newValues, this.citedResponsibleParties, ResponsibleParty.class);
    }

    @XmlElement(name="presentationForm")
    public Collection<PresentationForm> getPresentationForms() {
        this.presentationForms = this.nonNullCollection(this.presentationForms, PresentationForm.class);
        return this.presentationForms;
    }

    public void setPresentationForms(Collection<? extends PresentationForm> newValues) {
        this.presentationForms = this.writeCollection(newValues, this.presentationForms, PresentationForm.class);
    }

    @XmlElement(name="series")
    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series newValue) {
        this.checkWritePermission(this.series);
        this.series = newValue;
    }

    @XmlElement(name="otherCitationDetails")
    public InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public void setOtherCitationDetails(InternationalString newValue) {
        this.checkWritePermission(this.otherCitationDetails);
        this.otherCitationDetails = newValue;
    }

    @Deprecated(since="1.0")
    @XmlElement(name="collectiveTitle", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getCollectiveTitle() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.collectiveTitle : null;
    }

    @Deprecated(since="1.0")
    public void setCollectiveTitle(InternationalString newValue) {
        this.checkWritePermission(this.collectiveTitle);
        this.collectiveTitle = newValue;
    }

    private String getIdentifier(Citation authority) {
        return Containers.isNullOrEmpty((Collection)this.identifiers) ? null : (String)this.getIdentifierMap().get(authority);
    }

    @XmlElement(name="ISBN")
    public String getISBN() {
        return this.getIdentifier(Citations.ISBN);
    }

    public void setISBN(String newValue) {
        this.checkWritePermission(this.getIdentifier(Citations.ISBN));
        if (newValue != null || !Containers.isNullOrEmpty((Collection)this.identifiers)) {
            this.getIdentifierMap().putSpecialized(Citations.ISBN, newValue);
        }
    }

    @XmlElement(name="ISSN")
    public String getISSN() {
        return this.getIdentifier(Citations.ISSN);
    }

    public void setISSN(String newValue) {
        this.checkWritePermission(this.getIdentifier(Citations.ISSN));
        if (newValue != null || !Containers.isNullOrEmpty((Collection)this.identifiers)) {
            this.getIdentifierMap().putSpecialized(Citations.ISSN, newValue);
        }
    }

    @UML(identifier="onlineResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getOnlineResources() {
        this.onlineResources = this.nonNullCollection(this.onlineResources, OnlineResource.class);
        return this.onlineResources;
    }

    public void setOnlineResources(Collection<? extends OnlineResource> newValues) {
        this.onlineResources = this.writeCollection(newValues, this.onlineResources, OnlineResource.class);
    }

    @UML(identifier="graphic", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<BrowseGraphic> getGraphics() {
        this.graphics = this.nonNullCollection(this.graphics, BrowseGraphic.class);
        return this.graphics;
    }

    public void setGraphics(Collection<? extends BrowseGraphic> newValues) {
        this.graphics = this.writeCollection(newValues, this.graphics, BrowseGraphic.class);
    }

    @XmlElement(name="onlineResource")
    private Collection<OnlineResource> getOnlineResource() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getOnlineResources() : null;
    }

    @XmlElement(name="graphic")
    private Collection<BrowseGraphic> getGraphic() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getGraphics() : null;
    }
}

