/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.spatial.AbstractSpatialRepresentation;
import org.opengis.metadata.spatial.GeometricObjects;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.metadata.spatial.TopologyLevel;
import org.opengis.metadata.spatial.VectorSpatialRepresentation;

@XmlType(name="MD_VectorSpatialRepresentation_Type", propOrder={"topologyLevel", "geometricObjects"})
@XmlRootElement(name="MD_VectorSpatialRepresentation")
public class DefaultVectorSpatialRepresentation
extends AbstractSpatialRepresentation
implements VectorSpatialRepresentation {
    private static final long serialVersionUID = -5891825325520101913L;
    private TopologyLevel topologyLevel;
    private Collection<GeometricObjects> geometricObjects;

    public DefaultVectorSpatialRepresentation() {
    }

    public DefaultVectorSpatialRepresentation(VectorSpatialRepresentation object) {
        super((SpatialRepresentation)object);
        if (object != null) {
            this.topologyLevel = object.getTopologyLevel();
            this.geometricObjects = DefaultVectorSpatialRepresentation.copyCollection(object.getGeometricObjects(), GeometricObjects.class);
        }
    }

    public static DefaultVectorSpatialRepresentation castOrCopy(VectorSpatialRepresentation object) {
        if (object == null || object instanceof DefaultVectorSpatialRepresentation) {
            return (DefaultVectorSpatialRepresentation)object;
        }
        return new DefaultVectorSpatialRepresentation(object);
    }

    @XmlElement(name="topologyLevel")
    public TopologyLevel getTopologyLevel() {
        return this.topologyLevel;
    }

    public void setTopologyLevel(TopologyLevel newValue) {
        this.checkWritePermission(this.topologyLevel);
        this.topologyLevel = newValue;
    }

    @XmlElement(name="geometricObjects")
    public Collection<GeometricObjects> getGeometricObjects() {
        this.geometricObjects = this.nonNullCollection(this.geometricObjects, GeometricObjects.class);
        return this.geometricObjects;
    }

    public void setGeometricObjects(Collection<? extends GeometricObjects> newValues) {
        this.geometricObjects = this.writeCollection(newValues, this.geometricObjects, GeometricObjects.class);
    }
}

