/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.internal.shared;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.sis.metadata.sql.internal.shared.Dialect;
import org.apache.sis.metadata.sql.internal.shared.SQLUtilities;
import org.apache.sis.util.internal.shared.Strings;

public class Syntax {
    public final Dialect dialect;
    final boolean isCatalogAtStart;
    final String catalogSeparator;
    final String identifierQuote;
    final boolean quoteSchema;
    public final String wildcardEscape;
    String currentCatalog;
    String currentSchema;

    public Syntax(DatabaseMetaData metadata, boolean quoteSchema) throws SQLException {
        if (metadata != null) {
            this.dialect = Dialect.guess(metadata);
            this.isCatalogAtStart = metadata.isCatalogAtStart();
            this.catalogSeparator = metadata.getCatalogSeparator();
            this.identifierQuote = metadata.getIdentifierQuoteString();
            this.wildcardEscape = metadata.getSearchStringEscape();
            this.setCatalogAndSchema(metadata.getConnection());
        } else {
            this.dialect = Dialect.ANSI;
            this.isCatalogAtStart = true;
            this.catalogSeparator = ".";
            this.identifierQuote = "\"";
            this.wildcardEscape = null;
        }
        this.quoteSchema = quoteSchema;
    }

    Syntax(Syntax other) {
        this.dialect = other.dialect;
        this.isCatalogAtStart = other.isCatalogAtStart;
        this.catalogSeparator = other.catalogSeparator;
        this.identifierQuote = other.identifierQuote;
        this.wildcardEscape = other.wildcardEscape;
        this.currentCatalog = other.currentCatalog;
        this.currentSchema = other.currentSchema;
        this.quoteSchema = other.quoteSchema;
    }

    public final void setCatalogAndSchema(Connection current) throws SQLException {
        this.currentCatalog = current.getCatalog();
        this.currentSchema = current.getSchema();
    }

    public final String escapeWildcards(String text) {
        return SQLUtilities.escape(text, this.wildcardEscape);
    }

    public final boolean canEscapeWildcards() {
        return !Strings.isNullOrEmpty((String)this.wildcardEscape);
    }
}

