/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.control.Menu;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.gui.map.ValuesFromCoverage;
import org.opengis.geometry.DirectPosition;

public abstract class ValuesUnderCursor {
    private StatusBar owner;
    protected final Menu valueChoices = new Menu();
    private final Consumer consumer = new Consumer();

    protected ValuesUnderCursor() {
    }

    protected abstract Formatter formatter();

    public void evaluateLater(DirectPosition point) {
        Formatter formatter = this.formatter();
        if (formatter != null) {
            formatter.evaluateLater(point);
        }
    }

    final boolean usePrototype() {
        return this.owner != null;
    }

    final boolean prototype(String main, Iterable<String> others) {
        return this.owner == null || this.owner.computeSizeOfSampleValues(main, others);
    }

    static void update(StatusBar owner, ValuesUnderCursor oldValue, ValuesUnderCursor newValue) {
        if (oldValue != null && oldValue.owner == owner) {
            oldValue.owner = null;
        }
        if (newValue != null && newValue.owner != owner) {
            if (newValue.owner != null) {
                newValue.owner.sampleValuesProvider.set(null);
            }
            newValue.owner = owner;
        }
    }

    static ValuesUnderCursor create(MapCanvas canvas) {
        if (canvas instanceof CoverageCanvas) {
            CoverageCanvas cc = (CoverageCanvas)canvas;
            ValuesFromCoverage listener = new ValuesFromCoverage();
            cc.coverageProperty.addListener((ChangeListener)new WeakChangeListener((ChangeListener)listener));
            cc.sliceExtentProperty.addListener((p, o, n) -> listener.setSlice((GridExtent)n));
            GridCoverage coverage = (GridCoverage)cc.coverageProperty.get();
            if (coverage != null) {
                listener.changed(null, null, coverage);
            }
            return listener;
        }
        return null;
    }

    final void setError(Throwable e) {
        StatusBar owner = this.owner;
        if (owner != null) {
            owner.setSampleValues(owner.cause(e));
        }
    }

    private final class Consumer
    extends AtomicReference<String>
    implements Runnable {
        Consumer() {
        }

        final void setLater(String result) {
            if (this.getAndSet(result) == null) {
                Platform.runLater((Runnable)this);
            }
        }

        @Override
        public void run() {
            String text = this.getAndSet(null);
            StatusBar c = ValuesUnderCursor.this.owner;
            if (c != null) {
                c.setSampleValues(text);
            }
        }
    }

    protected static abstract class Formatter
    implements Runnable {
        private DirectPosition position;
        private boolean hasNewPoint;
        private boolean isRunning;
        private final Consumer consumer;

        protected Formatter(ValuesUnderCursor owner) {
            this.consumer = owner.consumer;
        }

        DirectPosition copy(DirectPosition point) {
            return new GeneralDirectPosition(point);
        }

        final synchronized void evaluateLater(DirectPosition point) {
            this.position = point != null ? this.copy(point) : null;
            this.hasNewPoint = true;
            if (!this.isRunning) {
                BackgroundThreads.execute(this);
                this.isRunning = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                DirectPosition point;
                Formatter formatter = this;
                synchronized (formatter) {
                    if (!this.hasNewPoint) {
                        this.isRunning = false;
                        break;
                    }
                    point = this.position;
                    this.position = null;
                    this.hasNewPoint = false;
                }
                this.consumer.setLater(this.evaluate(point));
            }
        }

        public abstract String evaluate(DirectPosition var1);
    }
}

