/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gpx;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.sis.measure.Range;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.gpx.Metadata;
import org.apache.sis.storage.gpx.Store;
import org.apache.sis.storage.gpx.WritableStore;
import org.apache.sis.storage.xml.stream.StaxDataStoreProvider;
import org.apache.sis.util.Version;

@StoreMetadata(formatName="GPX", fileSuffixes={"xml"}, capabilities={Capability.READ, Capability.WRITE, Capability.CREATE}, resourceTypes={FeatureSet.class})
public final class StoreProvider
extends StaxDataStoreProvider {
    public static final String NAME = "GPX";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.gpx");
    static final Version V1_0 = Version.valueOf((int[])new int[]{1, 0});
    static final Version V1_1 = Version.valueOf((int[])new int[]{1, 1});
    private static final Range<Version> VERSIONS = new Range(Version.class, (Comparable)V1_0, true, (Comparable)V1_1, true);
    private static final StoreProvider INSTANCE = new StoreProvider();

    public static StoreProvider provider() {
        return INSTANCE;
    }

    public StoreProvider() {
        super(NAME, Map.of("http://www.topografix.com/GPX/1/0", "application/gpx+xml", "http://www.topografix.com/GPX/1/1", "application/gpx+xml"), Map.of("gpx", "application/gpx+xml"));
    }

    public Range<Version> getSupportedVersions() {
        return VERSIONS;
    }

    public DataStore open(StorageConnector connector) throws DataStoreException {
        if (StoreProvider.isWritable((StorageConnector)connector, (boolean)false)) {
            return new WritableStore(this, connector);
        }
        return new Store(this, connector);
    }

    @Override
    protected JAXBContext getJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{Metadata.class});
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

