/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gpx;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalFeatureTypeException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.WritableFeatureSet;
import org.apache.sis.storage.gpx.Metadata;
import org.apache.sis.storage.gpx.Store;
import org.apache.sis.storage.gpx.StoreProvider;
import org.apache.sis.storage.gpx.Updater;
import org.apache.sis.storage.gpx.Writer;
import org.apache.sis.util.collection.BackingStoreException;

public final class WritableStore
extends Store
implements WritableFeatureSet {
    public WritableStore(StoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
    }

    public void updateType(DefaultFeatureType newType) throws DataStoreException {
        if (!newType.equals((Object)this.getType())) {
            throw new IllegalFeatureTypeException(this.getLocale(), "GPX", newType.getName());
        }
    }

    public synchronized void add(Iterator<? extends AbstractFeature> features) throws DataStoreException {
        try (Updater updater = this.updater();){
            updater.add(features);
            updater.flush();
        }
    }

    public synchronized void removeIf(Predicate<? super AbstractFeature> filter) throws DataStoreException {
        try (Updater updater = this.updater();){
            updater.removeIf(filter);
            updater.flush();
        }
    }

    public synchronized void replaceIf(Predicate<? super AbstractFeature> filter, UnaryOperator<AbstractFeature> replacement) throws DataStoreException {
        try (Updater updater = this.updater();){
            updater.replaceIf(filter, replacement);
            updater.flush();
        }
    }

    private Updater updater() throws DataStoreException {
        try {
            return new Updater(this, this.locationAsPath);
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    @Deprecated(since="1.3")
    public synchronized void write(org.opengis.metadata.Metadata metadata, Stream<? extends AbstractFeature> features) throws DataStoreException {
        try {
            this.closeReader();
            try (Writer writer = new Writer(this, Metadata.castOrCopy(metadata, this.locale), null);){
                writer.writeStartDocument();
                if (features != null) {
                    features.forEachOrdered(writer);
                }
                writer.writeEndDocument();
            }
        }
        catch (BackingStoreException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DataStoreException) {
                throw (DataStoreException)cause;
            }
            throw new DataStoreException(e.getLocalizedMessage(), cause);
        }
        catch (Exception e2) {
            IOException e2;
            if (e2 instanceof UncheckedIOException) {
                e2 = ((UncheckedIOException)e2).getCause();
            }
            throw new DataStoreException((Throwable)e2);
        }
    }
}

