/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.metadata.internal.shared.Identifiers;
import org.apache.sis.metadata.internal.shared.NameMeaning;
import org.apache.sis.metadata.internal.shared.NameToIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.pending.jdk.JDK21;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.DisplayName;
import org.apache.sis.referencing.Properties;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;

public final class IdentifiedObjects
extends Static {
    private IdentifiedObjects() {
    }

    public static Map<String, ?> getProperties(IdentifiedObject object, String ... excludes) {
        ArgumentChecks.ensureNonNull((String)"object", (Object)object);
        ArgumentChecks.ensureNonNull((String)"excludes", (Object)excludes);
        return new Properties(object, excludes);
    }

    public static Set<String> getNames(IdentifiedObject object, Citation authority) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(8);
        IdentifiedObjects.getName(object, authority, names);
        return names;
    }

    public static String getName(IdentifiedObject object, Citation authority) {
        return IdentifiedObjects.getName(object, authority, null);
    }

    private static String getName(IdentifiedObject object, Citation authority, Collection<String> addTo) {
        if (object != null) {
            String name;
            ReferenceIdentifier identifier = object.getName();
            if (identifier != null && (authority == null || Citations.identifierMatches((Citation)authority, (Citation)identifier.getAuthority())) && (name = identifier.getCode()) != null) {
                if (addTo == null) {
                    return name;
                }
                addTo.add(name);
            }
            for (GenericName alias : CollectionsExt.nonNull((Collection)object.getAlias())) {
                String name2;
                if (alias == null) continue;
                if (alias instanceof Identifier) {
                    identifier = (Identifier)alias;
                    if (authority != null && !Citations.identifierMatches((Citation)authority, (Citation)identifier.getAuthority())) continue;
                    name2 = identifier.getCode();
                } else {
                    GenericName scope;
                    NameSpace ns;
                    if (authority != null && ((ns = alias.scope()) == null || (scope = ns.name()) == null || !Citations.identifierMatches((Citation)authority, (String)scope.toString()))) continue;
                    name2 = alias.toString();
                }
                if (name2 == null) continue;
                if (addTo == null) {
                    return name2;
                }
                addTo.add(name2);
            }
        }
        return null;
    }

    public static Identifier getIdentifier(IdentifiedObject object, Citation authority) {
        if (object != null) {
            String cs = null;
            if (authority instanceof IdentifierSpace) {
                cs = ((IdentifierSpace)authority).getName();
            }
            for (ReferenceIdentifier identifier : CollectionsExt.nonNull((Set)object.getIdentifiers())) {
                if (identifier == null) continue;
                if (cs != null && cs.equalsIgnoreCase(identifier.getCodeSpace())) {
                    return identifier;
                }
                if (authority != null && !Citations.identifierMatches((Citation)authority, (Citation)identifier.getAuthority())) continue;
                return identifier;
            }
        }
        return null;
    }

    public static String getIdentifierOrName(IdentifiedObject object) {
        if (object == null) {
            return null;
        }
        for (Identifier id : CollectionsExt.nonNull((Set)object.getIdentifiers())) {
            String code = IdentifiedObjects.toString(id);
            if (code == null) continue;
            return code;
        }
        return IdentifiedObjects.toString((Identifier)object.getName());
    }

    public static String getSimpleNameOrIdentifier(IdentifiedObject object) {
        if (object != null) {
            String code;
            String code2;
            ReferenceIdentifier identifier = object.getName();
            if (identifier != null && CharSequences.isUnicodeIdentifier((CharSequence)(code2 = identifier.getCode()))) {
                return code2;
            }
            for (GenericName alias : CollectionsExt.nonNull((Collection)object.getAlias())) {
                if (alias == null || (alias = alias.tip()) == null || !CharSequences.isUnicodeIdentifier((CharSequence)(code = alias.toString()))) continue;
                return code;
            }
            for (Identifier id : CollectionsExt.nonNull((Set)object.getIdentifiers())) {
                if (id == null || !CharSequences.isUnicodeIdentifier((CharSequence)(code = id.getCode()))) continue;
                return code;
            }
        }
        return null;
    }

    public static InternationalString getDisplayName(IdentifiedObject object) {
        return object == null ? null : new DisplayName(object);
    }

    public static String getDisplayName(IdentifiedObject object, Locale locale) {
        String name;
        block4: {
            Identifier id;
            if (object == null) {
                return null;
            }
            name = IdentifiedObjects.toString((Identifier)object.getName(), locale);
            for (GenericName c : CollectionsExt.nonNull((Collection)object.getAlias())) {
                String alias = IdentifiedObjects.toString(c, locale);
                if (alias == null) continue;
                if (name == null || CharSequences.isAcronymForWords((CharSequence)name, (CharSequence)alias)) {
                    return alias;
                }
                String unlocalized = c.toString();
                if (alias.equals(unlocalized) || !CharSequences.isAcronymForWords((CharSequence)name, (CharSequence)unlocalized)) continue;
                return alias;
            }
            if (name != null) break block4;
            Iterator iterator = CollectionsExt.nonNull((Set)object.getIdentifiers()).iterator();
            while (iterator.hasNext() && (name = IdentifiedObjects.toString(id = (Identifier)iterator.next(), locale)) == null) {
            }
        }
        return name;
    }

    public static Optional<Extent> getDomainOfValidity(IdentifiedObject object) {
        Extent domain = null;
        if (object != null) {
            for (DefaultObjectDomain obj : Legacy.getDomains(object)) {
                domain = Extents.intersection(domain, (Extent)obj.getDomainOfValidity());
            }
        }
        return Optional.ofNullable(domain);
    }

    public static Optional<GeographicBoundingBox> getGeographicBoundingBox(IdentifiedObject object) {
        if (object == null) {
            return Optional.empty();
        }
        return Extents.getGeographicBoundingBox(Legacy.getDomains(object).stream().map(DefaultObjectDomain::getDomainOfValidity));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String lookupURN(IdentifiedObject object, Citation authority) throws FactoryException {
        List components;
        IdentifiedObjectFinder finder;
        if (object == null) {
            return null;
        }
        try {
            finder = IdentifiedObjects.newFinder(Citations.toCodeSpace((Citation)authority));
        }
        catch (NoSuchAuthorityFactoryException e) {
            IdentifiedObjects.warning("lookupURN", (Exception)((Object)e));
            finder = IdentifiedObjects.newFinder(null);
        }
        String urn = IdentifiedObjects.lookupURN(object, authority, finder);
        if (urn != null) {
            return urn;
        }
        if (object instanceof CompoundCRS) {
            components = CRS.getSingleComponents((CoordinateReferenceSystem)((CompoundCRS)object));
        } else {
            if (!(object instanceof ConcatenatedOperation)) return null;
            ConcatenatedOperation cop = (ConcatenatedOperation)object;
            List steps = cop.getOperations();
            if (!CRS.equivalent(cop.getSourceCRS(), ((CoordinateOperation)JDK21.getFirst((List)steps)).getSourceCRS())) return null;
            if (!CRS.equivalent(cop.getTargetCRS(), ((CoordinateOperation)JDK21.getLast((List)steps)).getTargetCRS())) return null;
            components = steps;
        }
        StringBuilder buffer = null;
        for (IdentifiedObject component : components) {
            urn = IdentifiedObjects.lookupURN(component, authority, finder);
            if (urn == null) {
                return null;
            }
            assert (urn.startsWith("urn:ogc:def")) : urn;
            if (buffer == null) {
                buffer = new StringBuilder(40).append("urn:ogc:def").append(':').append(NameMeaning.toObjectType((Class)object.getClass()));
            }
            buffer.append(',').append(urn, "urn:ogc:def".length() + 1, urn.length());
        }
        if (buffer == null) return null;
        String string = buffer.toString();
        return string;
    }

    private static String lookupURN(IdentifiedObject object, Citation authority, IdentifiedObjectFinder finder) throws FactoryException {
        String urn = null;
        if (object != null) {
            try {
                for (IdentifiedObject candidate : finder.find(object)) {
                    String c = IdentifiedObjects.toURN(candidate.getClass(), IdentifiedObjects.getIdentifier(candidate, authority));
                    if (c == null && authority == null) {
                        for (Identifier id : candidate.getIdentifiers()) {
                            c = IdentifiedObjects.toURN(candidate.getClass(), id);
                            if (c == null) continue;
                            break;
                        }
                    }
                    if (c == null) continue;
                    if (urn != null && !urn.equals(c)) {
                        return null;
                    }
                    urn = c;
                }
            }
            catch (BackingStoreException e) {
                throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
            }
        }
        return urn;
    }

    public static Integer lookupEPSG(IdentifiedObject object) throws FactoryException {
        Integer code = null;
        if (object != null) {
            try {
                for (IdentifiedObject candidate : IdentifiedObjects.newFinder("EPSG").find(object)) {
                    Identifier id = IdentifiedObjects.getIdentifier(candidate, (Citation)Citations.EPSG);
                    if (id == null) continue;
                    try {
                        Integer previous = code;
                        code = Integer.valueOf(id.getCode());
                        if (previous == null || previous.equals(code)) continue;
                        return null;
                    }
                    catch (NumberFormatException e) {
                        IdentifiedObjects.warning("lookupEPSG", e);
                    }
                }
            }
            catch (BackingStoreException e) {
                throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
            }
        }
        return code;
    }

    private static void warning(String method, Exception e) {
        Logging.recoverableException((Logger)CRS.LOGGER, IdentifiedObjects.class, (String)method, (Throwable)e);
    }

    public static IdentifiedObjectFinder newFinder(String authority) throws NoSuchAuthorityFactoryException, FactoryException {
        GeodeticAuthorityFactory factory;
        if (authority == null) {
            factory = AuthorityFactories.ALL;
        } else {
            if (authority.equalsIgnoreCase("EPSG")) {
                return AuthorityFactories.finderForEPSG();
            }
            factory = AuthorityFactories.ALL.getAuthorityFactory(GeodeticAuthorityFactory.class, authority, null);
        }
        return ((GeodeticAuthorityFactory)factory).newIdentifiedObjectFinder();
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject object, String name) {
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).isHeuristicMatchForName(name);
        }
        return NameToIdentifier.isHeuristicMatchForName((Identifier)object.getName(), (Collection)object.getAlias(), (CharSequence)name, (NameToIdentifier.Simplifier)NameToIdentifier.Simplifier.DEFAULT);
    }

    public static String toURN(Class<?> type, Identifier identifier) {
        ArgumentChecks.ensureNonNull((String)"type", type);
        if (identifier == null) {
            return null;
        }
        String cs = null;
        if (identifier instanceof ReferenceIdentifier) {
            cs = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (Strings.isNullOrEmpty(cs)) {
            cs = Identifiers.getIdentifier((Citation)identifier.getAuthority(), (boolean)true);
        }
        return NameMeaning.toURN(type, (String)cs, (String)(identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getVersion() : null), (String)identifier.getCode());
    }

    public static String toString(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName) {
            return identifier.toString();
        }
        String code = identifier.getCode();
        String cs = null;
        if (identifier instanceof ReferenceIdentifier) {
            cs = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (Strings.isNullOrEmpty(cs)) {
            cs = Citations.toCodeSpace((Citation)identifier.getAuthority());
        }
        if (cs != null) {
            return cs + ":" + code;
        }
        return code;
    }

    private static String toString(Identifier identifier, Locale locale) {
        String name;
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName && (name = IdentifiedObjects.toString((GenericName)((GenericName)identifier).tip(), locale)) != null) {
            return name;
        }
        return Strings.trimOrNull((String)identifier.getCode());
    }

    private static String toString(GenericName name, Locale locale) {
        String s;
        InternationalString i18n;
        if (name == null) {
            return null;
        }
        if (locale != null && (i18n = name.toInternationalString()) != null && (s = Strings.trimOrNull((String)i18n.toString(locale))) != null) {
            return s;
        }
        return Strings.trimOrNull((String)name.toString());
    }
}

