/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sis.util.internal.shared.SetOfUnknownSize;

public abstract class LazySet<E>
extends SetOfUnknownSize<E> {
    private Iterator<? extends E> sourceIterator;
    private E[] cachedElements;
    private int numCached;

    protected LazySet() {
    }

    protected abstract Iterator<? extends E> createSourceIterator();

    protected E[] initialValues() {
        return null;
    }

    private boolean createCache() {
        this.cachedElements = this.initialValues();
        if (this.cachedElements != null) {
            this.numCached = this.cachedElements.length;
            if (this.numCached != 0) {
                return true;
            }
        }
        this.cachedElements = new Object[4];
        return false;
    }

    private boolean canPullMore() {
        if (this.sourceIterator == null && this.cachedElements == null) {
            this.sourceIterator = this.createSourceIterator();
            if (this.createCache()) {
                return true;
            }
        }
        if (this.sourceIterator != null) {
            if (this.sourceIterator.hasNext()) {
                return true;
            }
            this.sourceIterator = null;
        }
        return false;
    }

    public final synchronized boolean isEmpty() {
        return this.numCached == 0 && !this.canPullMore();
    }

    public final synchronized int size() {
        if (this.canPullMore()) {
            while (this.sourceIterator.hasNext()) {
                this.cache(this.sourceIterator.next());
            }
            this.sourceIterator = null;
        }
        return this.numCached;
    }

    private void cache(E element) {
        if (this.cachedElements == null) {
            this.createCache();
        }
        if (this.numCached >= this.cachedElements.length) {
            this.cachedElements = Arrays.copyOf(this.cachedElements, this.numCached << 1);
        }
        this.cachedElements[this.numCached++] = element;
    }

    private synchronized boolean exists(int index) {
        assert (index <= this.numCached) : index;
        return index < this.numCached || this.canPullMore();
    }

    private synchronized E get(int index) {
        assert (this.numCached <= this.cachedElements.length) : this.numCached;
        assert (index <= this.numCached) : index;
        if (index >= this.numCached) {
            if (this.canPullMore()) {
                this.cache(this.sourceIterator.next());
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.cachedElements[index];
    }

    public final Iterator<E> iterator() {
        return new Iterator<E>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return LazySet.this.exists(this.cursor);
            }

            @Override
            public E next() {
                return LazySet.this.get(this.cursor++);
            }
        };
    }

    public synchronized void reload() {
        this.sourceIterator = null;
        this.cachedElements = null;
        this.numCached = 0;
    }
}

