/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.util.Optional;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class LongitudeWraparound
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -4658152274068444690L;
    final NormalizedProjection projection;
    final double bound;
    final boolean negative;
    private final Inverse inverse;

    LongitudeWraparound(NormalizedProjection projection, double bound, double rotation) {
        this.projection = projection;
        this.bound = bound;
        this.negative = bound < 0.0;
        this.inverse = new Inverse(this, rotation - bound);
    }

    static double boundOfScaledLongitude(MatrixSIS normalize, boolean negative) {
        DoubleDouble bound = DoubleDouble.of((Number)normalize.getNumber(0, 0), (boolean)true);
        bound = bound.multiply(negative ? -180.0 : 180.0, false);
        return bound.doubleValue();
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition criteria) throws TransformException {
        return this.projection.getDomain(criteria);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.projection.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.projection.getParameterValues();
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.projection.getContextualParameters();
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double \u03bb = srcPts[srcOff];
        if (this.negative ? \u03bb < this.bound : \u03bb > this.bound) {
            if (dstPts == null) {
                dstPts = new double[2];
                dstOff = 0;
            }
            dstPts[dstOff + 1] = srcPts[srcOff + 1];
            dstPts[dstOff] = \u03bb - 2.0 * this.bound;
            return this.projection.transform(dstPts, dstOff, dstPts, dstOff, derivate);
        }
        return this.projection.transform(srcPts, srcOff, dstPts, dstOff, derivate);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
        double period = 2.0 * this.bound;
        int stop = dstOff + numPts * 2;
        for (int i = dstOff; i < stop; i += 2) {
            double \u03bb = dstPts[i];
            if (!(this.negative ? \u03bb < this.bound : \u03bb > this.bound)) continue;
            dstPts[i] = \u03bb - period;
        }
        this.projection.transform(dstPts, dstOff, dstPts, dstOff, numPts);
    }

    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        return this.projection.hashCode() + Double.hashCode(this.bound);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object instanceof LongitudeWraparound) {
            LongitudeWraparound that = (LongitudeWraparound)object;
            return Numerics.epsilonEqual((double)this.bound, (double)that.bound, (ComparisonMode)mode) && this.projection.equals(that.projection, mode);
        }
        return false;
    }

    private static final class Inverse
    extends AbstractMathTransform2D.Inverse
    implements Serializable {
        private static final long serialVersionUID = -543869926271003589L;
        private final LongitudeWraparound forward;
        private final double bound;

        Inverse(LongitudeWraparound forward, double bound) {
            this.forward = forward;
            this.bound = bound;
        }

        @Override
        public MathTransform2D inverse() {
            return this.forward;
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            if (derivate && dstPts == null) {
                dstPts = new double[2];
                dstOff = 0;
            }
            this.forward.projection.inverseTransform(srcPts, srcOff, dstPts, dstOff);
            MatrixSIS d = derivate ? Matrices.inverse(this.forward.transform(dstPts, dstOff, null, 0, true)) : null;
            double \u03bb = dstPts[dstOff];
            if (this.forward.negative ? \u03bb > this.bound : \u03bb < this.bound) {
                dstPts[dstOff] = \u03bb + 2.0 * this.forward.bound;
            }
            return d;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (srcPts == dstPts && srcOff < dstOff) {
                super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            } else {
                double period = 2.0 * this.forward.bound;
                while (--numPts >= 0) {
                    this.forward.projection.inverseTransform(srcPts, srcOff, dstPts, dstOff);
                    double \u03bb = dstPts[dstOff];
                    if (this.forward.negative ? \u03bb > this.bound : \u03bb < this.bound) {
                        dstPts[dstOff] = \u03bb + period;
                    }
                    srcOff += 2;
                    dstOff += 2;
                }
            }
        }
    }
}

