/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.IdentityTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public class TransformSeparator {
    protected final MathTransform transform;
    protected int[] sourceDimensions;
    protected int[] targetDimensions;
    final MathTransformFactory factory;
    private boolean isSourceExpandable;

    public TransformSeparator(MathTransform transform) {
        this(transform, null);
    }

    public TransformSeparator(MathTransform transform, MathTransformFactory factory) {
        this.transform = Objects.requireNonNull(transform);
        this.factory = ReferencingUtilities.nonNull(factory);
    }

    public void clear() {
        this.sourceDimensions = null;
        this.targetDimensions = null;
        this.isSourceExpandable = false;
    }

    private static int[] insert(int[] sequence, int dimension) throws IllegalArgumentException {
        if (sequence == null) {
            return new int[]{dimension};
        }
        assert (ArraysExt.isSorted((int[])sequence, (boolean)true));
        int i = Arrays.binarySearch(sequence, dimension);
        if (i < 0) {
            sequence = ArraysExt.insert((int[])sequence, (int)(i ^= 0xFFFFFFFF), (int)1);
            sequence[i] = dimension;
        }
        assert (Arrays.binarySearch(sequence, dimension) == i);
        return sequence;
    }

    private static int[] add(int[] sequence, int[] dimensions, int max) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"dimensions", (Object)dimensions);
        int offset = 0;
        int previous = -1;
        if (sequence != null && (offset = sequence.length) != 0) {
            previous = sequence[offset - 1];
            sequence = Arrays.copyOf(sequence, offset + dimensions.length);
            System.arraycopy(dimensions, 0, sequence, offset, dimensions.length);
        } else {
            sequence = (int[])dimensions.clone();
        }
        for (int i = offset; i < sequence.length; ++i) {
            String message = TransformSeparator.validate("dimensions", i - offset, previous, max, previous = sequence[i]);
            if (message == null) continue;
            throw new IllegalArgumentException(message);
        }
        return sequence;
    }

    static String validate(String name, int i, int previous, int max, int value) {
        if (value <= previous || value >= max) {
            return Errors.format((short)204, (Object)Strings.toIndexed((String)"dimensions", (int)i), (Object)(previous + 1), (Object)(max - 1), (Object)value);
        }
        return null;
    }

    private static int[] add(int[] sequence, int lower, int upper, int max) throws IllegalArgumentException {
        boolean isOutOfRange;
        if (lower < 0 || lower > upper) {
            throw new IllegalArgumentException(Errors.format((short)76, (Object)lower, (Object)upper));
        }
        int min = 0;
        int offset = 0;
        if (sequence != null && (offset = sequence.length) != 0) {
            min = sequence[offset - 1] + 1;
        }
        boolean bl = isOutOfRange = upper > max;
        if (isOutOfRange || lower < min) {
            throw new IllegalArgumentException(Errors.format((short)204, (Object)(isOutOfRange ? "upper" : "lower"), (Object)min, (Object)(max - 1), (Object)(isOutOfRange ? upper : lower)));
        }
        if (offset == 0) {
            sequence = ArraysExt.range((int)lower, (int)upper);
        } else {
            sequence = Arrays.copyOf(sequence, (offset -= lower) + upper);
            for (int i = lower; i < upper; ++i) {
                sequence[offset + i] = i;
            }
        }
        assert (TransformSeparator.containsAll(sequence, lower, upper));
        return sequence;
    }

    public void addSourceDimensions(int ... dimensions) throws IllegalArgumentException {
        this.sourceDimensions = TransformSeparator.add(this.sourceDimensions, dimensions, this.transform.getSourceDimensions());
    }

    public void addSourceDimensionRange(int lower, int upper) throws IllegalArgumentException {
        this.sourceDimensions = TransformSeparator.add(this.sourceDimensions, lower, upper, this.transform.getSourceDimensions());
    }

    public int[] getSourceDimensions() throws IllegalStateException {
        if (this.sourceDimensions != null) {
            return (int[])this.sourceDimensions.clone();
        }
        throw new IllegalStateException(Resources.format((short)69));
    }

    public void addTargetDimensions(int ... dimensions) throws IllegalArgumentException {
        this.targetDimensions = TransformSeparator.add(this.targetDimensions, dimensions, this.transform.getTargetDimensions());
    }

    public void addTargetDimensionRange(int lower, int upper) throws IllegalArgumentException {
        this.targetDimensions = TransformSeparator.add(this.targetDimensions, lower, upper, this.transform.getTargetDimensions());
    }

    public int[] getTargetDimensions() throws IllegalStateException {
        if (this.targetDimensions != null) {
            return (int[])this.targetDimensions.clone();
        }
        throw new IllegalStateException(Resources.format((short)69));
    }

    public boolean isSourceExpandable() {
        return this.isSourceExpandable;
    }

    public void setSourceExpandable(boolean enabled) {
        this.isSourceExpandable = enabled;
    }

    public MathTransform separate() throws FactoryException {
        MathTransform tr = this.transform;
        int[] specifiedSources = this.sourceDimensions;
        if (this.isSourceExpandable) {
            this.sourceDimensions = null;
        }
        if (this.sourceDimensions == null || TransformSeparator.containsAll(this.sourceDimensions, 0, tr.getSourceDimensions())) {
            if (this.targetDimensions != null && !TransformSeparator.containsAll(this.targetDimensions, 0, tr.getTargetDimensions())) {
                tr = this.filterTargetDimensions(tr, this.targetDimensions);
            }
            if (this.sourceDimensions == null) {
                this.sourceDimensions = ArraysExt.range((int)0, (int)this.transform.getSourceDimensions());
            }
            if (this.targetDimensions == null) {
                this.targetDimensions = ArraysExt.range((int)0, (int)this.transform.getTargetDimensions());
            }
        } else {
            int[] requested = this.targetDimensions;
            tr = this.filterSourceDimensions(tr, this.sourceDimensions);
            assert (ArraysExt.isSorted((int[])this.targetDimensions, (boolean)true));
            if (requested != null) {
                int[] inferred = this.targetDimensions;
                this.targetDimensions = requested;
                int[] subDimensions = new int[requested.length];
                for (int i = 0; i < requested.length; ++i) {
                    int r = requested[i];
                    int j = Arrays.binarySearch(inferred, r);
                    if (j < 0) {
                        throw new FactoryException(Resources.format((short)7, r));
                    }
                    subDimensions[i] = j;
                }
                tr = this.filterTargetDimensions(tr, subDimensions);
            }
        }
        int side = 0;
        int expected = this.sourceDimensions.length;
        int actual = tr.getSourceDimensions();
        if (actual == expected) {
            side = 1;
            expected = this.targetDimensions.length;
            actual = tr.getTargetDimensions();
            if (actual == expected) {
                if (specifiedSources == null || this.isSourceExpandable) {
                    tr = this.removeUnusedSourceDimensions(tr, specifiedSources);
                }
                return tr;
            }
        }
        throw new FactoryException(Resources.format((short)83, side, expected, actual));
    }

    protected MathTransform filterSourceDimensions(MathTransform step, int[] dimensions) throws FactoryException {
        MatrixSIS matrix;
        if (dimensions.length == 0) {
            return IdentityTransform.create(0);
        }
        int numSrc = step.getSourceDimensions();
        int numTgt = step.getTargetDimensions();
        int lower = dimensions[0];
        int upper = dimensions[dimensions.length - 1] + 1;
        if (lower == 0 && upper == numSrc && dimensions.length == numSrc) {
            this.targetDimensions = ArraysExt.range((int)0, (int)numTgt);
            return step;
        }
        if (step.isIdentity()) {
            this.targetDimensions = dimensions;
            return IdentityTransform.create(dimensions.length);
        }
        if (step instanceof ConcatenatedTransform) {
            ConcatenatedTransform ctr = (ConcatenatedTransform)step;
            MathTransform step1 = this.filterSourceDimensions(ctr.transform1, dimensions);
            MathTransform step2 = this.filterSourceDimensions(ctr.transform2, this.targetDimensions);
            return this.factory.createConcatenatedTransform(step1, step2);
        }
        if (step instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)step;
            int numSubSrc = passThrough.subTransform.getSourceDimensions();
            int numNewDim = passThrough.subTransform.getTargetDimensions() - numSubSrc;
            int subLower = passThrough.firstAffectedCoordinate;
            int subUpper = subLower + numSubSrc;
            int[] subDimensions = new int[dimensions.length];
            this.targetDimensions = null;
            int n = 0;
            for (int dim : dimensions) {
                if (dim >= subLower) {
                    if (dim < subUpper) {
                        subDimensions[n++] = dim - subLower;
                        continue;
                    }
                    dim += numNewDim;
                }
                this.targetDimensions = TransformSeparator.insert(this.targetDimensions, dim);
            }
            subDimensions = ArraysExt.resize((int[])subDimensions, (int)n);
            if (n == 0) {
                return IdentityTransform.create(dimensions.length);
            }
            int[] target = this.targetDimensions;
            MathTransform subTransform = this.filterSourceDimensions(passThrough.subTransform, subDimensions);
            for (int dim : this.targetDimensions) {
                target = TransformSeparator.insert(target, dim + subLower);
            }
            this.targetDimensions = target;
            if (TransformSeparator.containsAll(dimensions, lower, subLower) && TransformSeparator.containsAll(dimensions, subUpper, upper)) {
                int offset = subDimensions[0];
                assert (TransformSeparator.containsAll(subDimensions, offset, offset + subDimensions.length)) : offset;
                return this.factory.createPassThroughTransform(offset + subLower - lower, subTransform, Math.max(0, upper - subUpper));
            }
        }
        if ((matrix = MatrixSIS.castOrCopy(MathTransforms.getMatrix(step))) != null) {
            this.targetDimensions = null;
            int startOfRow = 0;
            boolean isLastRowAccepted = false;
            int numFilteredColumns = dimensions.length + 1;
            Object[] elements = new Number[(numTgt + 1) * numFilteredColumns];
            block2: for (int j = 0; j <= numTgt; ++j) {
                int filteredColumn = 0;
                for (int i = 0; i < numSrc; ++i) {
                    Number element = matrix.getNumber(j, i);
                    if (filteredColumn < dimensions.length && dimensions[filteredColumn] == i) {
                        elements[startOfRow + filteredColumn++] = element;
                        continue;
                    }
                    if (element.doubleValue() != 0.0) continue block2;
                }
                elements[startOfRow + filteredColumn++] = matrix.getNumber(j, numSrc);
                assert (filteredColumn == numFilteredColumns) : filteredColumn;
                startOfRow += numFilteredColumns;
                boolean bl = isLastRowAccepted = j == numTgt;
                if (isLastRowAccepted) continue;
                this.targetDimensions = TransformSeparator.insert(this.targetDimensions, j);
            }
            if (isLastRowAccepted) {
                if (this.targetDimensions == null) {
                    this.targetDimensions = ArraysExt.EMPTY_INT;
                    return MathTransforms.identity(0);
                }
                elements = (Number[])ArraysExt.resize((Object[])elements, (int)startOfRow);
                return this.factory.createAffineTransform((Matrix)Matrices.create(startOfRow / numFilteredColumns, numFilteredColumns, (Number[])elements));
            }
        }
        throw new FactoryException(Resources.format((short)59));
    }

    protected MathTransform filterTargetDimensions(MathTransform step, int[] dimensions) throws FactoryException {
        int numSrc = step.getSourceDimensions();
        int numTgt = step.getTargetDimensions();
        int lower = dimensions[0];
        int upper = dimensions[dimensions.length - 1];
        if (lower == 0 && upper == numTgt && dimensions.length == numTgt) {
            return step;
        }
        int removeAt = 0;
        int numRemoved = 0;
        if (step instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)step;
            int subLower = passThrough.firstAffectedCoordinate;
            int numSubTgt = passThrough.subTransform.getTargetDimensions();
            if (!TransformSeparator.containsAny(dimensions, subLower, subLower + numSubTgt)) {
                numTgt = numSrc;
                step = IdentityTransform.create(numTgt);
                removeAt = subLower;
                numRemoved = numSubTgt - passThrough.subTransform.getSourceDimensions();
            }
        }
        MatrixSIS matrix = Matrices.createZero(dimensions.length + 1, numTgt + 1);
        for (int j = 0; j < dimensions.length; ++j) {
            int i = dimensions[j];
            if (i >= removeAt) {
                i -= numRemoved;
            }
            matrix.setElement(j, i, 1.0);
        }
        matrix.setElement(dimensions.length, numTgt, 1.0);
        return this.factory.createConcatenatedTransform(step, this.factory.createAffineTransform((Matrix)matrix));
    }

    private MathTransform removeUnusedSourceDimensions(MathTransform head, int[] required) {
        MathTransform transform1;
        MathTransform reduced;
        Matrix m = MathTransforms.getMatrix(head);
        if (m != null) {
            int numRows = m.getNumRow();
            int dimension = m.getNumCol() - 1;
            int retainedCount = 0;
            int[] retainedDimensions = new int[dimension];
            block0: for (int i = 0; i < dimension; ++i) {
                if (required != null && Arrays.binarySearch(required, i) >= 0) {
                    retainedDimensions[retainedCount++] = i;
                    continue;
                }
                for (int j = 0; j < numRows; ++j) {
                    if (m.getElement(j, i) == 0.0) continue;
                    retainedDimensions[retainedCount++] = i;
                    continue block0;
                }
            }
            if (retainedCount != dimension) {
                retainedDimensions = Arrays.copyOf(retainedDimensions, retainedCount);
                int upper = dimension;
                int i = retainedCount;
                while (--i >= -1) {
                    int keep = i >= 0 ? retainedDimensions[i] : -1;
                    int lower = keep + 1;
                    if (lower != upper) {
                        m = MatrixSIS.castOrCopy(m).removeColumns(lower, upper);
                    }
                    upper = keep;
                }
                for (i = 0; i < retainedCount; ++i) {
                    retainedDimensions[i] = this.sourceDimensions[retainedDimensions[i]];
                }
                this.sourceDimensions = retainedDimensions;
                return MathTransforms.linear(m);
            }
        } else if (head instanceof ConcatenatedTransform && (reduced = this.removeUnusedSourceDimensions(transform1 = ((ConcatenatedTransform)head).transform1, required)) != transform1) {
            return MathTransforms.concatenate(reduced, ((ConcatenatedTransform)head).transform2);
        }
        return head;
    }

    private static boolean containsAll(int[] sequence, int lower, int upper) {
        if (lower >= upper) {
            return true;
        }
        if (sequence != null) {
            assert (ArraysExt.isSorted((int[])sequence, (boolean)true));
            int index = Arrays.binarySearch(sequence, lower);
            if (index >= 0 && (index += --upper - lower) >= 0 && index < sequence.length) {
                return sequence[index] == upper;
            }
        }
        return false;
    }

    private static boolean containsAny(int[] sequence, int lower, int upper) {
        if (upper == lower) {
            return true;
        }
        if (sequence != null) {
            assert (ArraysExt.isSorted((int[])sequence, (boolean)true));
            int index = Arrays.binarySearch(sequence, lower);
            if (index >= 0) {
                return true;
            }
            return (index ^= 0xFFFFFFFF) < sequence.length && sequence[index] < upper;
        }
        return false;
    }
}

