/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.Prefixes;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.shared.DefinitionURI;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public class UnitFormat
extends Format
implements javax.measure.format.UnitFormat,
Localized {
    private static final long serialVersionUID = -3064428584419360693L;
    private static final String[] AUTHORITIES = new String[]{"EPSG", "UCUM"};
    private static final String DEGREES = "degrees";
    private static final String UNITY = "unity";
    static final UnitFormat INSTANCE = new UnitFormat();
    private Locale locale;
    private Style style;
    private final Map<Unit<?>, String> unitToLabel;
    private final Map<String, Unit<?>> labelToUnit;
    private volatile transient ResourceBundle symbolToName;
    private volatile transient Map<String, Unit<?>> nameToUnit;
    private static final WeakValueHashMap<Locale, Map<String, Unit<?>>> SHARED = new WeakValueHashMap(Locale.class);

    private UnitFormat() {
        this.locale = Locale.ROOT;
        this.style = Style.SYMBOL;
        this.unitToLabel = Map.of();
        this.labelToUnit = Map.of();
    }

    public UnitFormat(Locale locale) {
        this.locale = Objects.requireNonNull(locale);
        this.style = Style.SYMBOL;
        this.unitToLabel = new HashMap();
        this.labelToUnit = new HashMap();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = Objects.requireNonNull(locale);
        this.symbolToName = null;
        this.nameToUnit = null;
    }

    public boolean isLocaleSensitive() {
        return this.style == Style.NAME;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = Objects.requireNonNull(style);
    }

    public void label(Unit<?> unit, String label) {
        int c;
        ArgumentChecks.ensureNonNull("unit", unit);
        label = label.strip();
        ArgumentChecks.ensureNonEmpty("label", label);
        for (int i = 0; i < label.length(); i += Character.charCount(c)) {
            c = label.codePointAt(i);
            if (AbstractUnit.isSymbolChar(c) || Character.isSpaceChar(c)) continue;
            throw new IllegalArgumentException(Errors.format((short)59, "label", label));
        }
        Object labeledUnit = unit;
        if (labeledUnit instanceof ConventionalUnit) {
            labeledUnit = ((ConventionalUnit)labeledUnit).alternate(label);
        }
        Unit<?> unitForOldLabel = this.labelToUnit.remove(this.unitToLabel.put(unit, label));
        Unit<?> oldUnitForLabel = this.labelToUnit.put(label, (Unit<?>)labeledUnit);
        if (oldUnitForLabel != null && !oldUnitForLabel.equals(labeledUnit) && !label.equals(this.unitToLabel.remove(oldUnitForLabel))) {
            throw new CorruptedObjectException("unitToLabel");
        }
        if (unitForOldLabel != null && !unitForOldLabel.getSystemUnit().equals((Object)unit.getSystemUnit())) {
            throw new CorruptedObjectException("labelToUnit");
        }
    }

    static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("org.apache.sis.measure.UnitNames", locale, UnitFormat.class.getClassLoader());
    }

    private ResourceBundle symbolToName() {
        ResourceBundle r = this.symbolToName;
        if (r == null) {
            this.symbolToName = r = UnitFormat.getBundle(this.locale);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit<?> fromName(String uom) {
        Map<String, Unit<?>> map;
        int length = uom.length();
        int i = 0;
        while (true) {
            if (i != DEGREES.length()) {
                if (i == length || (uom.charAt(i) | 0x20) != DEGREES.charAt(i)) {
                    if (i != 3 && i != 6) break;
                }
            } else {
                if (length == i) {
                    return Units.DEGREE;
                }
                int c = uom.codePointAt(i);
                if (c == 95 || Character.isSpaceChar(c)) {
                    i += Character.charCount(c);
                }
                if (length - i != 1) break;
                switch (uom.charAt(i)) {
                    case 'K': 
                    case '\u212a': {
                        return Units.KELVIN;
                    }
                    case 'C': {
                        return Units.CELSIUS;
                    }
                    case 'E': 
                    case 'N': {
                        return Units.DEGREE;
                    }
                }
                break;
            }
            ++i;
        }
        if ((map = this.nameToUnit) == null) {
            map = SHARED.get(this.locale);
            if (map == null) {
                map = new HashMap(128);
                UnitFormat.copy(this.locale, this.symbolToName(), map);
                if (!this.locale.equals(Locale.US)) {
                    UnitFormat.copy(Locale.US, UnitFormat.getBundle(Locale.US), map);
                }
                if (!this.locale.equals(Locale.ROOT)) {
                    UnitFormat.copy(Locale.ROOT, UnitFormat.getBundle(Locale.ROOT), map);
                }
                ResourceBundle r = ResourceBundle.getBundle("org.apache.sis.measure.UnitAliases", this.locale, UnitFormat.class.getClassLoader());
                for (String name : r.keySet()) {
                    map.put(name.intern(), Units.get(r.getString(name)));
                }
                map = Collections.unmodifiableMap(map);
                WeakValueHashMap<Locale, Map<String, Unit<?>>> weakValueHashMap = SHARED;
                synchronized (weakValueHashMap) {
                    for (Map<String, Unit<?>> existing : SHARED.values()) {
                        if (!map.equals(existing)) continue;
                        map = existing;
                        break;
                    }
                    SHARED.put(this.locale, map);
                }
            }
            this.nameToUnit = map;
        }
        uom = uom.replace('_', ' ').toLowerCase(this.locale);
        Unit unit = map.get(uom = UnitFormat.removePlural(CharSequences.toASCII(uom)));
        if (unit == null) {
            int s = uom.length();
            if (--s > 0 && UnitFormat.isDigit(uom.charAt(s))) {
                while (--s >= 0) {
                    if (UnitFormat.isDigit(uom.charAt(s))) continue;
                    if (uom.charAt(s) == '-' && --s < 0 || (unit = map.get(uom.substring(0, ++s))) == null) break;
                    unit = unit.pow(Integer.parseInt(uom.substring(s)));
                    break;
                }
            }
        }
        return unit;
    }

    private static void copy(Locale locale, ResourceBundle symbolToName, Map<String, Unit<?>> nameToUnit) {
        for (String symbol : symbolToName.keySet()) {
            String name = CharSequences.toASCII(symbolToName.getString(symbol).toLowerCase(locale)).toString().intern();
            nameToUnit.put(UnitFormat.removePlural(name), Units.get(symbol));
        }
    }

    private static String removePlural(CharSequence uom) {
        uom = CharSequences.replace(uom, DEGREES, "degree");
        uom = CharSequences.replace(uom, "radians", "radian");
        uom = CharSequences.replace(uom, "seconds", "second");
        uom = CharSequences.replace(uom, "meters", "meter");
        uom = CharSequences.replace(uom, "metres", "metre");
        return uom.toString();
    }

    public Appendable format(Unit<?> unit, Appendable toAppendTo) throws IOException {
        Map<SystemUnit<?>, Fraction> components;
        Map<SystemUnit<?>, Number> c;
        String symbol;
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureNonNull("toAppendTo", toAppendTo);
        String label = this.unitToLabel.get(unit);
        if (label != null) {
            return toAppendTo.append(label);
        }
        if (this.style == Style.NAME) {
            if (!(unit instanceof AbstractUnit)) {
                label = unit.getName();
                if (label != null) {
                    return toAppendTo.append(label);
                }
            } else {
                label = unit.getSymbol();
                if (label != null) {
                    if (label.isEmpty()) {
                        label = UNITY;
                    }
                    ResourceBundle names = this.symbolToName();
                    try {
                        label = names.getString(label);
                    }
                    catch (MissingResourceException e) {
                        Logging.ignorableException(AbstractUnit.LOGGER, UnitFormat.class, "format", e);
                    }
                    return toAppendTo.append(label);
                }
            }
        }
        if ((symbol = unit.getSymbol()) != null) {
            return this.style.appendSymbol(toAppendTo, symbol);
        }
        Unit unscaled = unit.getSystemUnit();
        double scale = AbstractConverter.scale(unit.getConverterTo(unscaled));
        if (Double.isNaN(scale)) {
            throw new IllegalArgumentException(Errors.format((short)131, "?\u22c5(" + String.valueOf(unscaled) + ")"));
        }
        int prefixPower = 0;
        boolean hasNumerator = false;
        if (unscaled instanceof AbstractUnit) {
            components = c = ((AbstractUnit)unscaled).getBaseSystemUnits();
            for (Map.Entry<SystemUnit<?>, Fraction> e : c.entrySet()) {
                Fraction power = e.getValue();
                if (power.signum() <= 0) continue;
                hasNumerator = true;
                if (prefixPower == 0 && power.denominator == 1 && e.getKey().isPrefixable()) {
                    prefixPower = power.numerator;
                    continue;
                }
                prefixPower = 0;
                break;
            }
        } else {
            c = unscaled.getBaseUnits();
            if (c == null) {
                c = Map.of(unit, 1);
            }
            components = c;
            for (Map.Entry<SystemUnit<?>, Fraction> e : c.entrySet()) {
                int power = (Integer)((Object)e.getValue());
                if (power <= 0) continue;
                hasNumerator = true;
                if (prefixPower == 0 && AbstractUnit.isPrefixable((Unit)e.getKey())) {
                    prefixPower = power;
                    continue;
                }
                prefixPower = 0;
                break;
            }
        }
        if (scale != 1.0) {
            char prefix = Prefixes.symbol(scale, prefixPower);
            if (prefix != '\u0000') {
                toAppendTo.append(Prefixes.concat(prefix, ""));
            } else {
                double power;
                boolean asPowerOf10;
                boolean bl = asPowerOf10 = this.style != Style.UCUM;
                if (asPowerOf10 && (asPowerOf10 = AbstractConverter.epsilonEquals(power = Math.log10(scale), power = (double)Math.round(power)))) {
                    toAppendTo.append("10");
                    String text = Integer.toString((int)power);
                    for (int i = 0; i < text.length(); ++i) {
                        toAppendTo.append(Characters.toSuperScript(text.charAt(i)));
                    }
                }
                if (!asPowerOf10) {
                    String text = Double.toString(scale);
                    int length = text.length();
                    if (text.endsWith(".0")) {
                        length -= 2;
                    }
                    toAppendTo.append(text, 0, length);
                }
                if (hasNumerator) {
                    toAppendTo.append(this.style.multiply);
                }
            }
        } else if (!hasNumerator) {
            toAppendTo.append('1');
        }
        UnitFormat.formatComponents(components, this.style, toAppendTo);
        return toAppendTo;
    }

    static void formatComponents(Map<?, ? extends Number> components, Style style, Appendable toAppendTo) throws IOException {
        boolean isFirst = true;
        ArrayList deferred = new ArrayList(components.size());
        for (Map.Entry<?, Number> entry : components.entrySet()) {
            int n;
            Number number = entry.getValue();
            int n2 = n = number instanceof Fraction ? ((Fraction)number).numerator : number.intValue();
            if (n > 0) {
                if (!isFirst) {
                    toAppendTo.append(style.multiply);
                }
                isFirst = false;
                UnitFormat.formatComponent(entry, false, style, toAppendTo);
                continue;
            }
            if (n == 0) continue;
            deferred.add(entry);
        }
        if (!deferred.isEmpty()) {
            boolean useParenthesis;
            toAppendTo.append(style.divide);
            boolean bl = useParenthesis = deferred.size() > 1;
            if (useParenthesis) {
                toAppendTo.append('(');
            }
            isFirst = true;
            for (Map.Entry entry : deferred) {
                if (!isFirst) {
                    toAppendTo.append(style.multiply);
                }
                isFirst = false;
                UnitFormat.formatComponent(entry, true, style, toAppendTo);
            }
            if (useParenthesis) {
                toAppendTo.append(')');
            }
        }
    }

    private static void formatComponent(Map.Entry<?, ? extends Number> entry, boolean inverse, Style style, Appendable toAppendTo) throws IOException {
        int n;
        UnitFormat.formatSymbol(entry.getKey(), style, toAppendTo);
        Number power = entry.getValue();
        if (power instanceof Fraction) {
            Fraction f = (Fraction)power;
            if (f.denominator != 1) {
                if (inverse) {
                    f = f.negate();
                }
                style.appendPower(toAppendTo, f);
                return;
            }
            n = f.numerator;
        } else {
            n = power.intValue();
        }
        if (inverse) {
            n = -n;
        }
        if (n != 1) {
            style.appendPower(toAppendTo, n);
        }
    }

    private static void formatSymbol(Object base, Style style, Appendable toAppendTo) throws IOException {
        char symbol;
        if (base instanceof UnitDimension && (symbol = ((UnitDimension)base).symbol) != '\u0000') {
            toAppendTo.append(symbol);
            return;
        }
        if (base instanceof Unit && (symbol = ((Unit)base).getSymbol()) != null) {
            style.appendSymbol(toAppendTo, symbol);
            return;
        }
        toAppendTo.append("?");
    }

    @Override
    public StringBuffer format(Object unit, StringBuffer toAppendTo, FieldPosition pos) {
        try {
            return (StringBuffer)this.format((Unit)unit, toAppendTo);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String format(Unit<?> unit) {
        try {
            return this.format(unit, new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int exponentOperator(CharSequence symbols, int i, int length) {
        if (i >= 0 && ++i < length) {
            char c = symbols.charAt(i);
            if (c == '*') {
                return 1;
            }
            if ((UnitFormat.isDigit(c) || UnitFormat.isSign(c)) && UnitFormat.isDigit(symbols.charAt(i - 2))) {
                return 0;
            }
        }
        return -1;
    }

    private static boolean isDecimalSeparator(CharSequence symbols, int i, int length) {
        return i == 0 || UnitFormat.isDigit(symbols.charAt(i - 1)) && (++i >= length || UnitFormat.isDigit(symbols.charAt(i)));
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isSign(int c) {
        return c == 43 || c == 45;
    }

    private static boolean isDivisor(int c) {
        return c == 47 || c == 8725;
    }

    private static boolean hasDigit(CharSequence symbol, int lower, int upper) {
        while (lower < upper) {
            if (!UnitFormat.isDigit(symbol.charAt(lower++))) continue;
            return true;
        }
        return false;
    }

    private static void finish(ParsePosition pos) {
        if (pos instanceof Position) {
            ((Position)pos).finished = true;
        }
    }

    public Unit<?> parse(CharSequence symbols) throws MeasurementParseException {
        int unrecognized;
        Position position = new Position();
        Unit unit = this.parse(symbols, position);
        int length = symbols.length();
        while ((unrecognized = CharSequences.skipLeadingWhitespaces(symbols, position.getIndex(), length)) < length) {
            if (position.finished || !Character.isLetter(Character.codePointAt(symbols, unrecognized))) {
                throw new MeasurementParseException(Errors.format((short)166, CharSequences.trimWhitespaces(symbols, 0, unrecognized), CharSequences.trimWhitespaces(symbols, unrecognized, length)), symbols, unrecognized);
            }
            position.setIndex(unrecognized);
            unit = unit.multiply(this.parse(symbols, position));
        }
        return unit;
    }

    public Unit<?> parse(CharSequence symbols, ParsePosition position) throws MeasurementParseException {
        int i;
        int n;
        Map.Entry<Integer, String> entry;
        ArgumentChecks.ensureNonNull("symbols", symbols);
        ArgumentChecks.ensureNonNull("position", position);
        int end = symbols.length();
        int start = CharSequences.skipLeadingWhitespaces(symbols, position.getIndex(), end);
        if (AUTHORITIES != null && (entry = DefinitionURI.codeOf("uom", AUTHORITIES, symbols)) != null) {
            Unit<?> unit = null;
            NumberFormatException failure = null;
            String code = entry.getValue();
            switch (entry.getKey()) {
                case 0: {
                    try {
                        unit = Units.valueOfEPSG(Integer.parseInt(code));
                    }
                    catch (NumberFormatException e) {
                        failure = e;
                    }
                    break;
                }
                case 1: {
                    unit = this.parse(code);
                }
            }
            if (unit != null) {
                position.setIndex(end);
                UnitFormat.finish(position);
                return unit;
            }
            throw (MeasurementParseException)new MeasurementParseException(Errors.format((short)183, "EPSG:" + code), symbols, start + Math.max(0, symbols.toString().lastIndexOf(code))).initCause((Throwable)failure);
        }
        Operation operation = new Operation(symbols);
        Unit<?> unit = null;
        boolean hasSpaces = false;
        block15: for (i = start; i < end; i += n) {
            int next;
            int c = Character.codePointAt(symbols, i);
            n = Character.charCount(c);
            switch (c) {
                case 45: {
                    if (i + n < end && Character.isDigit(Character.codePointAt(symbols, i + n))) continue block15;
                }
                default: {
                    if (AbstractUnit.isSymbolChar(c)) {
                        if (operation.code != 1) continue block15;
                        operation.code = 2;
                        continue block15;
                    }
                    if (Character.isDigit(c) || Characters.isSuperScript(c)) continue block15;
                    if (!Character.isSpaceChar(c)) break block15;
                    hasSpaces = true;
                    continue block15;
                }
                case 42: {
                    int w = UnitFormat.exponentOperator(symbols, i, end);
                    if (w < 0) {
                        next = 2;
                        break;
                    }
                    i += w;
                }
                case 94: {
                    if (operation.code != 1) continue block15;
                    next = 4;
                    break;
                }
                case 46: {
                    if (UnitFormat.isDecimalSeparator(symbols, i, end)) continue block15;
                }
                case 215: 
                case 8901: {
                    next = 2;
                    break;
                }
                case 47: 
                case 247: 
                case 8260: 
                case 8725: {
                    next = 3;
                    break;
                }
                case 40: {
                    int pos = i + Character.charCount(c);
                    ParsePosition sub = new ParsePosition(pos);
                    Unit<?> term = this.parse(symbols, sub);
                    i = CharSequences.skipLeadingWhitespaces(symbols, sub.getIndex(), end);
                    if (i >= end || Character.codePointAt(symbols, i) != 41) {
                        throw new MeasurementParseException(Errors.format((short)127, symbols.subSequence(start, i), Character.valueOf(')')), symbols, start);
                    }
                    unit = operation.apply(unit, term, pos);
                    operation.code = 1;
                    n = 1;
                    start = i + 1;
                    continue block15;
                }
            }
            if (i > start && i + n < end && Character.isDigit(Character.codePointBefore(symbols, i)) && Character.isDigit(Character.codePointAt(symbols, i + n))) continue;
            if (operation.code != 1) {
                unit = operation.apply(unit, this.parseTerm(symbols, start, i, operation), start);
            }
            hasSpaces = false;
            operation.code = next;
            start = i + n;
        }
        Unit<?> component = null;
        if (hasSpaces) {
            String uom;
            end = i;
            start = CharSequences.skipLeadingWhitespaces(symbols, start, i);
            block16: while ((i = CharSequences.skipTrailingWhitespaces(symbols, start, i)) > start && (component = this.labelToUnit.get(uom = symbols.subSequence(start, i).toString())) == null && (component = this.fromName(uom)) == null) {
                int c;
                int j = i;
                while ((j -= Character.charCount(c = Character.codePointBefore(symbols, j))) > start) {
                    if (!Character.isWhitespace(c)) continue;
                    i = j;
                    continue block16;
                }
                break block16;
            }
            if (UnitFormat.hasDigit(symbols, start, i)) {
                i = end;
            }
        }
        if (!(operation.finished = component != null)) {
            component = this.parseTerm(symbols, start, i, operation);
        }
        if (operation.finished) {
            UnitFormat.finish(position);
        }
        unit = operation.apply(unit, component, start);
        position.setIndex(i);
        return unit;
    }

    private Unit<?> parseTerm(CharSequence symbols, int lower, int upper, Operation operation) throws MeasurementParseException {
        String uom = CharSequences.trimWhitespaces(symbols, lower, upper).toString();
        Unit<?> unit = this.labelToUnit.get(uom);
        boolean bl = operation.finished = unit != null;
        if (unit == null && (unit = Prefixes.getUnit(uom)) == null) {
            int length = uom.length();
            if (length == 0) {
                return Units.UNITY;
            }
            char c = uom.charAt(0);
            if (UnitFormat.isDigit(c) || UnitFormat.isSign(c)) {
                double multiplier;
                try {
                    int next;
                    int s = uom.indexOf(32);
                    if (s >= 0 && (next = CharSequences.skipLeadingWhitespaces(uom, s, length)) < length && AbstractUnit.isSymbolChar(uom.codePointAt(next))) {
                        operation.finished = true;
                        double multiplier2 = Double.parseDouble(uom.substring(0, s));
                        return this.parseTerm(uom, s, length, new Operation(uom)).multiply(multiplier2);
                    }
                    multiplier = UnitFormat.parseMultiplicationFactor(uom);
                }
                catch (NumberFormatException e) {
                    throw (MeasurementParseException)new MeasurementParseException(Errors.format((short)183, uom), symbols, lower).initCause((Throwable)e);
                }
                if (operation.code == 1) {
                    operation.code = 4;
                }
                return Units.UNITY.multiply(multiplier);
            }
            if (length >= 2) {
                Fraction power = null;
                int i = length;
                int c2 = uom.codePointBefore(i);
                i -= Character.charCount(c2);
                if (Characters.isSuperScript(c2)) {
                    if (UnitFormat.isDigit(c2 = Characters.toNormalScript(c2))) {
                        power = new Fraction(c2 - 48, 1);
                    }
                } else if (UnitFormat.isDigit(c2)) {
                    while (i != 0) {
                        boolean isExponent;
                        c2 = uom.codePointBefore(i);
                        boolean bl2 = isExponent = UnitFormat.isDigit(c2) || UnitFormat.isDivisor(c2);
                        if (isExponent || UnitFormat.isSign(c2)) {
                            i -= Character.charCount(c2);
                        }
                        if (isExponent) continue;
                        try {
                            power = new Fraction(uom.substring(i));
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw (MeasurementParseException)new MeasurementParseException(Errors.format((short)183, uom), symbols, lower + i).initCause((Throwable)e);
                        }
                    }
                }
                if (power != null) {
                    String symbol;
                    if ((i = CharSequences.skipTrailingWhitespaces(uom, 0, i)) != 0) {
                        switch (uom.charAt(i - 1)) {
                            case '*': {
                                if (i != 1 && uom.charAt(i - 2) == '*') {
                                    --i;
                                }
                            }
                            case '^': {
                                i = CharSequences.skipTrailingWhitespaces(uom, 0, i - 1);
                            }
                        }
                    }
                    boolean bl3 = operation.finished = (unit = this.labelToUnit.get(symbol = uom.substring(CharSequences.skipLeadingWhitespaces(uom, 0, i), i))) != null;
                    if (unit == null) {
                        unit = Prefixes.getUnit(symbol);
                    }
                    if (unit != null) {
                        int numerator = power.numerator;
                        int denominator = power.denominator;
                        if (numerator < 0 && operation.invert()) {
                            numerator = -numerator;
                        }
                        if (numerator != 1) {
                            unit = unit.pow(numerator);
                        }
                        if (denominator != 1) {
                            unit = unit.root(denominator);
                        }
                        return unit;
                    }
                }
            }
            operation.finished = true;
            unit = this.fromName(uom);
            if (unit == null) {
                if (CharSequences.regionMatches(symbols, lower, UNITY, true)) {
                    return Units.UNITY;
                }
                throw new MeasurementParseException(Errors.format((short)183, uom), symbols, lower);
            }
        }
        return unit;
    }

    private static double parseMultiplicationFactor(String term) throws NumberFormatException {
        String exponent;
        int s = term.lastIndexOf(42);
        if (s >= 0 || (s = term.lastIndexOf(94)) >= 0) {
            exponent = term.substring(s + 1);
        } else {
            s = term.length();
            int c = term.codePointBefore(s);
            if (!Characters.isSuperScript(c)) {
                return Double.parseDouble(term);
            }
            StringBuilder buffer = new StringBuilder(s);
            do {
                buffer.appendCodePoint(Characters.toNormalScript(c));
            } while ((s -= Character.charCount(c)) > 0 && Characters.isSuperScript(c = term.codePointBefore(s)));
            exponent = buffer.reverse().toString();
        }
        int base = Integer.parseInt(term.substring(0, s));
        int exp = Integer.parseInt(exponent);
        return base == 10 ? MathFunctions.pow10(exp) : Math.pow(base, exp);
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        try {
            return this.parse(source);
        }
        catch (MeasurementParseException e) {
            throw (ParseException)new ParseException(e.getLocalizedMessage(), e.getPosition()).initCause(e);
        }
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        try {
            return this.parse(source, pos);
        }
        catch (MeasurementParseException e) {
            pos.setErrorIndex(e.getPosition());
            return null;
        }
    }

    @Override
    public UnitFormat clone() {
        UnitFormat f = (UnitFormat)super.clone();
        try {
            f.clone("unitToLabel");
            f.clone("labelToUnit");
        }
        catch (ReflectiveOperationException e) {
            throw (InaccessibleObjectException)new InaccessibleObjectException().initCause(e);
        }
        return f;
    }

    private void clone(String field) throws ReflectiveOperationException {
        Field f = UnitFormat.class.getDeclaredField(field);
        f.setAccessible(true);
        Object value = f.get(this);
        value = value instanceof HashMap ? ((HashMap)value).clone() : new HashMap();
        f.set(this, value);
    }

    public static enum Style {
        SYMBOL('\u22c5', '\u2215'),
        UCUM('.', '/'){

            @Override
            Appendable appendSymbol(Appendable toAppendTo, String value) throws IOException {
                if (value.startsWith("\u00b0")) {
                    int length = value.length();
                    if (length == 2) {
                        switch (value.charAt(1)) {
                            case 'C': {
                                return toAppendTo.append("Cel");
                            }
                            case 'K': 
                            case '\u212a': {
                                return toAppendTo.append('K');
                            }
                        }
                    }
                    return toAppendTo.append("deg").append(value, 1, length);
                }
                CharSequence cs = CharSequences.toASCII(value);
                int length = cs.length();
                for (int i = 0; i < length; ++i) {
                    toAppendTo.append(Characters.toNormalScript(cs.charAt(i)));
                }
                return toAppendTo;
            }

            @Override
            void appendPower(Appendable toAppendTo, int power) throws IOException {
                toAppendTo.append(String.valueOf(power));
            }

            @Override
            void appendPower(Appendable toAppendTo, Fraction power) throws IOException {
                toAppendTo.append('^').append('(').append(String.valueOf(power.numerator)).append('/').append(String.valueOf(power.denominator)).append(')');
            }
        }
        ,
        NAME('\u22c5', '\u2215');

        static final char EXPONENT_OR_MULTIPLY = '*';
        static final char EXPONENT = '^';
        static final char OPEN = '(';
        static final char CLOSE = ')';
        final char multiply;
        final char divide;

        private Style(char multiply, char divide) {
            this.multiply = multiply;
            this.divide = divide;
        }

        Appendable appendSymbol(Appendable toAppendTo, String value) throws IOException {
            return toAppendTo.append(value);
        }

        void appendPower(Appendable toAppendTo, int power) throws IOException {
            if (power >= 0 && power <= 9) {
                toAppendTo.append(Characters.toSuperScript((char)(power + 48)));
            } else {
                toAppendTo.append(String.valueOf(power));
            }
        }

        void appendPower(Appendable toAppendTo, Fraction power) throws IOException {
            toAppendTo.append('^');
            String value = power.toString();
            if (value.length() == 1) {
                toAppendTo.append(value);
            } else {
                toAppendTo.append('(').append(value).append(')');
            }
        }
    }

    private static final class Position
    extends ParsePosition {
        boolean finished;

        Position() {
            super(0);
        }
    }

    private static final class Operation {
        static final int NOOP = 0;
        static final int IMPLICIT = 1;
        static final int MULTIPLY = 2;
        static final int DIVIDE = 3;
        static final int EXPONENT = 4;
        int code;
        private final CharSequence symbols;
        boolean finished;

        Operation(CharSequence symbols) {
            this.symbols = symbols;
        }

        Unit<?> apply(Unit<?> unit, Unit<?> term, int position) {
            switch (this.code) {
                case 0: {
                    return term;
                }
                case 1: 
                case 2: {
                    return unit.multiply(term);
                }
                case 3: {
                    return unit.divide(term);
                }
                case 4: {
                    double scale;
                    int power;
                    if (UnitDimension.isDimensionless(term.getDimension()) && Strings.isNullOrEmpty(term.getSymbol()) && (double)(power = (int)(scale = Units.toStandardUnit(term))) == scale) {
                        return unit.pow(power);
                    }
                    throw new MeasurementParseException(Errors.format((short)140, term), this.symbols, position);
                }
            }
            throw new AssertionError(this.code);
        }

        boolean invert() {
            switch (this.code) {
                case 1: 
                case 2: {
                    this.code = 3;
                    return true;
                }
            }
            return false;
        }
    }
}

