/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.lang.reflect.Array;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import org.apache.sis.util.internal.shared.CloneAccess;
import org.apache.sis.util.resources.Errors;

public final class Cloner {
    private Class<?> type;
    private Method method;
    private final boolean isCloneRequired;
    private final IdentityHashMap<Object, Object> cloneResults;

    public Cloner() {
        this(true);
    }

    public Cloner(boolean isCloneRequired) {
        this.isCloneRequired = isCloneRequired;
        this.cloneResults = new IdentityHashMap();
    }

    private Object cloneArray(Object array, Class<?> componentType) throws CloneNotSupportedException {
        int length = Array.getLength(array);
        Object copy = Array.newInstance(componentType, length);
        if (this.cloneResults.put(array, copy) != null) {
            throw new ConcurrentModificationException();
        }
        if (componentType.isPrimitive()) {
            System.arraycopy(array, 0, copy, 0, length);
        } else {
            for (int i = 0; i < length; ++i) {
                Array.set(copy, i, this.clone(Array.get(array, i)));
            }
        }
        return copy;
    }

    public Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        Object result = this.cloneResults.get(object);
        if (result != null) {
            return result;
        }
        if (object instanceof CloneAccess) {
            result = ((CloneAccess)object).clone();
        } else {
            Class<?> valueType = object.getClass();
            Class<?> componentType = valueType.getComponentType();
            if (componentType != null) {
                return this.cloneArray(object, componentType);
            }
            RuntimeException security = null;
            result = object;
            try {
                if (valueType != this.type) {
                    this.method = valueType.getMethod("clone", null);
                    this.type = valueType;
                    if (!Modifier.isPublic(this.method.getDeclaringClass().getModifiers())) {
                        try {
                            this.method.setAccessible(true);
                        }
                        catch (SecurityException | InaccessibleObjectException e) {
                            security = e;
                        }
                    }
                }
                if (this.method != null) {
                    result = this.method.invoke(object, (Object[])null);
                }
            }
            catch (NoSuchMethodException e) {
                if (this.isCloneRequired) {
                    throw Cloner.fail(e, valueType);
                }
                this.method = null;
                this.type = valueType;
            }
            catch (IllegalAccessException e) {
                if (security != null) {
                    e.addSuppressed(security);
                }
                throw Cloner.fail(e, valueType);
            }
            catch (InvocationTargetException e) {
                Cloner.rethrow(e.getCause());
                throw Cloner.fail(e, valueType);
            }
            catch (SecurityException e) {
                throw Cloner.fail(e, valueType);
            }
        }
        if (this.cloneResults.put(object, result) != null) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    private static void rethrow(Throwable cause) throws CloneNotSupportedException {
        if (cause instanceof CloneNotSupportedException) {
            throw (CloneNotSupportedException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
    }

    private static CloneNotSupportedException fail(Throwable cause, Class<?> type) {
        return (CloneNotSupportedException)new CloneNotSupportedException(Errors.format((short)30, type)).initCause(cause);
    }

    public static Object cloneIfPublic(Object object) throws CloneNotSupportedException {
        if (object instanceof CloneAccess) {
            return ((CloneAccess)object).clone();
        }
        Class<?> type = object.getClass();
        Class<?> componentType = type.getComponentType();
        if (componentType != null) {
            if (componentType.isPrimitive()) {
                int length = Array.getLength(object);
                Object copy = Array.newInstance(componentType, length);
                System.arraycopy(object, 0, copy, 0, length);
                return copy;
            }
            return new Cloner().cloneArray(object, componentType);
        }
        try {
            Method method = type.getMethod("clone", null);
            return method.invoke(object, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            return object;
        }
        catch (IllegalAccessException | SecurityException e) {
            throw Cloner.fail(e, type);
        }
        catch (InvocationTargetException e) {
            Cloner.rethrow(e.getCause());
            throw Cloner.fail(e, type);
        }
    }
}

