/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.ucar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.GridAdjustment;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.ucar.DimensionWrapper;
import org.apache.sis.storage.netcdf.ucar.GridWrapper;
import org.apache.sis.storage.netcdf.ucar.Utils;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.referencing.operation.Matrix;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissingUnsigned;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;

final class VariableWrapper
extends Variable {
    private final ucar.nc2.Variable variable;
    private final ucar.nc2.Variable raw;

    VariableWrapper(Decoder decoder, ucar.nc2.Variable v) {
        super(decoder);
        ImmutableMap m;
        this.variable = v;
        if (v instanceof VariableEnhanced && (v = ((VariableEnhanced)v).getOriginalVariable()) == null) {
            v = this.variable;
        }
        this.raw = v;
        HashMap enumeration = null;
        if (this.variable.getDataType().isEnum() && (m = this.variable.getEnumTypedef().getMap()) != null) {
            enumeration = JDK19.newHashMap((int)m.size());
            for (Map.Entry entry : m.entrySet()) {
                enumeration.put(Integer.toUnsignedLong((Integer)entry.getKey()), (String)entry.getValue());
            }
        }
        this.setEnumeration(enumeration);
    }

    @Override
    public String getFilename() {
        String name = Utils.nonEmpty(this.variable.getDatasetLocation());
        if (name != null) {
            return name.substring(Math.max(name.lastIndexOf(47), name.lastIndexOf(File.separatorChar)) + 1);
        }
        return super.getFilename();
    }

    @Override
    public String getGroupName() {
        Group parent = this.variable.getParentGroup();
        return parent != null ? parent.getShortName() : null;
    }

    @Override
    public String getName() {
        return this.variable.getShortName();
    }

    @Override
    public String getDescription() {
        return Utils.nonEmpty(this.variable.getDescription());
    }

    @Override
    protected String getUnitsString() {
        return Strings.trimOrNull((String)this.variable.getUnitsString());
    }

    @Override
    protected Unit<?> parseUnit(String symbols) throws Exception {
        if (TIME_UNIT_PATTERN.matcher(symbols).matches()) {
            DateUnit temporal = new DateUnit(symbols);
            this.epoch = temporal.getDateOrigin().toInstant();
            return Units.SECOND.multiply(temporal.getTimeUnit().getValueInSeconds());
        }
        SimpleUnit ucar = SimpleUnit.factoryWithExceptions((String)symbols);
        if (ucar.isUnknownUnit()) {
            return Units.valueOf((String)symbols);
        }
        String baseUnit = ucar.getUnitString();
        Unit unit = Units.valueOf((String)baseUnit);
        double scale = ucar.getValue();
        double offset = ucar.convertTo(0.0, SimpleUnit.factoryWithExceptions((String)baseUnit));
        unit = unit.shift(offset);
        if (!Double.isNaN(scale)) {
            unit = unit.multiply(scale);
        }
        return unit;
    }

    @Override
    public org.apache.sis.storage.netcdf.base.DataType getDataType() {
        switch (this.variable.getDataType()) {
            case STRING: {
                return org.apache.sis.storage.netcdf.base.DataType.STRING;
            }
            case CHAR: {
                return org.apache.sis.storage.netcdf.base.DataType.CHAR;
            }
            case BYTE: {
                return org.apache.sis.storage.netcdf.base.DataType.BYTE;
            }
            case UBYTE: {
                return org.apache.sis.storage.netcdf.base.DataType.UBYTE;
            }
            case SHORT: {
                return org.apache.sis.storage.netcdf.base.DataType.SHORT;
            }
            case USHORT: {
                return org.apache.sis.storage.netcdf.base.DataType.USHORT;
            }
            case INT: {
                return org.apache.sis.storage.netcdf.base.DataType.INT;
            }
            case UINT: {
                return org.apache.sis.storage.netcdf.base.DataType.UINT;
            }
            case LONG: {
                return org.apache.sis.storage.netcdf.base.DataType.INT64;
            }
            case FLOAT: {
                return org.apache.sis.storage.netcdf.base.DataType.FLOAT;
            }
            case DOUBLE: {
                return org.apache.sis.storage.netcdf.base.DataType.DOUBLE;
            }
        }
        return org.apache.sis.storage.netcdf.base.DataType.UNKNOWN;
    }

    @Override
    protected boolean isUnlimited() {
        return this.variable.isUnlimited();
    }

    @Override
    protected boolean isCoordinateSystemAxis() {
        return this.variable.isCoordinateVariable() || this.variable instanceof CoordinateAxis || this.variable.hasAttribute("_CoordinateAxisType") || this.variable.hasAttribute("axis");
    }

    @Override
    protected String getAxisType() {
        String type;
        if (this.variable instanceof CoordinateAxis && (type = ((CoordinateAxis)this.variable).getAxisType()) != null) {
            return type.name();
        }
        type = this.getAttributeAsString("_CoordinateAxisType");
        return type != null ? type : this.getAttributeAsString("axis");
    }

    @Override
    protected Grid findGrid(GridAdjustment adjustment) throws IOException, DataStoreException {
        ImmutableList systems;
        if (this.variable instanceof VariableDS && !(systems = ((VariableDS)this.variable).getCoordinateSystems()).isEmpty()) {
            GridWrapper grid = null;
            String[] axisNames = this.decoder.convention().namesOfAxisVariables(this);
            for (Grid candidate : this.decoder.getGridCandidates()) {
                GridWrapper ordered = ((GridWrapper)candidate).forVariable(this.variable, (List<CoordinateSystem>)systems, axisNames);
                if (ordered == null || grid != null && ordered.getSourceDimensions() <= grid.getSourceDimensions()) continue;
                grid = ordered;
            }
            if (grid != null) {
                return grid;
            }
        }
        return (GridWrapper)super.findGrid(adjustment);
    }

    @Override
    public int getNumDimensions() {
        return this.variable.getRank();
    }

    @Override
    public List<Dimension> getGridDimensions() {
        return DimensionWrapper.wrap((Collection<ucar.nc2.Dimension>)this.variable.getDimensions());
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames((Iterable<Attribute>)this.variable.attributes());
    }

    @Override
    public Class<?> getAttributeType(String attributeName) {
        return VariableWrapper.getAttributeType(this.raw.attributes().findAttributeIgnoreCase(attributeName));
    }

    static Class<?> getAttributeType(Attribute attribute) {
        if (attribute != null) {
            if (attribute.isArray()) {
                return Vector.class;
            }
            switch (attribute.getDataType()) {
                case BYTE: {
                    return Byte.class;
                }
                case UBYTE: 
                case SHORT: {
                    return Short.class;
                }
                case USHORT: 
                case INT: {
                    return Integer.class;
                }
                case UINT: 
                case LONG: {
                    return Long.class;
                }
                case FLOAT: {
                    return Float.class;
                }
                case DOUBLE: {
                    return Double.class;
                }
                case STRING: {
                    return String.class;
                }
            }
            return Object.class;
        }
        return null;
    }

    @Override
    protected Object getAttributeValue(String attributeName) {
        return VariableWrapper.getAttributeValue(this.raw.attributes().findAttributeIgnoreCase(attributeName));
    }

    static Object getAttributeValue(Attribute attribute) {
        if (attribute != null) {
            int length = attribute.getLength();
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    Object value = attribute.getValue(0);
                    if (value instanceof String) {
                        return Utils.nonEmpty((String)value);
                    }
                    if (!(value instanceof Number)) break;
                    return Utils.fixSign((Number)value, attribute.getDataType().isUnsigned());
                }
                default: {
                    if (attribute.isString()) {
                        boolean hasValues = false;
                        String[] values = new String[length];
                        for (int i = 0; i < length; ++i) {
                            values[i] = Utils.nonEmpty(attribute.getStringValue(i));
                            hasValues |= values[i] != null;
                        }
                        if (!hasValues) break;
                        return values;
                    }
                    Array array = attribute.getValues();
                    return VariableWrapper.createDecimalVector(array.get1DJavaArray(DataType.getType((Array)array)), attribute.getDataType().isUnsigned());
                }
            }
        }
        return null;
    }

    static List<String> toNames(Iterable<Attribute> attributes) {
        ArrayList<String> names = new ArrayList<String>();
        for (Attribute at : attributes) {
            names.add(at.getShortName());
        }
        return names;
    }

    @Override
    protected NumberRange<?> getRangeFallback() {
        EnhanceScaleMissingUnsigned ev;
        if (this.variable instanceof EnhanceScaleMissingUnsigned && (ev = (EnhanceScaleMissingUnsigned)this.variable).hasValidData()) {
            return MeasurementRange.create((double)ev.getValidMin(), (boolean)true, (double)ev.getValidMax(), (boolean)true, this.getUnit());
        }
        return super.getRangeFallback();
    }

    @Override
    protected boolean isExternallyCached() {
        return true;
    }

    @Override
    protected Object readFully() throws IOException {
        return this.get1DJavaArray(this.variable.read());
    }

    @Override
    public Vector read(GridExtent area, long[] subsampling) throws IOException, DataStoreException {
        Object array = this.readArray(area, subsampling);
        return Vector.create((Object)array, (boolean)this.variable.getDataType().isUnsigned());
    }

    @Override
    public List<?> readAnyType(GridExtent area, long[] subsampling) throws IOException, DataStoreException {
        Object array = this.readArray(area, subsampling);
        DataType type = this.variable.getDataType();
        if (type == DataType.CHAR && this.variable.getRank() >= 2) {
            return this.createStringList(array, area);
        }
        return Vector.create((Object)array, (boolean)type.isUnsigned());
    }

    private Object readArray(GridExtent area, long[] subsampling) throws IOException, DataStoreException {
        Array array;
        int n = area.getDimension();
        int[] lower = new int[n];
        int[] size = new int[n];
        int[] sub = subsampling != null ? new int[n] : null;
        --n;
        for (int i = 0; i <= n; ++i) {
            int j = n - i;
            lower[j] = Math.toIntExact(area.getLow(i));
            size[j] = Math.toIntExact(area.getSize(i));
            if (sub == null) continue;
            sub[j] = Math.toIntExact(subsampling[i]);
        }
        try {
            array = this.variable.read(sub != null ? new Section(lower, size, sub) : new Section(lower, size));
        }
        catch (InvalidRangeException e) {
            throw new DataStoreException((Throwable)e);
        }
        return this.get1DJavaArray(array);
    }

    private Object get1DJavaArray(Array array) {
        Object data = array.get1DJavaArray(DataType.getType((Array)array));
        this.replaceNaN(data);
        return data;
    }

    @Override
    protected String[] createStringArray(Object array, int count, int length) {
        char[] chars = (char[])array;
        String[] strings = new String[count];
        String previous = "";
        int plo = 0;
        int phi = 0;
        int lower = 0;
        for (int i = 0; i < count; ++i) {
            int upper;
            String element = "";
            int j = upper = lower + length;
            while (--j >= lower) {
                if (chars[j] <= ' ') continue;
                while (chars[lower] <= ' ') {
                    ++lower;
                }
                if (Arrays.equals(chars, lower, ++j, chars, plo, phi)) {
                    element = previous;
                    break;
                }
                previous = element = new String(chars, lower, j - lower);
                plo = lower;
                phi = j;
                break;
            }
            strings[i] = element;
            lower = upper;
        }
        return strings;
    }

    @Override
    protected double coordinateForAxis(int j, int i) {
        return this.variable instanceof CoordinateAxis2D ? ((CoordinateAxis2D)this.variable).getCoordValue(j, i) : Double.NaN;
    }

    @Override
    protected boolean trySetTransform(Matrix gridToCRS, int srcDim, int tgtDim, Vector data) throws IOException, DataStoreException {
        CoordinateAxis1D axis;
        if (this.variable instanceof CoordinateAxis1D && (axis = (CoordinateAxis1D)this.variable).isRegular()) {
            double start = axis.getStart();
            double increment = axis.getIncrement();
            if (start != 0.0 || increment != 0.0) {
                gridToCRS.setElement(tgtDim, srcDim, increment);
                gridToCRS.setElement(tgtDim, gridToCRS.getNumCol() - 1, start);
                return true;
            }
        }
        return super.trySetTransform(gridToCRS, srcDim, tgtDim, data);
    }

    final boolean isWrapperFor(ucar.nc2.Variable v) {
        return this.variable == v || this.raw == v;
    }
}

