/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.portrayal.Observable;
import org.apache.sis.portrayal.PlanarCanvas;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.portrayal.TransformChangeEvent;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.shared.AffineTransform2D;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class CanvasFollower
implements PropertyChangeListener,
Disposable {
    protected final PlanarCanvas source;
    protected final PlanarCanvas target;
    private boolean initialized;
    private boolean disabled;
    private boolean followRealWorld;
    private MathTransform2D displayTransform;
    private MathTransform objectiveTransform;
    private byte displayTransformStatus;
    private byte objectiveTransformStatus;
    private static final byte VALID = 0;
    private static final byte OUTDATED = 1;
    private static final byte UNKNOWN = 2;
    private static final byte ERROR = 3;
    private boolean changing;

    public CanvasFollower(PlanarCanvas source, PlanarCanvas target) {
        this.source = Objects.requireNonNull(source);
        this.target = Objects.requireNonNull(target);
        this.followRealWorld = true;
        this.displayTransformStatus = 1;
        this.objectiveTransformStatus = 1;
    }

    public void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.source.addPropertyChangeListener("objectiveCRS", this);
            this.target.addPropertyChangeListener("objectiveCRS", this);
            this.source.addPropertyChangeListener("objectiveToDisplay", this);
            this.target.addPropertyChangeListener("objectiveToDisplay", this);
        }
    }

    public boolean isDisabled() {
        return this.disabled | !this.initialized;
    }

    public void setDisabled(boolean stop) {
        this.disabled = stop;
    }

    public boolean getFollowRealWorld() {
        return this.followRealWorld;
    }

    public void setFollowRealWorld(boolean real) {
        if (real != this.followRealWorld) {
            this.followRealWorld = real;
            this.displayTransform = null;
            this.objectiveTransform = null;
            this.displayTransformStatus = 1;
            this.objectiveTransformStatus = 1;
        }
    }

    public DirectPosition getSourceObjectivePOI() {
        Point2D p = this.getSourceDisplayPOI().orElse(null);
        if (p != null) {
            try {
                DirectPosition2D poi = new DirectPosition2D(p);
                this.source.objectiveToDisplay.inverseTransform((Point2D)poi, (Point2D)poi);
                return poi;
            }
            catch (java.awt.geom.NoninvertibleTransformException e) {
                CanvasFollower.canNotCompute("getSourceObjectivePOI", e);
            }
        }
        return this.source.getPointOfInterest(true);
    }

    public Optional<Point2D> getSourceDisplayPOI() {
        return Optional.empty();
    }

    public Optional<MathTransform2D> getDisplayTransform() {
        if (this.displayTransformStatus != 0) {
            if (this.displayTransformStatus != 1) {
                return Optional.empty();
            }
            this.displayTransformStatus = (byte)3;
            if (this.objectiveTransformStatus == 0 || this.findObjectiveTransform("getDisplayTransform")) {
                try {
                    MathTransform objectiveTransform = this.objectiveTransform;
                    if (objectiveTransform == null || objectiveTransform instanceof AffineTransform) {
                        AffineTransform tr = this.source.objectiveToDisplay.createInverse();
                        if (objectiveTransform != null) {
                            tr.preConcatenate((AffineTransform)objectiveTransform);
                        }
                        tr.preConcatenate(this.target.objectiveToDisplay);
                        this.displayTransform = new AffineTransform2D(tr);
                    } else {
                        this.displayTransform = MathTransforms.bidimensional((MathTransform)MathTransforms.concatenate((MathTransform)this.source.getObjectiveToDisplay().inverse(), (MathTransform)objectiveTransform, (MathTransform)this.target.getObjectiveToDisplay()));
                    }
                    this.displayTransformStatus = 0;
                }
                catch (java.awt.geom.NoninvertibleTransformException | NoninvertibleTransformException e) {
                    CanvasFollower.canNotCompute("getDisplayTransform", (Exception)e);
                }
            }
        }
        return Optional.ofNullable(this.displayTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        block8: {
            if (this.changing || !(event instanceof TransformChangeEvent)) break block8;
            try {
                block9: {
                    te = (TransformChangeEvent)event;
                    this.displayTransformStatus = 1;
                    this.changing = true;
                    if (!te.isSameSource(this.source)) break block9;
                    this.transformedSource(te);
                    if (this.disabled || !this.filter(te)) ** GOTO lbl37
                    if (!this.followRealWorld || this.objectiveTransformStatus != 0 && !this.findObjectiveTransform("propertyChange") || (before = (AffineTransform)te.getObjectiveChange2D().orElse(null)) == null) ** GOTO lbl22
                    try {
                        if (this.objectiveTransform != null) {
                            poi = this.getSourceObjectivePOI();
                            t = AffineTransforms2D.castOrCopy((MathTransform)MathTransforms.tangent((MathTransform)this.objectiveTransform, (DirectPosition)poi));
                            c = t.createInverse();
                            c.preConcatenate(before);
                            c.preConcatenate(t);
                            before = c;
                        }
                        this.transformObjectiveCoordinates(te, before);
                        return;
                    }
                    catch (java.awt.geom.NoninvertibleTransformException | NullPointerException | TransformException e) {
                        CanvasFollower.canNotCompute("propertyChange", (Exception)e);
lbl22:
                        // 2 sources

                        te.getDisplayChange2D().ifPresent((Consumer<AffineTransform>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$propertyChange$0(org.apache.sis.portrayal.TransformChangeEvent java.awt.geom.AffineTransform ), (Ljava/awt/geom/AffineTransform;)V)((CanvasFollower)this, (TransformChangeEvent)te));
                    }
                }
                if (!te.isSameSource(this.target)) ** GOTO lbl37
                this.transformedTarget(te);
            }
            finally {
                this.changing = false;
            }
        }
        if ("objectiveCRS".equals(event.getPropertyName())) {
            this.displayTransform = null;
            this.objectiveTransform = null;
            this.displayTransformStatus = 1;
            this.objectiveTransformStatus = 1;
        }
lbl37:
        // 7 sources

    }

    protected boolean filter(TransformChangeEvent event) {
        return event.getReason().isNavigation();
    }

    protected void transformObjectiveCoordinates(TransformChangeEvent event, AffineTransform before) {
        this.target.transformObjectiveCoordinates(before);
    }

    protected void transformDisplayCoordinates(TransformChangeEvent event, AffineTransform after) {
        this.target.transformDisplayCoordinates(after);
    }

    protected void transformedSource(TransformChangeEvent event) {
    }

    protected void transformedTarget(TransformChangeEvent event) {
    }

    private boolean findObjectiveTransform(String caller) {
        if (this.objectiveTransformStatus == 1) {
            this.displayTransform = null;
            this.objectiveTransform = null;
            this.displayTransformStatus = 1;
            this.objectiveTransformStatus = (byte)3;
            CoordinateReferenceSystem sourceCRS = this.source.getObjectiveCRS();
            CoordinateReferenceSystem targetCRS = this.target.getObjectiveCRS();
            if (sourceCRS != null && targetCRS != null) {
                try {
                    GeographicBoundingBox aoi;
                    try {
                        aoi = this.target.getGeographicArea().orElse(null);
                    }
                    catch (RenderException e) {
                        CanvasFollower.canNotCompute(caller, e);
                        aoi = null;
                    }
                    this.objectiveTransform = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (GeographicBoundingBox)aoi).getMathTransform();
                    if (this.objectiveTransform.isIdentity()) {
                        this.objectiveTransform = null;
                    }
                    this.objectiveTransformStatus = 0;
                    return true;
                }
                catch (FactoryException e) {
                    CanvasFollower.canNotCompute(caller, (Exception)((Object)e));
                }
            } else {
                this.objectiveTransformStatus = (byte)2;
            }
        }
        return false;
    }

    private static void canNotCompute(String caller, Exception e) {
        Logging.recoverableException((Logger)Observable.LOGGER, CanvasFollower.class, (String)caller, (Throwable)e);
    }

    public void dispose() {
        this.source.removePropertyChangeListener("objectiveToDisplay", this);
        this.target.removePropertyChangeListener("objectiveToDisplay", this);
        this.source.removePropertyChangeListener("objectiveCRS", this);
        this.target.removePropertyChangeListener("objectiveCRS", this);
        this.initialized = false;
    }

    private /* synthetic */ void lambda$propertyChange$0(TransformChangeEvent te, AffineTransform after) {
        this.transformDisplayCoordinates(te, after);
    }
}

