/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.AnchorPoint;
import org.apache.sis.style.se1.Displacement;
import org.apache.sis.style.se1.LabelPlacement;
import org.apache.sis.style.se1.StyleFactory;

@XmlType(name="PointPlacementType", propOrder={"anchorPoint", "displacement", "rotation"})
@XmlRootElement(name="PointPlacement")
public class PointPlacement<R>
extends LabelPlacement<R> {
    @XmlElement(name="AnchorPoint")
    protected AnchorPoint<R> anchorPoint;
    @XmlElement(name="Displacement")
    protected Displacement<R> displacement;
    @XmlElement(name="Rotation")
    protected Expression<R, ? extends Number> rotation;

    private PointPlacement() {
    }

    public PointPlacement(StyleFactory<R> factory) {
        super(factory);
    }

    public PointPlacement(PointPlacement<R> source) {
        super(source);
        this.anchorPoint = source.anchorPoint;
        this.displacement = source.displacement;
        this.rotation = source.rotation;
    }

    public AnchorPoint<R> getAnchorPoint() {
        if (this.anchorPoint == null) {
            this.anchorPoint = this.factory.createAnchorPoint();
        }
        return this.anchorPoint;
    }

    public void setAnchorPoint(AnchorPoint<R> value) {
        this.anchorPoint = value;
    }

    public Displacement<R> getDisplacement() {
        if (this.displacement == null) {
            this.displacement = this.factory.createDisplacement();
        }
        return this.displacement;
    }

    public void setDisplacement(Displacement<R> value) {
        this.displacement = value;
    }

    public Expression<R, ? extends Number> getRotation() {
        return this.defaultToZero(this.rotation);
    }

    public void setRotation(Expression<R, ? extends Number> value) {
        this.rotation = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.anchorPoint, this.displacement, this.rotation};
    }

    @Override
    public PointPlacement<R> clone() {
        PointPlacement clone = (PointPlacement)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.anchorPoint != null) {
            this.anchorPoint = this.anchorPoint.clone();
        }
        if (this.displacement != null) {
            this.displacement = this.displacement.clone();
        }
    }
}

