/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.sis.pending.jdk.HexFormat;

public enum BinaryEncoding {
    RAW,
    HEXADECIMAL{

        @Override
        public byte[] getBytes(ResultSet results, int columnIndex) throws SQLException {
            String value = results.getString(columnIndex);
            return value != null ? HexFormat.of().parseHex((CharSequence)value) : null;
        }

        @Override
        public InputStream decode(InputStream source) {
            return new FromHex(source);
        }
    };


    public byte[] getBytes(ResultSet results, int columnIndex) throws SQLException {
        return results.getBytes(columnIndex);
    }

    public InputStream decode(InputStream source) {
        return source;
    }

    private static final class FromHex
    extends InputStream {
        private final InputStream source;

        FromHex(InputStream source) {
            this.source = source;
        }

        @Override
        public int read() throws IOException {
            int hi = this.source.read();
            if (hi < 0) {
                return -1;
            }
            int lo = this.source.read();
            if (lo < 0) {
                throw new EOFException();
            }
            return HexFormat.fromHexDigit((int)hi) << 4 | HexFormat.fromHexDigit((int)lo);
        }

        @Override
        public long skip(long n) throws IOException {
            if ((n & 0xC000000000000000L) == 0L) {
                n <<= 1;
            }
            if (((n = this.source.skip(n)) & 1L) != 0L && this.source.read() >= 0) {
                ++n;
            }
            return n >> 1;
        }

        @Override
        public int available() throws IOException {
            return this.source.available() >> 1;
        }

        @Override
        public boolean markSupported() {
            return this.source.markSupported();
        }

        @Override
        public void mark(int n) {
            n = (n & 0xC0000000) == 0 ? (n <<= 1) : Integer.MAX_VALUE;
            this.source.mark(n);
        }

        @Override
        public void reset() throws IOException {
            this.source.reset();
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }
    }
}

