/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.stream;

import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.apache.sis.util.stream.DoubleStreamWrapper;

public final class PaginedDoubleStream
extends DoubleStreamWrapper {
    private Stream<?> root;

    public PaginedDoubleStream(DoubleStream source, Stream<?> root) {
        super(source);
        this.root = root;
    }

    @Override
    public DoubleStream skip(long n) {
        this.root = this.root.skip(n);
        return this;
    }

    @Override
    public DoubleStream limit(long maxSize) {
        this.root = this.root.limit(maxSize);
        return this;
    }

    @Override
    public long count() {
        return this.root.count();
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator mapper) {
        return new PaginedDoubleStream(super.map(mapper), this.root);
    }

    @Override
    public DoubleStream distinct() {
        return this.delegate().distinct();
    }

    @Override
    public DoubleStream unordered() {
        return (DoubleStream)this.delegate().unordered();
    }

    @Override
    public DoubleStream sorted() {
        return this.delegate().sorted();
    }

    @Override
    public DoubleStream filter(DoublePredicate predicate) {
        return this.delegate().filter(predicate);
    }
}

