/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.internal.shared.ReferencingServices;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.NotSpatioTemporalException;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.operation.TransformException;

@XmlType(name="EX_SpatialTemporalExtent_Type")
@XmlRootElement(name="EX_SpatialTemporalExtent")
public class DefaultSpatialTemporalExtent
extends DefaultTemporalExtent
implements SpatialTemporalExtent {
    private static final long serialVersionUID = -2461142677245013474L;
    private Collection<GeographicExtent> spatialExtent;
    private VerticalExtent verticalExtent;

    public DefaultSpatialTemporalExtent() {
    }

    public DefaultSpatialTemporalExtent(GeographicExtent spatialExtent, VerticalExtent verticalExtent, TemporalExtent extent) {
        super(extent);
        this.verticalExtent = verticalExtent;
        this.spatialExtent = DefaultSpatialTemporalExtent.singleton(spatialExtent, GeographicExtent.class);
    }

    public DefaultSpatialTemporalExtent(SpatialTemporalExtent object) {
        super((TemporalExtent)object);
        if (object != null) {
            this.spatialExtent = DefaultSpatialTemporalExtent.copyCollection(object.getSpatialExtent(), GeographicExtent.class);
            if (object instanceof DefaultSpatialTemporalExtent) {
                this.verticalExtent = ((DefaultSpatialTemporalExtent)object).getVerticalExtent();
            }
        }
    }

    public static DefaultSpatialTemporalExtent castOrCopy(SpatialTemporalExtent object) {
        if (object == null || object instanceof DefaultSpatialTemporalExtent) {
            return (DefaultSpatialTemporalExtent)object;
        }
        return new DefaultSpatialTemporalExtent(object);
    }

    @XmlElement(name="spatialExtent", required=true)
    public Collection<GeographicExtent> getSpatialExtent() {
        this.spatialExtent = this.nonNullCollection(this.spatialExtent, GeographicExtent.class);
        return this.spatialExtent;
    }

    public void setSpatialExtent(Collection<? extends GeographicExtent> newValues) {
        this.spatialExtent = this.writeCollection(newValues, this.spatialExtent, GeographicExtent.class);
    }

    @XmlElement(name="verticalExtent")
    @UML(identifier="verticalExtent", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public VerticalExtent getVerticalExtent() {
        return this.verticalExtent;
    }

    public void setVerticalExtent(VerticalExtent newValue) {
        this.checkWritePermission(this.verticalExtent);
        this.verticalExtent = newValue;
    }

    @Override
    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.spatialExtent));
        if (!ReferencingServices.getInstance().setBounds(envelope, this)) {
            throw new NotSpatioTemporalException(3, envelope);
        }
    }
}

