/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.impl;

import java.io.Serializable;
import org.apache.spark.ml.linalg.BLAS$;
import scala.Double$;
import scala.Function0;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.RichDouble$;

public final class Utils$ {
    public static final Utils$ MODULE$ = new Utils$();
    private static double EPSILON;
    private static volatile boolean bitmap$0;

    /*
     * WARNING - void declaration
     */
    private double EPSILON$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!bitmap$0) {
                void var2_2;
                double eps = 1.0;
                while (1.0 + eps / 2.0 != 1.0) {
                    eps /= 2.0;
                }
                EPSILON = var2_2;
                bitmap$0 = true;
            }
        }
        return EPSILON;
    }

    public double EPSILON() {
        return !bitmap$0 ? this.EPSILON$lzycompute() : EPSILON;
    }

    /*
     * WARNING - void declaration
     */
    public double[] unpackUpperTriangular(int n, double[] triangularValues) {
        void var3_3;
        double[] symmetricValues = new double[n * n];
        int r = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                symmetricValues[i * n + j] = triangularValues[r];
                symmetricValues[j * n + i] = triangularValues[r];
                ++r;
            }
        }
        return var3_3;
    }

    public int indexUpperTriangular(int n, int i, int j) {
        Predef$.MODULE$.require(i >= 0 && i < n, (Function0 & Serializable)() -> new StringBuilder(29).append("Expected 0 <= i < ").append(n).append(", got i = ").append(i).append(".").toString());
        Predef$.MODULE$.require(j >= 0 && j < n, (Function0 & Serializable)() -> new StringBuilder(29).append("Expected 0 <= j < ").append(n).append(", got j = ").append(j).append(".").toString());
        return i <= j ? j * (j + 1) / 2 + i : i * (i + 1) / 2 + j;
    }

    public double log1pExp(double x) {
        return x > 0.0 ? x + package$.MODULE$.log1p(package$.MODULE$.exp(-x)) : package$.MODULE$.log1p(package$.MODULE$.exp(x));
    }

    public void softmax(double[] array) {
        this.softmax(array, array.length, 0, 1, array);
    }

    public void softmax(double[] input, int n, int offset, int step, double[] output) {
        int i;
        double maxValue = Double$.MODULE$.MinValue();
        int end = offset + step * n;
        for (i = offset; i < end; i += step) {
            double v = input[i];
            if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(v))) {
                BLAS$.MODULE$.javaBLAS().dscal(n, 0.0, output, offset, step);
                output[i] = 1.0;
                return;
            }
            if (!(v > maxValue)) continue;
            maxValue = v;
        }
        double sum = 0.0;
        for (i = offset; i < end; i += step) {
            double exp;
            output[i] = exp = package$.MODULE$.exp(input[i] - maxValue);
            sum += exp;
        }
        BLAS$.MODULE$.javaBLAS().dscal(n, 1.0 / sum, output, offset, step);
    }

    private Utils$() {
    }
}

