/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampAdd$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(unit, quantity, timestamp) - Adds the specified number of units to the given timestamp.", arguments="\n    Arguments:\n      * unit - this indicates the units of datetime that you want to add.\n        Supported string values of `unit` are (case insensitive):\n          - \"YEAR\"\n          - \"QUARTER\" - 3 months\n          - \"MONTH\"\n          - \"WEEK\" - 7 days\n          - \"DAY\", \"DAYOFYEAR\"\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * quantity - this is the number of units of time that you want to add.\n      * timestamp - this is a timestamp (w/ or w/o timezone) to which you want to add.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(HOUR, 8, timestamp_ntz'2022-02-11 20:30:00');\n       2022-02-12 04:30:00\n      > SELECT _FUNC_(MONTH, 1, timestamp_ltz'2022-01-31 00:00:00');\n       2022-02-28 00:00:00\n      > SELECT _FUNC_(SECOND, -10, date'2022-01-01');\n       2021-12-31 23:59:50\n      > SELECT _FUNC_(YEAR, 10, timestamp'2000-01-01 01:02:03.123456');\n       2010-01-01 01:02:03.123456\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\tEd\u0001B\u0016-\u0001fB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tM\u0002\u0011\t\u0012)A\u0005=\"Aq\r\u0001BK\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u0001\tE\t\u0015!\u0003j\u0011!i\u0007A!f\u0001\n\u0003A\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011B5\t\u0011=\u0004!Q3A\u0005\u0002AD\u0001\u0002\u001e\u0001\u0003\u0012\u0003\u0006I!\u001d\u0005\u0006k\u0002!\tA\u001e\u0005\u0006k\u0002!\t\u0001 \u0005\u0007\u0003\u0003\u0001A\u0011\t5\t\r\u0005\r\u0001\u0001\"\u0011i\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!a\u0007\u0001\t\u0003\ni\u0002C\u0004\u0002&\u0001!\t%a\n\t\u0015\u0005-\u0002\u0001#b\u0001\n\u0013\ti\u0003C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!1\u0011q\u000f\u0001\u0005BuCQ!\r\u0001\u0005BuCq!!\u001f\u0001\t#\nY\bC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0001\u0002\b\"I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003S\u0003\u0011\u0013!C\u0001\u0003WC\u0011\"a,\u0001#\u0003%\t!a+\t\u0013\u0005E\u0006!%A\u0005\u0002\u0005M\u0006\"CA\\\u0001\u0005\u0005I\u0011IA]\u0011%\t)\rAA\u0001\n\u0003\t9\rC\u0005\u0002P\u0002\t\t\u0011\"\u0001\u0002R\"I\u0011q\u001b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\n\u0003O\u0004\u0011\u0011!C\u0001\u0003SD\u0011\"a=\u0001\u0003\u0003%\t%!>\t\u0013\u0005e\b!!A\u0005B\u0005mx!\u0003B\u0013Y\u0005\u0005\t\u0012\u0001B\u0014\r!YC&!A\t\u0002\t%\u0002BB;$\t\u0003\u0011\t\u0005C\u0005\u0003D\r\n\t\u0011\"\u0012\u0003F!I!qI\u0012\u0002\u0002\u0013\u0005%\u0011\n\u0005\n\u0005'\u001a\u0013\u0013!C\u0001\u0003gC\u0011B!\u0016$\u0003\u0003%\tIa\u0016\t\u0013\t\u00154%%A\u0005\u0002\u0005M\u0006\"\u0003B4G\u0005\u0005I\u0011\u0002B5\u00051!\u0016.\\3ti\u0006l\u0007/\u00113e\u0015\tic&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u00181\u0003!\u0019\u0017\r^1msN$(BA\u00193\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003gQ\nQa\u001d9be.T!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO\u000e\u00011c\u0002\u0001;}\u0005C5*\u0015\t\u0003wqj\u0011\u0001L\u0005\u0003{1\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005mz\u0014B\u0001!-\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\"F\u001d\tY4)\u0003\u0002EY\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001\u0012\u0017\u0011\u0005mJ\u0015B\u0001&-\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJA\u0004Qe>$Wo\u0019;\u0011\u0005IKfBA*Y\u001d\t!v+D\u0001V\u0015\t1\u0006(\u0001\u0004=e>|GOP\u0005\u0002\u001d&\u0011A)T\u0005\u00035n\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001R'\u0002\tUt\u0017\u000e^\u000b\u0002=B\u0011ql\u0019\b\u0003A\u0006\u0004\"\u0001V'\n\u0005\tl\u0015A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!AY'\u0002\u000bUt\u0017\u000e\u001e\u0011\u0002\u0011E,\u0018M\u001c;jif,\u0012!\u001b\t\u0003w)L!a\u001b\u0017\u0003\u0015\u0015C\bO]3tg&|g.A\u0005rk\u0006tG/\u001b;zA\u0005IA/[7fgR\fW\u000e]\u0001\u000bi&lWm\u001d;b[B\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\t\u0011\u000fE\u0002MezK!a]'\u0003\r=\u0003H/[8o\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\rqJg.\u001b;?)\u00159\b0\u001f>|!\tY\u0004\u0001C\u0003]\u0013\u0001\u0007a\fC\u0003h\u0013\u0001\u0007\u0011\u000eC\u0003n\u0013\u0001\u0007\u0011\u000eC\u0004p\u0013A\u0005\t\u0019A9\u0015\t]lhp \u0005\u00069*\u0001\rA\u0018\u0005\u0006O*\u0001\r!\u001b\u0005\u0006[*\u0001\r![\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006j]B,H\u000fV=qKN,\"!!\u0003\u0011\u000bI\u000bY!a\u0004\n\u0007\u000551LA\u0002TKF\u0004B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+\u0001\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\r\u0003'\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\b\u0011\t\u0005E\u0011\u0011E\u0005\u0005\u0003G\t\u0019B\u0001\u0005ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\rA\u0015\u0011\u0006\u0005\u0006_>\u0001\rAX\u0001\ru>tW-\u00133J]\u00163\u0018\r\\\u000b\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0003uS6,'BAA\u001d\u0003\u0011Q\u0017M^1\n\t\u0005u\u00121\u0007\u0002\u00075>tW-\u00133)\u0007A\t\t\u0005E\u0002M\u0003\u0007J1!!\u0012N\u0005%!(/\u00198tS\u0016tG/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002L\u0005E\u0013Q\u000b\t\u0004\u0019\u00065\u0013bAA(\u001b\n\u0019\u0011I\\=\t\u000f\u0005M\u0013\u00031\u0001\u0002L\u0005\t\u0011\u000fC\u0004\u0002XE\u0001\r!a\u0013\u0002\r5L7M]8t\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002^\u0005%\u00141\u000f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r\u0017\u0002\u000f\r|G-Z4f]&!\u0011qMA1\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA6%\u0001\u0007\u0011QN\u0001\u0004GRD\b\u0003BA0\u0003_JA!!\u001d\u0002b\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA;%\u0001\u0007\u0011QL\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003x\u0003{\n\t\t\u0003\u0004\u0002\u0000U\u0001\r![\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\u0019)\u0006a\u0001S\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#C<\u0002\n\u0006-\u0015QRAH\u0011\u001daf\u0003%AA\u0002yCqa\u001a\f\u0011\u0002\u0003\u0007\u0011\u000eC\u0004n-A\u0005\t\u0019A5\t\u000f=4\u0002\u0013!a\u0001c\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAKU\rq\u0016qS\u0016\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0005v]\u000eDWmY6fI*\u0019\u00111U'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002(\u0006u%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAWU\rI\u0017qS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!.+\u0007E\f9*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003w\u0003B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f9$\u0001\u0003mC:<\u0017b\u00013\u0002@\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u001a\t\u0004\u0019\u0006-\u0017bAAg\u001b\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111JAj\u0011%\t).HA\u0001\u0002\u0004\tI-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00037\u0004b!!8\u0002d\u0006-SBAAp\u0015\r\t\t/T\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAs\u0003?\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111^Ay!\ra\u0015Q^\u0005\u0004\u0003_l%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003+|\u0012\u0011!a\u0001\u0003\u0017\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111XA|\u0011%\t)\u000eIA\u0001\u0002\u0004\tI-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\fi\u0010C\u0005\u0002V\u0006\n\t\u00111\u0001\u0002L!:\u0002A!\u0001\u0003\b\t%!Q\u0002B\b\u0005'\u0011)B!\u0007\u0003\u001c\t}!\u0011\u0005\t\u0004w\t\r\u0011b\u0001B\u0003Y\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u0006\u0003y{f)\u0016(D?\"*h.\u001b;-AE,\u0018M\u001c;jifd\u0003\u0005^5nKN$\u0018-\u001c9*A5\u0002\u0013\t\u001a3tAQDW\rI:qK\u000eLg-[3eA9,XNY3sA=4\u0007%\u001e8jiN\u0004Co\u001c\u0011uQ\u0016\u0004s-\u001b<f]\u0002\"\u0018.\\3ti\u0006l\u0007OL\u0001\nCJ<W/\\3oiN\f#A!\u0005\u0002\t[R\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I;oSR\u0004S\u0006\t;iSN\u0004\u0013N\u001c3jG\u0006$Xm\u001d\u0011uQ\u0016\u0004SO\\5ug\u0002zg\r\t3bi\u0016$\u0018.\\3!i\"\fG\u000fI=pk\u0002:\u0018M\u001c;!i>\u0004\u0013\r\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001aV\u000f\u001d9peR,G\rI:ue&tw\r\t<bYV,7\u000fI8gA\u0001,h.\u001b;aA\u0005\u0014X\r\t\u0015dCN,\u0007%\u001b8tK:\u001c\u0018\u000e^5wK&R$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0013,R!SE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!EE+\u0016I\u0015+F%\n\u0002S\u0006I\u001a![>tG\u000f[:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u001f:#\u0006J\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI,F\u000b.\u0013\u0003%\f\u00118A\u0011\f\u0017p\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#B3\nb\u0003E\t#B3>3\u0015,R!SE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E!{UK\u0015\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u0013:+F+\u0012\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012T\u000b\u000e{e\n\u0012\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u00132c\u0015jU#D\u001f:#%E\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T%D%>\u001bViQ(O\t\nR\u0001\u0005\t\u0011!A\u0001R\u0003%];b]RLG/\u001f\u0011.AQD\u0017n\u001d\u0011jg\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002*h.\u001b;tA=4\u0007\u0005^5nK\u0002\"\b.\u0019;!s>,\be^1oi\u0002\"x\u000eI1eI:R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^5nKN$\u0018-\u001c9![\u0001\"\b.[:!SN\u0004\u0013\r\t;j[\u0016\u001cH/Y7qA!:x\u0006I8sA]|s\u000e\t;j[\u0016TxN\\3*AQ|\u0007e\u001e5jG\"\u0004\u0013p\\;!o\u0006tG\u000f\t;pA\u0005$GM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003\u0018\u0005\u00199B\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015I\u001fV\u0013F\u0006\t\u001d-AQLW.Z:uC6\u0004xL\u001c;{OI\u0002$GM\u00171e5\n\u0014\u0007\t\u001a1uM\u0002$\b\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007\r\u001a3[A\u0012T&\r\u001a!aQR4\u0007\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CSj\u0014(U\u00112\u0002\u0013\u0007\f\u0011uS6,7\u000f^1na~cGO_\u00143aI\u0012T\u0006M\u0019.gE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002$GM\u00171e5\u0012\u0004\b\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QM+5i\u0014(EY\u0001j\u0013\u0007\r\u0017!I\u0006$Xm\n\u001a1eIj\u0003'M\u00171c\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1eEj\u0013GM\u00174c\u0001\u00124GO\u001b:uU\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK-F\u0003Jc\u0003%\r\u0019-AQLW.Z:uC6\u0004xE\r\u00191a5\u0002\u0014'\f\u00192AA\n$\b\r\u001a;aMr\u0013GM\u001a5kY:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\u0002T\u0006M\u0019.aE\u0002\u0003'\r\u001e1ei\u00024GL\u00193gQ*dG\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011i\"\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t\r\u0012!B\u001a/g9\u0002\u0014\u0001\u0004+j[\u0016\u001cH/Y7q\u0003\u0012$\u0007CA\u001e$'\u0015\u0019#1\u0006B\u001c!%\u0011iCa\r_S&\fx/\u0004\u0002\u00030)\u0019!\u0011G'\u0002\u000fI,h\u000e^5nK&!!Q\u0007B\u0018\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005s\u0011y$\u0004\u0002\u0003<)!!QHA\u001c\u0003\tIw.C\u0002[\u0005w!\"Aa\n\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013]\u0014YE!\u0014\u0003P\tE\u0003\"\u0002/'\u0001\u0004q\u0006\"B4'\u0001\u0004I\u0007\"B7'\u0001\u0004I\u0007bB8'!\u0003\u0005\r!]\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002B-\u0005C\u0002B\u0001\u0014:\u0003\\A9AJ!\u0018_S&\f\u0018b\u0001B0\u001b\n1A+\u001e9mKRB\u0001Ba\u0019)\u0003\u0003\u0005\ra^\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003lA!\u0011Q\u0018B7\u0013\u0011\u0011y'a0\u0003\r=\u0013'.Z2u\u0001")
public class TimestampAdd
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
TimeZoneAwareExpression,
Serializable {
    private transient ZoneId zoneIdInEval;
    private final String unit;
    private final Expression quantity;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return TimestampAdd$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<String, Expression, Expression, Option<String>>> unapply(TimestampAdd x$0) {
        return TimestampAdd$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return TimestampAdd$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<String, Expression, Expression, Option<String>>, TimestampAdd> tupled() {
        return TimestampAdd$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Expression, Function1<Expression, Function1<Option<String>, TimestampAdd>>>> curried() {
        return TimestampAdd$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String unit() {
        return this.unit;
    }

    public Expression quantity() {
        return this.quantity;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.quantity();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, AnyTimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return this.timestamp().dataType();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        String x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    private ZoneId zoneIdInEval$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneIdInEval = this.zoneIdForType(this.timestamp().dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneIdInEval;
    }

    private ZoneId zoneIdInEval() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.zoneIdInEval$lzycompute() : this.zoneIdInEval;
    }

    @Override
    public Object nullSafeEval(Object q, Object micros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd(this.unit(), BoxesRunTime.unboxToInt((Object)q), BoxesRunTime.unboxToLong((Object)micros), this.zoneIdInEval()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneIdInEval(), ZoneId.class.getName());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(q, micros) -> new StringBuilder(23).append(dtu).append(".timestampAdd(\"").append(this.unit()).append("\", ").append((String)q).append(", ").append((String)micros).append(", ").append(zid).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "timestampadd";
    }

    @Override
    public String sql() {
        String string = this.unit();
        String childrenSQL = ((IterableOnceOps)((SeqOps)this.children().map((Function1 & Serializable)x$12 -> x$12.sql())).$plus$colon((Object)string)).mkString(", ");
        return new StringBuilder(2).append(this.prettyName()).append("(").append(childrenSQL).append(")").toString();
    }

    @Override
    public TimestampAdd withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Expression x$1 = newLeft;
        Expression x$2 = newRight;
        String x$3 = this.copy$default$1();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$3, x$1, x$2, x$4);
    }

    public TimestampAdd copy(String unit, Expression quantity, Expression timestamp, Option<String> timeZoneId) {
        return new TimestampAdd(unit, quantity, timestamp, timeZoneId);
    }

    public String copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.quantity();
    }

    public Expression copy$default$3() {
        return this.timestamp();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TimestampAdd";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.unit();
                break;
            }
            case 1: {
                object = this.quantity();
                break;
            }
            case 2: {
                object = this.timestamp();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimestampAdd;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "unit";
                break;
            }
            case 1: {
                string = "quantity";
                break;
            }
            case 2: {
                string = "timestamp";
                break;
            }
            case 3: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimestampAdd)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimestampAdd timestampAdd = (TimestampAdd)x$1;
        String string = this.unit();
        String string2 = timestampAdd.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Expression expression = this.quantity();
        Expression expression2 = timestampAdd.quantity();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = timestampAdd.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = timestampAdd.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!timestampAdd.canEqual(this)) return false;
        return true;
    }

    public TimestampAdd(String unit, Expression quantity, Expression timestamp, Option<String> timeZoneId) {
        this.unit = unit;
        this.quantity = quantity;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public TimestampAdd(String unit, Expression quantity, Expression timestamp) {
        this(unit, quantity, timestamp, (Option<String>)None$.MODULE$);
    }
}

