/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.DecisionTreeRunner$;
import org.apache.spark.examples.mllib.GradientBoostedTreesRunner;
import org.apache.spark.examples.mllib.GradientBoostedTreesRunner$;
import org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class GradientBoostedTreesRunner$ {
    public static GradientBoostedTreesRunner$ MODULE$;

    static {
        new GradientBoostedTreesRunner$();
    }

    public void main(String[] args) {
        GradientBoostedTreesRunner.Params defaultParams = new GradientBoostedTreesRunner.Params(GradientBoostedTreesRunner$Params$.MODULE$.apply$default$1(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$2(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$3(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$4(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$5(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$6(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$7());
        OptionParser<GradientBoostedTreesRunner.Params> parser = new OptionParser<GradientBoostedTreesRunner.Params>(defaultParams){

            public static final /* synthetic */ GradientBoostedTreesRunner.Params $anonfun$new$2(int x, GradientBoostedTreesRunner.Params c) {
                int x$8 = x;
                String x$9 = c.copy$default$1();
                String x$10 = c.copy$default$2();
                String x$11 = c.copy$default$3();
                String x$12 = c.copy$default$4();
                int x$13 = c.copy$default$6();
                double x$14 = c.copy$default$7();
                return c.copy(x$9, x$10, x$11, x$12, x$8, x$13, x$14);
            }

            public static final /* synthetic */ GradientBoostedTreesRunner.Params $anonfun$new$3(int x, GradientBoostedTreesRunner.Params c) {
                int x$15 = x;
                String x$16 = c.copy$default$1();
                String x$17 = c.copy$default$2();
                String x$18 = c.copy$default$3();
                String x$19 = c.copy$default$4();
                int x$20 = c.copy$default$5();
                double x$21 = c.copy$default$7();
                return c.copy(x$16, x$17, x$18, x$19, x$20, x$15, x$21);
            }

            public static final /* synthetic */ GradientBoostedTreesRunner.Params $anonfun$new$4(double x, GradientBoostedTreesRunner.Params c) {
                double x$22 = x;
                String x$23 = c.copy$default$1();
                String x$24 = c.copy$default$2();
                String x$25 = c.copy$default$3();
                String x$26 = c.copy$default$4();
                int x$27 = c.copy$default$5();
                int x$28 = c.copy$default$6();
                return c.copy(x$23, x$24, x$25, x$26, x$27, x$28, x$22);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GradientBoostedTrees: an example decision tree app."}));
                this.opt("algo", Read$.MODULE$.stringRead()).text(new StringBuilder(23).append("algorithm (").append(Algo$.MODULE$.values().mkString(",")).append("), default: ").append(defaultParams$1.algo()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$1 = x;
                    String x$2 = c.copy$default$1();
                    String x$3 = c.copy$default$2();
                    String x$4 = c.copy$default$3();
                    int x$5 = c.copy$default$5();
                    int x$6 = c.copy$default$6();
                    double x$7 = c.copy$default$7();
                    return c.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7);
                });
                this.opt("maxDepth", Read$.MODULE$.intRead()).text(new StringBuilder(32).append("max depth of the tree, default: ").append(defaultParams$1.maxDepth()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("numIterations", Read$.MODULE$.intRead()).text(new StringBuilder(43).append("number of iterations of boosting,").append(" default: ").append(defaultParams$1.numIterations()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder(103).append("fraction of data to hold out for testing.  If given option testInput, ").append("this option is ignored. default: ").append(defaultParams$1.fracTest()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder(76).append("input path to test dataset.  If given, option fracTest is ignored.").append(" default: ").append(defaultParams$1.testInput()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$29 = x;
                    String x$30 = c.copy$default$1();
                    String x$31 = c.copy$default$3();
                    String x$32 = c.copy$default$4();
                    int x$33 = c.copy$default$5();
                    int x$34 = c.copy$default$6();
                    double x$35 = c.copy$default$7();
                    return c.copy(x$30, x$29, x$31, x$32, x$33, x$34, x$35);
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$36 = x;
                    String x$37 = c.copy$default$1();
                    String x$38 = c.copy$default$2();
                    String x$39 = c.copy$default$4();
                    int x$40 = c.copy$default$5();
                    int x$41 = c.copy$default$6();
                    double x$42 = c.copy$default$7();
                    return c.copy(x$37, x$38, x$36, x$39, x$40, x$41, x$42);
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7()));
                this.checkConfig((Function1 & Serializable & scala.Serializable)params -> {
                    if (params.fracTest() < 0.0 || params.fracTest() > 1.0) {
                        return this.failure(new StringBuilder(46).append("fracTest ").append(params.fracTest()).append(" value incorrect; should be in [0,1].").toString());
                    }
                    return this.success();
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params ), $anonfun$new$4$adapted(java.lang.Object org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params ), $anonfun$new$5(java.lang.String org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params ), $anonfun$new$6(java.lang.String org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params ), $anonfun$new$7(java.lang.String org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params ), $anonfun$new$8(org.apache.spark.examples.mllib.GradientBoostedTreesRunner$$anon$1 org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            GradientBoostedTreesRunner.Params params = (GradientBoostedTreesRunner.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(GradientBoostedTreesRunner.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(32).append("GradientBoostedTreesRunner with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        Predef$.MODULE$.println((Object)new StringBuilder(44).append("GradientBoostedTreesRunner with parameters:\n").append(params).toString());
        Tuple3<RDD<LabeledPoint>, RDD<LabeledPoint>, Object> tuple3 = DecisionTreeRunner$.MODULE$.loadDatasets(sc, params.input(), params.dataFormat(), params.testInput(), Algo$.MODULE$.withName(params.algo()), params.fracTest());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        RDD training = (RDD)tuple3._1();
        RDD test = (RDD)tuple3._2();
        int numClasses = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)training, (Object)test, (Object)BoxesRunTime.boxToInteger((int)numClasses));
        RDD training2 = (RDD)tuple32._1();
        RDD test2 = (RDD)tuple32._2();
        int numClasses2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        BoostingStrategy boostingStrategy = BoostingStrategy$.MODULE$.defaultParams(params.algo());
        boostingStrategy.treeStrategy().numClasses_$eq(numClasses2);
        boostingStrategy.numIterations_$eq(params.numIterations());
        boostingStrategy.treeStrategy().maxDepth_$eq(params.maxDepth());
        int randomSeed = Utils$.MODULE$.random().nextInt();
        String string = params.algo();
        String string2 = "Classification";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            long startTime = System.nanoTime();
            GradientBoostedTreesModel model = GradientBoostedTrees$.MODULE$.train(training2, boostingStrategy);
            double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
            Predef$.MODULE$.println((Object)new StringBuilder(23).append("Training time: ").append(elapsedTime).append(" seconds").toString());
            if (model.totalNumNodes() < 30) {
                Predef$.MODULE$.println((Object)model.toDebugString());
            } else {
                Predef$.MODULE$.println((Object)model);
            }
            double trainAccuracy = new MulticlassMetrics(training2.map((Function1 & Serializable & scala.Serializable)lp -> new Tuple2.mcDD.sp(model.predict(lp.features()), lp.label()), ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
            Predef$.MODULE$.println((Object)new StringBuilder(17).append("Train accuracy = ").append(trainAccuracy).toString());
            double testAccuracy = new MulticlassMetrics(test2.map((Function1 & Serializable & scala.Serializable)lp -> new Tuple2.mcDD.sp(model.predict(lp.features()), lp.label()), ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("Test accuracy = ").append(testAccuracy).toString());
        } else {
            String string3 = params.algo();
            String string4 = "Regression";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                long startTime = System.nanoTime();
                GradientBoostedTreesModel model = GradientBoostedTrees$.MODULE$.train(training2, boostingStrategy);
                double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                Predef$.MODULE$.println((Object)new StringBuilder(23).append("Training time: ").append(elapsedTime).append(" seconds").toString());
                if (model.totalNumNodes() < 30) {
                    Predef$.MODULE$.println((Object)model.toDebugString());
                } else {
                    Predef$.MODULE$.println((Object)model);
                }
                double trainMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)training2);
                Predef$.MODULE$.println((Object)new StringBuilder(27).append("Train mean squared error = ").append(trainMSE).toString());
                double testMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)test2);
                Predef$.MODULE$.println((Object)new StringBuilder(26).append("Test mean squared error = ").append(testMSE).toString());
            }
        }
        sc.stop();
    }

    public double meanSquaredError(GradientBoostedTreesModel model, RDD<LabeledPoint> data) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1 & Serializable & scala.Serializable)y -> BoxesRunTime.boxToDouble((double)GradientBoostedTreesRunner$.$anonfun$meanSquaredError$1(model, y)), ClassTag$.MODULE$.Double())).mean();
    }

    public static final /* synthetic */ double $anonfun$meanSquaredError$1(GradientBoostedTreesModel model$2, LabeledPoint y) {
        double err = model$2.predict(y.features()) - y.label();
        return err * err;
    }

    private GradientBoostedTreesRunner$() {
        MODULE$ = this;
    }
}

