/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.OwnershipTransferNOOP;
import org.apache.arrow.memory.OwnershipTransferResult;
import org.apache.arrow.memory.RootAllocator;

public interface ReferenceManager {
    public static final String NO_OP_ERROR_MESSAGE = "Operation not supported on NO_OP Reference Manager";
    public static final ReferenceManager NO_OP = new ReferenceManager(){

        @Override
        public int getRefCount() {
            return 1;
        }

        @Override
        public boolean release() {
            return false;
        }

        @Override
        public boolean release(int decrement) {
            return false;
        }

        @Override
        public void retain() {
        }

        @Override
        public void retain(int increment) {
        }

        @Override
        public ArrowBuf retain(ArrowBuf srcBuffer, BufferAllocator targetAllocator) {
            return srcBuffer;
        }

        @Override
        public ArrowBuf deriveBuffer(ArrowBuf sourceBuffer, long index, long length) {
            return sourceBuffer;
        }

        @Override
        public OwnershipTransferResult transferOwnership(ArrowBuf sourceBuffer, BufferAllocator targetAllocator) {
            return new OwnershipTransferNOOP(sourceBuffer);
        }

        @Override
        public BufferAllocator getAllocator() {
            return new RootAllocator(0L);
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public long getAccountedSize() {
            return 0L;
        }
    };

    public int getRefCount();

    public boolean release();

    public boolean release(int var1);

    public void retain();

    public void retain(int var1);

    public ArrowBuf retain(ArrowBuf var1, BufferAllocator var2);

    public ArrowBuf deriveBuffer(ArrowBuf var1, long var2, long var4);

    public OwnershipTransferResult transferOwnership(ArrowBuf var1, BufferAllocator var2);

    public BufferAllocator getAllocator();

    public long getSize();

    public long getAccountedSize();
}

