/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.Sentences$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str[, lang[, country]]) - Splits `str` into an array of array of words.", arguments="\n    Arguments:\n      * str - A STRING expression to be parsed.\n      * lang - An optional STRING expression with a language code from ISO 639 Alpha-2 (e.g. 'DE'),\n          Alpha-3, or a language subtag of up to 8 characters.\n      * country - An optional STRING expression with a country code from ISO 3166 alpha-2 country\n          code or a UN M.49 numeric-3 area code.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Hi there! Good morning.');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n      > SELECT _FUNC_('Hi there! Good morning.', 'en');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n      > SELECT _FUNC_('Hi there! Good morning.', 'en', 'US');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001\u0002\u0015*\u0001ZB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011!Y\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B+\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0003A\u0011A2\t\u000bu\u0003A\u0011A3\t\u000b!\u0004A\u0011I5\t\u000b5\u0004A\u0011\t8\t\u000bU\u0004A\u0011\t<\t\u000bu\u0004A\u0011\t+\t\u000by\u0004A\u0011\t+\t\u000b}\u0004A\u0011\t+\t\r\u0005\u0005\u0001\u0001\"\u0011U\u0011\u001d\t\u0019\u0001\u0001C)\u0003\u000bA\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u0010\u0011%\t9\u0004AI\u0001\n\u0003\ty\u0002C\u0005\u0002:\u0001\t\t\u0011\"\u0011\u0002<!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"!\u001a\u0001\u0003\u0003%\t%a\u001a\t\u0013\u0005U\u0004!!A\u0005\u0002\u0005]\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u0011%\t\t\tAA\u0001\n\u0003\n\u0019iB\u0005\u0002.&\n\t\u0011#\u0001\u00020\u001aA\u0001&KA\u0001\u0012\u0003\t\t\f\u0003\u0004^=\u0011\u0005\u0011\u0011\u001a\u0005\n\u0003\u0017t\u0012\u0011!C#\u0003\u001bD\u0011\"a4\u001f\u0003\u0003%\t)!5\t\u0013\u0005eg$%A\u0005\u0002\u0005}\u0001\"CAn=E\u0005I\u0011AA\u0010\u0011%\tiNHA\u0001\n\u0003\u000by\u000eC\u0005\u0002rz\t\n\u0011\"\u0001\u0002 !I\u00111\u001f\u0010\u0012\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003kt\u0012\u0011!C\u0005\u0003o\u0014\u0011bU3oi\u0016t7-Z:\u000b\u0005)Z\u0013aC3yaJ,7o]5p]NT!\u0001L\u0017\u0002\u0011\r\fG/\u00197zgRT!AL\u0018\u0002\u0007M\fHN\u0003\u00021c\u0005)1\u000f]1sW*\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u001c<}\u0005;\u0005C\u0001\u001d:\u001b\u0005I\u0013B\u0001\u001e*\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003qqJ!!P\u0015\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001O \n\u0005\u0001K#A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002I!:\u0011\u0011J\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019V\na\u0001\u0010:p_Rt\u0014\"\u0001#\n\u0005=\u001b\u0015a\u00029bG.\fw-Z\u0005\u0003#J\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aT\"\u0002\u0007M$(/F\u0001V!\tAd+\u0003\u0002XS\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\tM$(\u000fI\u0001\tY\u0006tw-^1hK\u0006IA.\u00198hk\u0006<W\rI\u0001\bG>,h\u000e\u001e:z\u0003!\u0019w.\u001e8uef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003`A\u0006\u0014\u0007C\u0001\u001d\u0001\u0011\u0015\u0019v\u00011\u0001V\u0011\u001dIv\u0001%AA\u0002UCqaW\u0004\u0011\u0002\u0003\u0007Q\u000b\u0006\u0002`I\")1\u000b\u0003a\u0001+R\u0019qLZ4\t\u000bMK\u0001\u0019A+\t\u000beK\u0001\u0019A+\u0002\u00119,H\u000e\\1cY\u0016,\u0012A\u001b\t\u0003\u0005.L!\u0001\\\"\u0003\u000f\t{w\u000e\\3b]\u0006AA-\u0019;b)f\u0004X-F\u0001p!\t\u00018/D\u0001r\u0015\t\u0011X&A\u0003usB,7/\u0003\u0002uc\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012a\u001e\t\u0004\u0011bT\u0018BA=S\u0005\r\u0019V-\u001d\t\u0003anL!\u0001`9\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-A\u0006sKBd\u0017mY3nK:$\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001dy\u0016qAA\u0006\u0003\u001fAa!!\u0003\u0012\u0001\u0004)\u0016\u0001\u00038fo\u001aK'o\u001d;\t\r\u00055\u0011\u00031\u0001V\u0003%qWm^*fG>tG\r\u0003\u0004\u0002\u0012E\u0001\r!V\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u001dy\u0016qCA\r\u00037Aqa\u0015\n\u0011\u0002\u0003\u0007Q\u000bC\u0004Z%A\u0005\t\u0019A+\t\u000fm\u0013\u0002\u0013!a\u0001+\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0011U\r)\u00161E\u0016\u0003\u0003K\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0005v]\u000eDWmY6fI*\u0019\u0011qF\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00024\u0005%\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0005Y\u0006twM\u0003\u0002\u0002H\u0005!!.\u0019<b\u0013\u0011\tY%!\u0011\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0006E\u0002C\u0003'J1!!\u0016D\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY&!\u0019\u0011\u0007\t\u000bi&C\u0002\u0002`\r\u00131!\u00118z\u0011%\t\u0019\u0007GA\u0001\u0002\u0004\t\t&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0002b!a\u001b\u0002r\u0005mSBAA7\u0015\r\tygQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA:\u0003[\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019!.!\u001f\t\u0013\u0005\r$$!AA\u0002\u0005m\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0010\u0002\u0000!I\u00111M\u000e\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0007KF,\u0018\r\\:\u0015\u0007)\f)\tC\u0005\u0002dq\t\t\u00111\u0001\u0002\\!:\u0002!!#\u0002\u0010\u0006E\u0015QSAL\u00037\u000bi*!)\u0002$\u0006\u001d\u0016\u0011\u0016\t\u0004q\u0005-\u0015bAAGS\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAJ\u00039{f)\u0016(D?\"\u001aHO].-A1\fgnZ.-A\r|WO\u001c;ssvk\u0016\u0006I\u0017!'Bd\u0017\u000e^:!AN$(\u000f\u0019\u0011j]R|\u0007%\u00198!CJ\u0014\u0018-\u001f\u0011pM\u0002\n'O]1zA=4\u0007e^8sINt\u0013!C1sOVlWM\u001c;tC\t\tI*\u0001By\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0005e\u0015+S\u0013:;\u0005%\u001a=qe\u0016\u001c8/[8oAQ|\u0007EY3!a\u0006\u00148/\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001b\u0017M\\4![\u0001\ne\u000eI8qi&|g.\u00197!'R\u0013\u0016JT$!Kb\u0004(/Z:tS>t\u0007e^5uQ\u0002\n\u0007\u0005\\1oOV\fw-\u001a\u0011d_\u0012,\u0007E\u001a:p[\u0002J5k\u0014\u00117ge\u0002\u0013\t\u001c9iC6\u0012\u0004\u0005K3/O:\u0002s\u0005R#(S1R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011BYBD\u0017-L\u001a-A=\u0014\b%\u0019\u0011mC:<W/Y4fAM,(\r^1hA=4\u0007%\u001e9!i>\u0004\u0003\bI2iCJ\f7\r^3sg:R\u0001\u0005\t\u0011!A\u0001R\u0003eY8v]R\u0014\u0018\u0010I\u0017!\u0003:\u0004s\u000e\u001d;j_:\fG\u000eI*U%&su\tI3yaJ,7o]5p]\u0002:\u0018\u000e\u001e5!C\u0002\u001aw.\u001e8uef\u00043m\u001c3fA\u0019\u0014x.\u001c\u0011J'>\u00033'\r\u001c7A\u0005d\u0007\u000f[1.e\u0001\u001aw.\u001e8uefT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011d_\u0012,\u0007e\u001c:!C\u0002*f\nI'/ie\u0002c.^7fe&\u001cWf\r\u0011be\u0016\f\u0007eY8eK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qT\u0001\u0003v)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005S5!i\",'/Z\u0011!\u000f>|G\rI7pe:Lgn\u001a\u0018(SmR\u0001\u0005\t\u0011!A\u0001\u00023l\u0017\u0012IS\nb#\u0005\u001e5fe\u0016\u0014S\fL.#\u000f>|GM\t\u0017#[>\u0014h.\u001b8hEuk&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014IS\u0002\"\b.\u001a:fC\u0001:un\u001c3![>\u0014h.\u001b8h]\u001db\u0003eJ3oO%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW.#\u0011&\u0014CF\t;iKJ,'%\u0018\u0017\\E\u001d{w\u000e\u001a\u0012-E5|'O\\5oO\njVL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0011&\u0004C\u000f[3sK\u0006\u0002si\\8eA5|'O\\5oO::C\u0006I\u0014f]\u001eb\u0003eJ+TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW.#\u0011&\u0014CF\t;iKJ,'%\u0018\u0017\\E\u001d{w\u000e\u001a\u0012-E5|'O\\5oO\njVL\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t)+A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002,\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006I1+\u001a8uK:\u001cWm\u001d\t\u0003qy\u0019RAHAZ\u0003\u007f\u0003\u0002\"!.\u0002<V+VkX\u0007\u0003\u0003oS1!!/D\u0003\u001d\u0011XO\u001c;j[\u0016LA!!0\u00028\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005\u0005\u0017qY\u0007\u0003\u0003\u0007TA!!2\u0002F\u0005\u0011\u0011n\\\u0005\u0004#\u0006\rGCAAX\u0003!!xn\u0015;sS:<GCAA\u001f\u0003\u0015\t\u0007\u000f\u001d7z)\u001dy\u00161[Ak\u0003/DQaU\u0011A\u0002UCq!W\u0011\u0011\u0002\u0003\u0007Q\u000bC\u0004\\CA\u0005\t\u0019A+\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t/!<\u0011\u000b\t\u000b\u0019/a:\n\u0007\u0005\u00158I\u0001\u0004PaRLwN\u001c\t\u0007\u0005\u0006%X+V+\n\u0007\u0005-8I\u0001\u0004UkBdWm\r\u0005\t\u0003_$\u0013\u0011!a\u0001?\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011 \t\u0005\u0003\u007f\tY0\u0003\u0003\u0002~\u0006\u0005#AB(cU\u0016\u001cG\u000f")
public class Sentences
extends TernaryExpression
implements ImplicitCastInputTypes,
RuntimeReplaceable,
Serializable {
    private final Expression str;
    private final Expression language;
    private final Expression country;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Expression $lessinit$greater$default$3() {
        return Sentences$.MODULE$.$lessinit$greater$default$3();
    }

    public static Expression $lessinit$greater$default$2() {
        return Sentences$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Sentences x$0) {
        return Sentences$.MODULE$.unapply(x$0);
    }

    public static Expression apply$default$3() {
        return Sentences$.MODULE$.apply$default$3();
    }

    public static Expression apply$default$2() {
        return Sentences$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Sentences> tupled() {
        return Sentences$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Sentences>>> curried() {
        return Sentences$.MODULE$.curried();
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        Sentences sentences = this;
        synchronized (sentences) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression str() {
        return this.str;
    }

    public Expression language() {
        return this.language;
    }

    public Expression country() {
        return this.country;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType((DataType)new ArrayType(this.str().dataType(), false), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.language();
    }

    @Override
    public Expression third() {
        return this.country();
    }

    @Override
    public Expression replacement() {
        return new StaticInvoke(ExpressionImplUtils.class, this.dataType(), "getSentences", (Seq<Expression>)new .colon.colon((Object)this.str(), (List)new .colon.colon((Object)this.language(), (List)new .colon.colon((Object)this.country(), (List)Nil$.MODULE$))), this.inputTypes(), false, StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
    }

    @Override
    public Sentences withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public Sentences copy(Expression str, Expression language, Expression country) {
        return new Sentences(str, language, country);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.language();
    }

    public Expression copy$default$3() {
        return this.country();
    }

    @Override
    public String productPrefix() {
        return "Sentences";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.language();
            }
            case 2: {
                return this.country();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sentences;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "language";
            }
            case 2: {
                return "country";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sentences)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sentences sentences = (Sentences)x$1;
        Expression expression = this.str();
        Expression expression2 = sentences.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.language();
        Expression expression4 = sentences.language();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.country();
        Expression expression6 = sentences.country();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!sentences.canEqual(this)) return false;
        return true;
    }

    public Sentences(Expression str, Expression language, Expression country) {
        this.str = str;
        this.language = language;
        this.country = country;
        ExpectsInputTypes.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public Sentences(Expression str) {
        this(str, Literal$.MODULE$.apply(""), Literal$.MODULE$.apply(""));
    }

    public Sentences(Expression str, Expression language) {
        this(str, language, Literal$.MODULE$.apply(""));
    }
}

