/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.spark.JobArtifactSet;
import org.apache.spark.JobArtifactState;
import org.apache.spark.scheduler.TaskDescription;
import org.apache.spark.util.ByteBufferInputStream;
import org.apache.spark.util.ByteBufferOutputStream;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TaskDescription$ {
    public static final TaskDescription$ MODULE$ = new TaskDescription$();

    private void serializeStringLongMap(Map<String, Object> map, DataOutputStream dataOut) {
        dataOut.writeInt(map.size());
        map.foreach((Function1 & Serializable)x0$1 -> {
            TaskDescription$.$anonfun$serializeStringLongMap$1(dataOut, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void serializeResources(scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, Object>> map, DataOutputStream dataOut) {
        dataOut.writeInt(map.size());
        map.foreach((Function1 & Serializable)x0$1 -> {
            TaskDescription$.$anonfun$serializeResources$1(dataOut, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public ByteBuffer encode(TaskDescription taskDescription) {
        ByteBufferOutputStream bytesOut = new ByteBufferOutputStream(4096);
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        dataOut.writeLong(taskDescription.taskId());
        dataOut.writeInt(taskDescription.attemptNumber());
        dataOut.writeUTF(taskDescription.executorId());
        dataOut.writeUTF(taskDescription.name());
        dataOut.writeInt(taskDescription.index());
        dataOut.writeInt(taskDescription.partitionId());
        this.serializeArtifacts(taskDescription.artifacts(), dataOut);
        dataOut.writeInt(taskDescription.properties().size());
        CollectionConverters$.MODULE$.PropertiesHasAsScala(taskDescription.properties()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            TaskDescription$.$anonfun$encode$1(dataOut, x0$1);
            return BoxedUnit.UNIT;
        });
        dataOut.writeInt(taskDescription.cpus());
        this.serializeResources(taskDescription.resources(), dataOut);
        Utils$.MODULE$.writeByteBuffer(taskDescription.serializedTask(), bytesOut);
        dataOut.close();
        bytesOut.close();
        return bytesOut.toByteBuffer();
    }

    private Option<String> deserializeOptionString(DataInputStream in) {
        if (in.readBoolean()) {
            return new Some((Object)in.readUTF());
        }
        return None$.MODULE$;
    }

    private JobArtifactSet deserializeArtifacts(DataInputStream dataIn) {
        return new JobArtifactSet((Option<JobArtifactState>)this.deserializeOptionString(dataIn).map((Function1 & Serializable)uuid -> new JobArtifactState((String)uuid, MODULE$.deserializeOptionString(dataIn))), (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Map$.MODULE$.apply(this.deserializeStringLongMap(dataIn).toSeq())), (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Map$.MODULE$.apply(this.deserializeStringLongMap(dataIn).toSeq())), (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Map$.MODULE$.apply(this.deserializeStringLongMap(dataIn).toSeq())));
    }

    private void serializeOptionString(Option<String> str, DataOutputStream out) {
        out.writeBoolean(str.isDefined());
        if (str.isDefined()) {
            out.writeUTF((String)str.get());
            return;
        }
    }

    private void serializeArtifacts(JobArtifactSet artifacts, DataOutputStream dataOut) {
        this.serializeOptionString((Option<String>)artifacts.state().map((Function1 & Serializable)x$1 -> x$1.uuid()), dataOut);
        artifacts.state().foreach((Function1 & Serializable)state -> {
            TaskDescription$.MODULE$.serializeOptionString(state.replClassDirUri(), dataOut);
            return BoxedUnit.UNIT;
        });
        this.serializeStringLongMap((Map<String, Object>)((Map)scala.collection.mutable.Map$.MODULE$.apply(artifacts.jars().toSeq())), dataOut);
        this.serializeStringLongMap((Map<String, Object>)((Map)scala.collection.mutable.Map$.MODULE$.apply(artifacts.files().toSeq())), dataOut);
        this.serializeStringLongMap((Map<String, Object>)((Map)scala.collection.mutable.Map$.MODULE$.apply(artifacts.archives().toSeq())), dataOut);
    }

    private HashMap<String, Object> deserializeStringLongMap(DataInputStream dataIn) {
        HashMap map = new HashMap();
        int mapSize = dataIn.readInt();
        for (int i = 0; i < mapSize; ++i) {
            map.update((Object)dataIn.readUTF(), (Object)BoxesRunTime.boxToLong((long)dataIn.readLong()));
        }
        return map;
    }

    private scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, Object>> deserializeResources(DataInputStream dataIn) {
        HashMap map = new HashMap();
        int mapSize = dataIn.readInt();
        for (int i = 0; i < mapSize; ++i) {
            String resType = dataIn.readUTF();
            HashMap addressAmountMap = new HashMap();
            int addressAmountSize = dataIn.readInt();
            for (int j = 0; j < addressAmountSize; ++j) {
                String address = dataIn.readUTF();
                long amount = dataIn.readLong();
                addressAmountMap.update((Object)address, (Object)BoxesRunTime.boxToLong((long)amount));
            }
            map.put((Object)resType, (Object)addressAmountMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        return map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public TaskDescription decode(ByteBuffer byteBuffer) {
        DataInputStream dataIn = new DataInputStream(new ByteBufferInputStream(byteBuffer));
        long taskId = dataIn.readLong();
        int attemptNumber = dataIn.readInt();
        String executorId = dataIn.readUTF();
        String name = dataIn.readUTF();
        int index = dataIn.readInt();
        int partitionId = dataIn.readInt();
        JobArtifactSet artifacts = this.deserializeArtifacts(dataIn);
        Properties properties = new Properties();
        int numProperties = dataIn.readInt();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numProperties).foreach((Function1 & Serializable)i -> TaskDescription$.$anonfun$decode$1(dataIn, properties, BoxesRunTime.unboxToInt((Object)i)));
        int cpus = dataIn.readInt();
        scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, Object>> resources = this.deserializeResources(dataIn);
        ByteBuffer serializedTask = byteBuffer.slice();
        return new TaskDescription(taskId, attemptNumber, executorId, name, index, partitionId, artifacts, properties, cpus, resources, serializedTask);
    }

    public static final /* synthetic */ void $anonfun$serializeStringLongMap$1(DataOutputStream dataOut$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            dataOut$1.writeUTF(key);
            dataOut$1.writeLong(value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$serializeResources$2(DataOutputStream dataOut$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String address = (String)tuple2._1();
            long amount = tuple2._2$mcJ$sp();
            dataOut$2.writeUTF(address);
            dataOut$2.writeLong(amount);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$serializeResources$1(DataOutputStream dataOut$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rName = (String)tuple2._1();
            scala.collection.immutable.Map addressAmountMap = (scala.collection.immutable.Map)tuple2._2();
            dataOut$2.writeUTF(rName);
            dataOut$2.writeInt(addressAmountMap.size());
            addressAmountMap.foreach((Function1 & Serializable)x0$2 -> {
                TaskDescription$.$anonfun$serializeResources$2(dataOut$2, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$encode$1(DataOutputStream dataOut$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            dataOut$3.writeUTF(key);
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            dataOut$3.writeInt(bytes.length);
            dataOut$3.write(bytes);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Object $anonfun$decode$1(DataInputStream dataIn$2, Properties properties$1, int i) {
        String key = dataIn$2.readUTF();
        int valueLength = dataIn$2.readInt();
        byte[] valueBytes = new byte[valueLength];
        dataIn$2.readFully(valueBytes);
        return properties$1.setProperty(key, new String(valueBytes, StandardCharsets.UTF_8));
    }

    private TaskDescription$() {
    }
}

