/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildRight$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.BroadcastQueryStageExec;
import org.apache.spark.sql.execution.adaptive.InvalidAQEPlanException;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.BroadcastNestedLoopJoinExec;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class ValidateSparkPlan$
extends Rule<SparkPlan> {
    public static final ValidateSparkPlan$ MODULE$ = new ValidateSparkPlan$();

    public SparkPlan apply(SparkPlan plan) {
        this.validate(plan);
        return plan;
    }

    private void validate(SparkPlan plan2) {
        SparkPlan sparkPlan;
        while (true) {
            Tuple2 tuple2;
            if ((sparkPlan = plan2) instanceof BroadcastHashJoinExec) {
                Tuple2 tuple22;
                BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)sparkPlan;
                BuildSide buildSide = broadcastHashJoinExec.buildSide();
                if (BuildLeft$.MODULE$.equals(buildSide)) {
                    tuple22 = new Tuple2((Object)broadcastHashJoinExec.left(), (Object)broadcastHashJoinExec.right());
                } else if (BuildRight$.MODULE$.equals(buildSide)) {
                    tuple22 = new Tuple2((Object)broadcastHashJoinExec.right(), (Object)broadcastHashJoinExec.left());
                } else {
                    throw new MatchError((Object)buildSide);
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                SparkPlan buildPlan = (SparkPlan)tuple23._1();
                SparkPlan probePlan = (SparkPlan)tuple23._2();
                Tuple2 tuple24 = new Tuple2((Object)buildPlan, (Object)probePlan);
                SparkPlan buildPlan2 = (SparkPlan)tuple24._1();
                SparkPlan probePlan2 = (SparkPlan)tuple24._2();
                if (!(buildPlan2 instanceof BroadcastQueryStageExec)) {
                    this.validate(buildPlan2);
                }
                plan2 = probePlan2;
                continue;
            }
            if (!(sparkPlan instanceof BroadcastNestedLoopJoinExec)) break;
            BroadcastNestedLoopJoinExec broadcastNestedLoopJoinExec = (BroadcastNestedLoopJoinExec)sparkPlan;
            BuildSide buildSide = broadcastNestedLoopJoinExec.buildSide();
            if (BuildLeft$.MODULE$.equals(buildSide)) {
                tuple2 = new Tuple2((Object)broadcastNestedLoopJoinExec.left(), (Object)broadcastNestedLoopJoinExec.right());
            } else if (BuildRight$.MODULE$.equals(buildSide)) {
                tuple2 = new Tuple2((Object)broadcastNestedLoopJoinExec.right(), (Object)broadcastNestedLoopJoinExec.left());
            } else {
                throw new MatchError((Object)buildSide);
            }
            Tuple2 tuple25 = tuple2;
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            SparkPlan buildPlan = (SparkPlan)tuple25._1();
            SparkPlan probePlan = (SparkPlan)tuple25._2();
            Tuple2 tuple26 = new Tuple2((Object)buildPlan, (Object)probePlan);
            SparkPlan buildPlan3 = (SparkPlan)tuple26._1();
            SparkPlan probePlan3 = (SparkPlan)tuple26._2();
            if (!(buildPlan3 instanceof BroadcastQueryStageExec)) {
                this.validate(buildPlan3);
            }
            plan2 = probePlan3;
        }
        if (sparkPlan instanceof BroadcastQueryStageExec) {
            BroadcastQueryStageExec broadcastQueryStageExec = (BroadcastQueryStageExec)sparkPlan;
            this.errorOnInvalidBroadcastQueryStage(broadcastQueryStageExec);
        } else {
            plan2.children().foreach((Function1 & Serializable)plan -> {
                ValidateSparkPlan$.MODULE$.validate(plan);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void errorOnInvalidBroadcastQueryStage(SparkPlan plan) {
        throw new InvalidAQEPlanException<SparkPlan>("Invalid broadcast query stage", plan);
    }

    private ValidateSparkPlan$() {
    }
}

