/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` equals `expr2`, or false otherwise.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       NULL\n      > SELECT NULL _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0015_\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015\u0019\b\u0001\"\u0015u\u0011\u001dI\b!!A\u0005\u0002iDq! \u0001\u0012\u0002\u0013\u0005a\u0010\u0003\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u007f\u0011%\t)\u0002AA\u0001\n\u0003\n9\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003s\u0001\u0011\u0011!C!\u0003wA\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005=\u0003!!A\u0005B\u0005E\u0003\"CA+\u0001\u0005\u0005I\u0011IA,\u000f%\t\t)HA\u0001\u0012\u0003\t\u0019I\u0002\u0005\u001d;\u0005\u0005\t\u0012AAC\u0011\u0019Ie\u0003\"\u0001\u0002\u001e\"I\u0011q\u0014\f\u0002\u0002\u0013\u0015\u0013\u0011\u0015\u0005\n\u0003G3\u0012\u0011!CA\u0003KC\u0011\"a+\u0017\u0003\u0003%\t)!,\t\u0013\u0005}f#!A\u0005\n\u0005\u0005'aB#rk\u0006dGk\u001c\u0006\u0003=}\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001%I\u0001\tG\u0006$\u0018\r\\=ti*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M!\u0001aK\u00186!\taS&D\u0001\u001e\u0013\tqSD\u0001\tCS:\f'/_\"p[B\f'/[:p]B\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t9\u0001K]8ek\u000e$\bC\u0001\u001c?\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;S\u00051AH]8pizJ\u0011AM\u0005\u0003{E\nq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\na1+\u001a:jC2L'0\u00192mK*\u0011Q(M\u0001\u0005Y\u00164G/F\u0001D!\taC)\u0003\u0002F;\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u00191\nT'\u0011\u00051\u0002\u0001\"B!\u0006\u0001\u0004\u0019\u0005\"B$\u0006\u0001\u0004\u0019\u0015A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002!B\u0011\u0001'U\u0005\u0003%F\u0012qAQ8pY\u0016\fg.\u0001\u0004ts6\u0014w\u000e\\\u000b\u0002+B\u0011aK\u0017\b\u0003/b\u0003\"\u0001O\u0019\n\u0005e\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!W\u0019\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007}\u00137\r\u0005\u00021A&\u0011\u0011-\r\u0002\u0004\u0003:L\b\"B!\t\u0001\u0004y\u0006\"B$\t\u0001\u0004y\u0016!\u00033p\u000f\u0016t7i\u001c3f)\r1G.\u001d\t\u0003O*l\u0011\u0001\u001b\u0006\u0003Sv\tqaY8eK\u001e,g.\u0003\u0002lQ\nAQ\t\u001f9s\u0007>$W\rC\u0003n\u0013\u0001\u0007a.A\u0002dib\u0004\"aZ8\n\u0005AD'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006e&\u0001\rAZ\u0001\u0003KZ\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007-+x\u000fC\u0003w\u0015\u0001\u00071)A\u0004oK^dUM\u001a;\t\u000baT\u0001\u0019A\"\u0002\u00119,wOU5hQR\fAaY8qsR\u00191j\u001f?\t\u000f\u0005[\u0001\u0013!a\u0001\u0007\"9qi\u0003I\u0001\u0002\u0004\u0019\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002\u007f*\u001a1)!\u0001,\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00042\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\t9AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003mC:<'BAA\u0012\u0003\u0011Q\u0017M^1\n\u0007m\u000bi\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002,A\u0019\u0001'!\f\n\u0007\u0005=\u0012GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002`\u0003kA\u0011\"a\u000e\u0011\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0004E\u0003\u0002@\u0005\u0015s,\u0004\u0002\u0002B)\u0019\u00111I\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005\u0005#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001UA'\u0011!\t9DEA\u0001\u0002\u0004y\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0007\u0002T!I\u0011qG\n\u0002\u0002\u0003\u0007\u00111F\u0001\u0007KF,\u0018\r\\:\u0015\u0007A\u000bI\u0006\u0003\u0005\u00028Q\t\t\u00111\u0001`Q]\u0001\u0011QLA2\u0003K\nI'a\u001b\u0002p\u0005E\u0014QOA<\u0003w\ni\bE\u0002-\u0003?J1!!\u0019\u001e\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u001a\u0002!\u0016D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.AI+G/\u001e:og\u0002\"(/^3!S\u001a\u0004\u0003-\u001a=qeF\u0002\u0007%Z9vC2\u001c\b\u0005Y3yaJ\u0014\u0004\r\f\u0011pe\u00022\u0017\r\\:fA=$\b.\u001a:xSN,g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QN\u0001\u0003^)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeFb\u0003%\u001a=qeJ\u0002S\u0006\t;iK\u0002\"xo\u001c\u0011fqB\u0014Xm]:j_:\u001c\b%\\;ti\u0002\u0012W\rI:b[\u0016\u0004C/\u001f9fA=\u0014\beY1oA\t,\u0007eY1ti\u0016$\u0007\u0005^8!C\u0002\u001aw.\\7p]\u0002\"\u0018\u0010]3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eA5,8\u000f\u001e\u0011cK\u0002\n\u0007\u0005^=qK\u0002\"\b.\u0019;!G\u0006t\u0007EY3!kN,G\rI5oA\u0015\fX/\u00197jif\u00043m\\7qCJL7o\u001c8/A5\u000b\u0007\u000f\t;za\u0016\u0004\u0013n\u001d\u0011o_R\u00043/\u001e9q_J$X\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002ci\u001c:!G>l\u0007\u000f\\3yAQL\b/Z:!gV\u001c\u0007\u000eI1se\u0006Lxf\u001d;sk\u000e$H\u0006\t;iK\u0002\"\u0017\r^1!if\u0004Xm\u001d\u0011pM\u00022\u0017.\u001a7eg\u0002jWo\u001d;!E\u0016\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003g\n\u0011q\u000f\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!e\u0001zf)\u0016(D?\u0002\u00124H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u0011`\rVs5i\u0018\u0011(c\u001dZ$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003CO];fA}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011O+2c\u0005e\u0018$V\u001d\u000e{\u0006ET+M\u0019nR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA=\u0003\u0015\td\u0006\r\u00181\u0003\u00159'o\\;qC\t\ty(A\bqe\u0016$\u0017nY1uK~3WO\\2t\u0003\u001d)\u0015/^1m)>\u0004\"\u0001\f\f\u0014\u000bY\t9)a%\u0011\u000f\u0005%\u0015qR\"D\u00176\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u000b\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003#\u000bYIA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0005\u00033\u000b\t#\u0001\u0002j_&\u0019q(a&\u0015\u0005\u0005\r\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0011!B1qa2LH#B&\u0002(\u0006%\u0006\"B!\u001a\u0001\u0004\u0019\u0005\"B$\u001a\u0001\u0004\u0019\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003_\u000bY\fE\u00031\u0003c\u000b),C\u0002\u00024F\u0012aa\u00149uS>t\u0007#\u0002\u0019\u00028\u000e\u001b\u0015bAA]c\t1A+\u001e9mKJB\u0001\"!0\u001b\u0003\u0003\u0005\raS\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAb!\u0011\tY\"!2\n\t\u0005\u001d\u0017Q\u0004\u0002\u0007\u001f\nTWm\u0019;")
public class EqualTo
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualTo x$0) {
        return EqualTo$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualTo> tupled() {
        return EqualTo$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualTo>> curried() {
        return EqualTo$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public String symbol() {
        return "=";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(left, right));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(c1, c2) -> ctx.genEqual(this.left().dataType(), (String)c1, (String)c2));
    }

    @Override
    public EqualTo withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public EqualTo copy(Expression left, Expression right) {
        return new EqualTo(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualTo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualTo;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualTo equalTo = (EqualTo)x$1;
        Expression expression = this.left();
        Expression expression2 = equalTo.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalTo.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalTo.canEqual(this)) return false;
        return true;
    }

    public EqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

