/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;

public final class ParquetRowIndexUtil$ {
    public static final ParquetRowIndexUtil$ MODULE$ = new ParquetRowIndexUtil$();

    public ParquetRowIndexUtil.RowIndexGenerator createGeneratorIfNeeded(StructType sparkSchema) {
        int columnIdx = this.findRowIndexColumnIndexInSchema(sparkSchema);
        if (columnIdx >= 0) {
            return new ParquetRowIndexUtil.RowIndexGenerator(columnIdx);
        }
        return null;
    }

    public RecordReader<Void, InternalRow> addRowIndexToRecordReaderIfNeeded(ParquetRecordReader<InternalRow> reader, StructType sparkSchema) {
        int rowIndexColumnIdx = this.findRowIndexColumnIndexInSchema(sparkSchema);
        if (rowIndexColumnIdx >= 0) {
            return new ParquetRowIndexUtil.RecordReaderWithRowIndexes(reader, rowIndexColumnIdx);
        }
        return reader;
    }

    public int findRowIndexColumnIndexInSchema(StructType sparkSchema) {
        Some some;
        Tuple2 tuple2;
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])sparkSchema.fields()))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetRowIndexUtil$.$anonfun$findRowIndexColumnIndexInSchema$1(x0$1)));
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            StructField field = (StructField)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            if (field != null) {
                StructField structField = field;
                if (true) {
                    int n = idx;
                    DataType dataType = structField.dataType();
                    LongType$ longType$ = LongType$.MODULE$;
                    if (dataType == null ? longType$ != null : !dataType.equals(longType$)) {
                        throw new RuntimeException(ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME() + " must be of LongType");
                    }
                    return n;
                }
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRowIndexColumn(ParquetColumn column) {
        if (column.path().length() != 1) return false;
        Object object = column.path().last();
        String string = ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
        if (object != null) {
            if (!object.equals(string)) return false;
            return true;
        }
        if (string == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$findRowIndexColumnIndexInSchema$1(Tuple2 x0$1) {
        StructField field;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (field = (StructField)tuple2._1()) != null) {
            StructField structField = field;
            if (true) {
                String string = structField.name();
                String string2 = ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private ParquetRowIndexUtil$() {
    }
}

