/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001B\u0012%\u0001EBQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001A\u0002\u0013%1\tC\u0004N\u0001\u0001\u0007I\u0011\u0002(\t\rQ\u0003\u0001\u0015)\u0003E\u0011\u001dI\u0006A1A\u0005\niCaa\u001b\u0001!\u0002\u0013Y\u0006b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007{\u0002\u0001\u000b\u0011\u00028\t\u000by\u0004A\u0011A@\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\u0005\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!A\u00111\n\u0001\u0005\u0002\u0019\ni\u0005\u0003\u0005\u0002X\u0001!\tAJA-\u0011!\ty\u0006\u0001C\u0001M\u0005\u0005\u0004\u0002CA4\u0001\u0011\u0005a%!\u001b\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\n\u0003?\u0003\u0011\u0013!C\u0005\u0003CCq!a.\u0001\t\u0013\tI\fC\u0005\u0002B\u0002\t\n\u0011\"\u0003\u0002\"\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007\"CAf\u0001E\u0005I\u0011AAQ\u0011!\ti\r\u0001C\u0001M\u0005=\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003O\u0004A\u0011AAj\u0011\u001d\tI\u000f\u0001C\u0005\u0003\u001fD\u0001\"a;\u0001\t\u00031\u0013Q\u001e\u0005\b\u0003W\u0004A\u0011BA}\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007AqA!\u0002\u0001\t\u0013\u00119\u0001\u0003\u0005\u0003\f\u0001!\tAJAh\u0011!\u0011i\u0001\u0001C\u0001M\t=!AG*qCJ\\7i\u001c8oK\u000e$8+Z:tS>tW*\u00198bO\u0016\u0014(BA\u0013'\u0003\u001d\u0019XM\u001d<jG\u0016T!a\n\u0015\u0002\u000f\r|gN\\3di*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g!\tID(D\u0001;\u0015\tY$&\u0001\u0005j]R,'O\\1m\u0013\ti$HA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0001\u0005CA!\u0001\u001b\u0005!\u0013a\u00032bg\u0016\u001cVm]:j_:,\u0012\u0001\u0012\t\u0004g\u0015;\u0015B\u0001$5\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nK\u0001\bG2\f7o]5d\u0013\ta\u0015J\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\bcCN,7+Z:tS>tw\fJ3r)\ty%\u000b\u0005\u00024!&\u0011\u0011\u000b\u000e\u0002\u0005+:LG\u000fC\u0004T\u0007\u0005\u0005\t\u0019\u0001#\u0002\u0007a$\u0013'\u0001\u0007cCN,7+Z:tS>t\u0007\u0005\u000b\u0002\u0005-B\u00111gV\u0005\u00031R\u0012\u0001B^8mCRLG.Z\u0001\rg\u0016\u001c8/[8o'R|'/Z\u000b\u00027B!AlY3i\u001b\u0005i&B\u00010`\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003A\u0006\fA!\u001e;jY*\t!-\u0001\u0003kCZ\f\u0017B\u00013^\u00055\u0019uN\\2veJ,g\u000e^'baB\u0011\u0011IZ\u0005\u0003O\u0012\u0012!bU3tg&|gnS3z!\t\t\u0015.\u0003\u0002kI\ti1+Z:tS>t\u0007j\u001c7eKJ\fQb]3tg&|gn\u0015;pe\u0016\u0004\u0013aE2m_N,GmU3tg&|gn]\"bG\",W#\u00018\u0011\t=DXM_\u0007\u0002a*\u0011\u0011O]\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003gR\faaY8n[>t'BA;w\u0003\u00199wn\\4mK*\tq/A\u0002d_6L!!\u001f9\u0003\u000b\r\u000b7\r[3\u0011\u0005\u0005[\u0018B\u0001?%\u0005E\u0019Vm]:j_:Du\u000e\u001c3fe&sgm\\\u0001\u0015G2|7/\u001a3TKN\u001c\u0018n\u001c8t\u0007\u0006\u001c\u0007.\u001a\u0011\u0002+%t\u0017\u000e^5bY&TXMQ1tKN+7o]5p]R\u0019q*!\u0001\t\u000f\u0005\r\u0011\u00021\u0001\u0002\u0006\u0005\u00111o\u0019\t\u0005\u0003\u000f\tI!D\u0001+\u0013\r\tYA\u000b\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0012g\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u0014XCAA\t!\u0019\t\u0019\"!\u0007\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0004\u0003/i\u0016AB1u_6L7-\u0003\u0003\u0002\u001c\u0005U!aD!u_6L7MU3gKJ,gnY3\u0011\u0007q\u000by\"C\u0002\u0002\"u\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003I\u00198\r[3ek2,G-\u0012=fGV$xN\u001d\u0011\u0002#Y\fG.\u001b3bi\u0016\u001cVm]:j_:LE\rF\u0004P\u0003S\ti#a\u0012\t\r\u0005-B\u00021\u0001f\u0003\rYW-\u001f\u0005\b\u0003_a\u0001\u0019AA\u0019\u0003-\u0019Xm]:j_:,V+\u0013#\u0011\t\u0005M\u0012\u0011\t\b\u0005\u0003k\ti\u0004E\u0002\u00028Qj!!!\u000f\u000b\u0007\u0005m\u0002'\u0001\u0004=e>|GOP\u0005\u0004\u0003\u007f!\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002D\u0005\u0015#AB*ue&twMC\u0002\u0002@QBq!!\u0013\r\u0001\u0004\t\t$A\u000eqe\u00164\u0018n\\;tYf|%m]3sm\u0016$7+Z:tS>t\u0017\nZ\u0001\u001bO\u0016$xJ]\"sK\u0006$X-S:pY\u0006$X\rZ*fgNLwN\u001c\u000b\u0006Q\u0006=\u0013\u0011\u000b\u0005\u0007\u0003Wi\u0001\u0019A3\t\u000f\u0005MS\u00021\u0001\u0002V\u0005a\u0002O]3wS>,8\u000f\\=PEN,'O^3e'\u0016\u001c8o]5p]&#\u0007\u0003B\u001aF\u0003c\t!cZ3u\u0013N|G.\u0019;fIN+7o]5p]R)\u0001.a\u0017\u0002^!1\u00111\u0006\bA\u0002\u0015Dq!a\u0015\u000f\u0001\u0004\t)&A\u000ehKRL5o\u001c7bi\u0016$7+Z:tS>t\u0017J\u001a)sKN,g\u000e\u001e\u000b\u0005\u0003G\n)\u0007E\u00024\u000b\"Da!a\u000b\u0010\u0001\u0004)\u0017\u0001D2m_:,7+Z:tS>tGc\u00025\u0002l\u0005=\u00141\u000f\u0005\u0007\u0003[\u0002\u0002\u0019A3\u0002\u0013M|WO]2f\u0017\u0016L\bbBA9!\u0001\u0007\u0011\u0011G\u0001\r]\u0016<8+Z:tS>t\u0017\n\u001a\u0005\b\u0003\u0013\u0002\u0002\u0019AA+\u0003i1\u0018\r\\5eCR,7\t\\8oKR\u000b'oZ3u'\u0016\u001c8/[8o)\ry\u0015\u0011\u0010\u0005\u0007\u0003w\n\u0002\u0019A3\u0002\r9,woS3z\u0003)9W\r^*fgNLwN\u001c\u000b\u0006Q\u0006\u0005\u00151\u0011\u0005\u0007\u0003W\u0011\u0002\u0019A3\t\u000f\u0005\u0015%\u00031\u0001\u0002\b\u00069A-\u001a4bk2$\b\u0003B\u001aF\u0003\u0013\u0003BaMAFQ&\u0019\u0011Q\u0012\u001b\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014a\u0005:f[>4XmU3tg&|g\u000eS8mI\u0016\u0014HCBA2\u0003'\u000b)\n\u0003\u0004\u0002,M\u0001\r!\u001a\u0005\n\u0003/\u001b\u0002\u0013!a\u0001\u00033\u000ba\"\u00197m_^\u0014VmY8o]\u0016\u001cG\u000fE\u00024\u00037K1!!(5\u0005\u001d\u0011un\u001c7fC:\fQD]3n_Z,7+Z:tS>t\u0007j\u001c7eKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003GSC!!'\u0002&.\u0012\u0011q\u0015\t\u0005\u0003S\u000b\u0019,\u0004\u0002\u0002,*!\u0011QVAX\u0003%)hn\u00195fG.,GMC\u0002\u00022R\n!\"\u00198o_R\fG/[8o\u0013\u0011\t),a+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000btQV$Hm\\<o'\u0016\u001c8/[8o\u0011>dG-\u001a:\u0015\u000b=\u000bY,a0\t\r\u0005uV\u00031\u0001i\u00035\u0019Xm]:j_:Du\u000e\u001c3fe\"I\u0011qS\u000b\u0011\u0002\u0003\u0007\u0011\u0011T\u0001 g\",H\u000fZ8x]N+7o]5p]\"{G\u000eZ3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D2m_N,7+Z:tS>tG#B(\u0002H\u0006%\u0007BBA\u0016/\u0001\u0007Q\rC\u0005\u0002\u0018^\u0001\n\u00111\u0001\u0002\u001a\u000612\r\\8tKN+7o]5p]\u0012\"WMZ1vYR$#'\u0001\u0005tQV$Hm\\<o)\u0005y\u0015A\u00057jgR\f5\r^5wKN+7o]5p]N,\"!!6\u0011\u000b\u0005]\u0017\u0011\u001d>\u000f\t\u0005e\u0017Q\u001c\b\u0005\u0003o\tY.C\u00016\u0013\r\ty\u000eN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019/!:\u0003\u0007M+\u0017OC\u0002\u0002`R\n!\u0003\\5ti\u000ecwn]3e'\u0016\u001c8/[8og\u000612o\u00195fIVdW\rU3sS>$\u0017nY\"iK\u000e\\7/A\nqKJLw\u000eZ5d\u001b\u0006Lg\u000e^3oC:\u001cW\rF\u0002P\u0003_Dq!!=\u001e\u0001\u0004\t\u00190\u0001\reK\u001a\fW\u000f\u001c;J]\u0006\u001cG/\u001b<f)&lWm\\;u\u001bN\u00042aMA{\u0013\r\t9\u0010\u000e\u0002\u0005\u0019>tw\rF\u0003P\u0003w\fi\u0010C\u0004\u0002rz\u0001\r!a=\t\u000f\u0005}h\u00041\u0001\u0002\u001a\u0006\u0019\u0012n\u001a8pe\u0016\u001cUo\u001d;p[RKW.Z8vi\u0006\u0011b.Z<Jg>d\u0017\r^3e'\u0016\u001c8/[8o)\u00059\u0015!\u0006<bY&$\u0017\r^3TKN\u001c\u0018n\u001c8De\u0016\fG/\u001a\u000b\u0004\u001f\n%\u0001BBA\u0016A\u0001\u0007Q-A\u000bj]Z\fG.\u001b3bi\u0016\fE\u000e\\*fgNLwN\\:\u0002)A,HoU3tg&|gNR8s)\u0016\u001cH/\u001b8h)\ry%\u0011\u0003\u0005\u0007\u0003{\u0013\u0003\u0019\u00015")
public class SparkConnectSessionManager
implements Logging {
    private volatile Option<SparkSession> baseSession;
    private final ConcurrentMap<SessionKey, SessionHolder> sessionStore;
    private final Cache<SessionKey, SessionHolderInfo> closedSessionsCache;
    private final AtomicReference<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<SparkSession> baseSession() {
        return this.baseSession;
    }

    private void baseSession_$eq(Option<SparkSession> x$1) {
        this.baseSession = x$1;
    }

    private ConcurrentMap<SessionKey, SessionHolder> sessionStore() {
        return this.sessionStore;
    }

    private Cache<SessionKey, SessionHolderInfo> closedSessionsCache() {
        return this.closedSessionsCache;
    }

    public void initializeBaseSession(SparkContext sc) {
        if (this.baseSession().isEmpty()) {
            this.baseSession_$eq((Option<SparkSession>)new Some((Object)SparkSession$.MODULE$.builder().sparkContext(sc).getOrCreate().newSession()));
            return;
        }
    }

    private AtomicReference<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void validateSessionId(SessionKey key, String sessionUUID, String previouslyObservedSessionId) {
        String string = sessionUUID;
        String string2 = previouslyObservedSessionId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CHANGED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public SessionHolder getOrCreateIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.validateSessionCreate(key);
            SessionHolder holder = new SessionHolder(key.userId(), key.sessionId(), this.newIsolatedSession());
            holder.initializeSession();
            return holder;
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public SessionHolder getIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Session not found: " + key);
            if (this.closedSessionsCache().getIfPresent((Object)key) != null) {
                throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
            }
            throw new SparkSQLException("INVALID_HANDLE.SESSION_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public Option<SessionHolder> getIsolatedSessionIfPresent(SessionKey key) {
        return Option$.MODULE$.apply((Object)this.getSession(key, (Option<Function0<SessionHolder>>)None$.MODULE$));
    }

    public SessionHolder cloneSession(SessionKey sourceKey, String newSessionId, Option<String> previouslyObservedSessionId) {
        SessionHolder sourceSessionHolder = this.getIsolatedSession(sourceKey, (Option<String>)None$.MODULE$);
        previouslyObservedSessionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(sourceKey, sourceSessionHolder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        SessionKey newKey = new SessionKey(sourceKey.userId(), newSessionId);
        this.validateCloneTargetSession(newKey);
        SessionHolder clonedSessionHolder = this.getSession(newKey, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            SessionHolder session = (SessionHolder)this.sessionStore().get(newKey);
            if (session == null) {
                SparkSession clonedSparkSession = sourceSessionHolder.session().cloneSession();
                SessionHolder newHolder = new SessionHolder(newKey.userId(), newKey.sessionId(), clonedSparkSession);
                newHolder.initializeSession();
                return newHolder;
            }
            return session;
        }));
        return clonedSessionHolder;
    }

    private void validateCloneTargetSession(SessionKey newKey) {
        try {
            UUID.fromString(newKey.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_FORMAT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})));
        }
        if (this.closedSessionsCache().getIfPresent((Object)newKey) != null) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_ALREADY_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})));
        }
        if (this.sessionStore().containsKey(newKey)) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})));
        }
    }

    private SessionHolder getSession(SessionKey key, Option<Function0<SessionHolder>> option) {
        SessionHolder session;
        block4: {
            SessionHolder sessionHolder;
            this.schedulePeriodicChecks();
            Option<Function0<SessionHolder>> option2 = option;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Function0 callable = (Function0)some.value();
                sessionHolder = this.sessionStore().computeIfAbsent(key, x$1 -> (SessionHolder)callable.apply());
            } else if (None$.MODULE$.equals(option2)) {
                sessionHolder = (SessionHolder)this.sessionStore().get(key);
            } else {
                throw new MatchError(option2);
            }
            session = sessionHolder;
            if (session == null) break block4;
            session.updateAccessTime();
        }
        return session;
    }

    private Option<SessionHolder> removeSessionHolder(SessionKey key, boolean allowReconnect) {
        None$ sessionHolder = None$.MODULE$;
        sessionHolder = Option$.MODULE$.apply(this.sessionStore().get(key));
        sessionHolder.foreach((Function1 & Serializable)s -> {
            block0: {
                if (allowReconnect) break block0;
                this.closedSessionsCache().put((Object)s.key(), (Object)s.getSessionHolderInfo());
            }
            return (SessionHolder)this.sessionStore().remove(key);
        });
        return sessionHolder;
    }

    private boolean removeSessionHolder$default$2() {
        return false;
    }

    private void shutdownSessionHolder(SessionHolder sessionHolder, boolean allowReconnect) {
        sessionHolder.close();
        if (!allowReconnect) {
            this.closedSessionsCache().put((Object)sessionHolder.key(), (Object)sessionHolder.getSessionHolderInfo());
            return;
        }
    }

    public void closeSession(SessionKey key, boolean allowReconnect) {
        Option<SessionHolder> sessionHolder = this.removeSessionHolder(key, allowReconnect);
        sessionHolder.foreach((Function1 & Serializable)x$2 -> {
            this.shutdownSessionHolder(x$2, allowReconnect);
            return BoxedUnit.UNIT;
        });
    }

    public boolean closeSession$default$2() {
        return false;
    }

    public void shutdown() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAndSet(null);
        if (executor != null) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
        }
        this.sessionStore().clear();
        this.closedSessionsCache().invalidateAll();
    }

    private boolean shutdownSessionHolder$default$2() {
        return false;
    }

    public Seq<SessionHolderInfo> listActiveSessions() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.sessionStore().values()).asScala().map((Function1 & Serializable)x$3 -> x$3.getSessionHolderInfo())).toSeq();
    }

    public Seq<SessionHolderInfo> listClosedSessions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.closedSessionsCache().asMap()).asScala().values().toSeq();
    }

    private void schedulePeriodicChecks() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAcquire();
        if (executor == null) {
            executor = Executors.newSingleThreadScheduledExecutor();
            if (this.scheduledExecutor().compareAndExchangeRelease(null, executor) == null) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of expired sessions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.INTERVAL, BoxesRunTime.boxToLong((long)interval))})))));
                executor.scheduleAtFixedRate(() -> {
                    try {
                        long defaultInactiveTimeoutMs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT()));
                        this.periodicMaintenance(defaultInactiveTimeoutMs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public void periodicMaintenance(long defaultInactiveTimeoutMs) {
        this.periodicMaintenance(defaultInactiveTimeoutMs, false);
    }

    private void periodicMaintenance(long defaultInactiveTimeoutMs, boolean ignoreCustomTimeout) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectSessionManager maintenance.");
        long nowMs = System.currentTimeMillis();
        this.sessionStore().forEach((x$4, sessionHolder) -> {
            SessionHolderInfo info = sessionHolder.getSessionHolderInfo();
            if (SparkConnectSessionManager.shouldExpire$1(info, nowMs, ignoreCustomTimeout, defaultInactiveTimeoutMs)) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found session ", " that expired "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SESSION_HOLD_INFO, info)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and will be closed."}))).log((Seq)Nil$.MODULE$))));
                this.removeSessionHolder(info.key(), this.removeSessionHolder$default$2());
                try {
                    this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception closing session", throwable2);
                    }
                    throw throwable;
                }
                return;
            }
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectSessionManager maintenance.");
    }

    private SparkSession newIsolatedSession() {
        SparkSession session = (SparkSession)this.baseSession().get();
        if (session.sparkContext().isStopped()) {
            Predef$.MODULE$.assert(SparkSession$.MODULE$.getDefaultSession().nonEmpty());
            return ((SparkSession)SparkSession$.MODULE$.getDefaultSession().get()).newSession();
        }
        return session.newSession();
    }

    private void validateSessionCreate(SessionKey key) {
        try {
            UUID.fromString(key.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
        if (this.closedSessionsCache().getIfPresent((Object)key) != null) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public void invalidateAllSessions() {
        this.sessionStore().forEach((key, sessionHolder) -> {
            this.removeSessionHolder((SessionKey)key, this.removeSessionHolder$default$2());
            this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
        });
        this.closedSessionsCache().invalidateAll();
    }

    public void putSessionForTesting(SessionHolder sessionHolder) {
        this.sessionStore().put(sessionHolder.key(), sessionHolder);
    }

    private static final boolean shouldExpire$1(SessionHolderInfo info, long nowMs, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1) {
        long timeoutMs = info.customInactiveTimeoutMs().isDefined() && !ignoreCustomTimeout$1 ? BoxesRunTime.unboxToLong((Object)info.customInactiveTimeoutMs().get()) : defaultInactiveTimeoutMs$1;
        return timeoutMs != -1L && info.lastAccessTimeMs() + timeoutMs <= nowMs;
    }

    public SparkConnectSessionManager() {
        Logging.$init$((Logging)this);
        this.baseSession = None$.MODULE$;
        this.sessionStore = new ConcurrentHashMap<SessionKey, SessionHolder>();
        this.closedSessionsCache = CacheBuilder.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE()))).build();
        this.scheduledExecutor = new AtomicReference();
    }
}

