/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.AuthenticationPolicyExecutionResult;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.BaseSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class RegisteredServiceAuthenticationPolicySingleSignOnParticipationStrategy
extends BaseSingleSignOnParticipationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceAuthenticationPolicySingleSignOnParticipationStrategy.class);
    private final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;
    private final ConfigurableApplicationContext applicationContext;

    public RegisteredServiceAuthenticationPolicySingleSignOnParticipationStrategy(ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan serviceSelectionStrategy, AuthenticationEventExecutionPlan executionPlan, ConfigurableApplicationContext applicationContext) {
        super(servicesManager, ticketRegistrySupport, serviceSelectionStrategy);
        this.authenticationEventExecutionPlan = executionPlan;
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParticipating(SingleSignOnParticipationRequest ssoRequest) {
        RegisteredService registeredService = this.getRegisteredService(ssoRequest);
        if (registeredService == null) {
            return true;
        }
        RegisteredServiceAuthenticationPolicy authenticationPolicy = registeredService.getAuthenticationPolicy();
        if (authenticationPolicy == null) {
            return true;
        }
        Optional<String> ticketGrantingTicketId = RegisteredServiceAuthenticationPolicySingleSignOnParticipationStrategy.getTicketGrantingTicketId(ssoRequest);
        if (ticketGrantingTicketId.isEmpty()) {
            return true;
        }
        Authentication ca = AuthenticationCredentialsThreadLocalBinder.getCurrentAuthentication();
        try {
            Authentication authentication = this.getTicketState(ssoRequest).map(AuthenticationAwareTicket.class::cast).map(AuthenticationAwareTicket::getAuthentication).orElseThrow();
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
            if (authentication != null) {
                Set successfulHandlerNames = CollectionUtils.toCollection(authentication.getAttributes().get("successfulAuthenticationHandlers"));
                Set assertedHandlers = this.authenticationEventExecutionPlan.getAuthenticationHandlers().stream().filter(handler -> successfulHandlerNames.contains(handler.getName())).collect(Collectors.toSet());
                LOGGER.debug("Asserted authentication handlers are [{}]", assertedHandlers);
                RegisteredServiceAuthenticationPolicyCriteria criteria = authenticationPolicy.getCriteria();
                boolean bl = Optional.ofNullable(criteria).map(Unchecked.function(c -> {
                    AuthenticationPolicy policy = criteria.toAuthenticationPolicy(registeredService);
                    AuthenticationPolicyExecutionResult result = policy.isSatisfiedBy(authentication, assertedHandlers, this.applicationContext, Optional.empty());
                    return result.isSuccess();
                })).orElse(true);
                return bl;
            }
        }
        finally {
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)ca);
        }
        return true;
    }

    public boolean supports(SingleSignOnParticipationRequest ssoRequest) {
        RegisteredService registeredService = this.getRegisteredService(ssoRequest);
        if (registeredService == null) {
            return false;
        }
        RegisteredServiceAuthenticationPolicy authenticationPolicy = registeredService.getAuthenticationPolicy();
        LOGGER.debug("Evaluating authentication policy [{}] for [{}]", (Object)authenticationPolicy, (Object)registeredService.getName());
        return authenticationPolicy != null && authenticationPolicy.getCriteria() != null;
    }

    public int getOrder() {
        return 0;
    }
}

