/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.scriptedsql;

import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class ScriptedSQLFilterTranslator
extends AbstractFilterTranslator<Map<String, Object>> {
    private Map<String, Object> createMap(String operation, AttributeFilter filter, boolean not) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String name = filter.getAttribute().getName();
        String value = AttributeUtil.getAsStringValue((Attribute)filter.getAttribute());
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        map.put("not", not);
        map.put("operation", operation);
        map.put("left", name);
        map.put("right", value);
        return map;
    }

    protected Map<String, Object> createContainsExpression(ContainsFilter filter, boolean not) {
        return this.createMap("CONTAINS", (AttributeFilter)filter, not);
    }

    protected Map<String, Object> createEndsWithExpression(EndsWithFilter filter, boolean not) {
        return this.createMap("ENDSWITH", (AttributeFilter)filter, not);
    }

    protected Map<String, Object> createStartsWithExpression(StartsWithFilter filter, boolean not) {
        return this.createMap("STARTSWITH", (AttributeFilter)filter, not);
    }

    protected Map<String, Object> createEqualsExpression(EqualsFilter filter, boolean not) {
        return this.createMap("EQUALS", (AttributeFilter)filter, not);
    }

    protected Map<String, Object> createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
        return this.createMap("EQUALSIGNORECASE", (AttributeFilter)filter, not);
    }

    protected Map<String, Object> createAndExpression(Map<String, Object> leftExpression, Map<String, Object> rightExpression) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("operation", "AND");
        map.put("left", leftExpression);
        map.put("right", rightExpression);
        return map;
    }

    protected Map<String, Object> createOrExpression(Map<String, Object> leftExpression, Map<String, Object> rightExpression) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("operation", "OR");
        map.put("left", leftExpression);
        map.put("right", rightExpression);
        return map;
    }

    protected Map<String, Object> createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        return this.createMap("GREATERTHAN", (AttributeFilter)filter, not);
    }

    protected Map<String, Object> createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        return this.createMap("GREATERTHANOREQUAL", (AttributeFilter)filter, not);
    }

    protected Map<String, Object> createLessThanExpression(LessThanFilter filter, boolean not) {
        return this.createMap("LESSTHAN", (AttributeFilter)filter, not);
    }

    protected Map<String, Object> createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        return this.createMap("LESSTHANOREQUAL", (AttributeFilter)filter, not);
    }
}

