/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.identifier;

import java.io.Serializable;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.lib.identifier.Identifier;
import org.apache.openjpa.lib.identifier.IdentifierImpl;
import org.apache.openjpa.lib.util.StringUtil;

public class DBIdentifier
extends IdentifierImpl
implements Cloneable,
Identifier,
Serializable {
    private static final long serialVersionUID = 1L;
    private static boolean[] _compoundIdentifier = new boolean[DBIdentifierType.values().length];
    private DBIdentifierType _type = DBIdentifierType.DEFAULT;
    public static final DBIdentifier NULL;
    public boolean _ignoreCase = false;

    protected DBIdentifier() {
    }

    public boolean getIgnoreCase() {
        return this._ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this._ignoreCase = ignoreCase;
    }

    private DBIdentifier(DBIdentifierType type) {
        this.setType(type);
    }

    protected DBIdentifier(String name, DBIdentifierType type) {
        this.setType(type);
        this.setName(name);
    }

    protected DBIdentifier(String name, DBIdentifierType type, boolean delimit) {
        this.setType(type);
        this.setName(name, delimit);
    }

    protected DBIdentifier(String name, boolean delimit) {
        this.setName(name, delimit);
    }

    public void setName(String name) {
        this.setName(name, false);
    }

    public void setName(DBIdentifier name) {
        this.assertNotNull();
        if (DBIdentifier.isNull(name)) {
            this.setNameInternal(null);
            this.setType(name.getType());
            return;
        }
        this.setNameInternal(name.getNameInternal());
        this.setType(name.getType());
    }

    public void setName(String name, boolean delimit) {
        this.assertNotNull();
        if (DBIdentifierType.CONSTANT != this.getType() && DBIdentifierType.COLUMN_DEFINITION != this.getType()) {
            if (delimit) {
                name = Normalizer.delimit(name, true);
                this.setNameDelimited(true);
            } else {
                name = Normalizer.normalizeString(name);
            }
        }
        super.setName(name);
    }

    protected void setType(DBIdentifierType type) {
        this._type = type;
    }

    public DBIdentifierType getType() {
        return this._type;
    }

    public static DBIdentifier[] split(String name, DBIdentifierType id, String delim) {
        if (!Normalizer.canSplit(name, delim)) {
            return new DBIdentifier[]{new DBIdentifier(name, id)};
        }
        String[] names = Normalizer.splitName(name, delim);
        if (names.length == 0) {
            return new DBIdentifier[0];
        }
        DBIdentifier[] sNames = new DBIdentifier[names.length];
        for (int i = 0; i < names.length; ++i) {
            sNames[i] = new DBIdentifier(names[i], id);
        }
        return sNames;
    }

    public static String join(DBIdentifier ... names) {
        if (names == null || names.length == 0) {
            return null;
        }
        String[] strNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            strNames[i] = names[i].getNameInternal();
        }
        return Normalizer.joinNames(strNames);
    }

    public static DBIdentifier[] split(DBIdentifierType resultType, String name) {
        String[] names = Normalizer.splitName(name);
        switch (names.length) {
            case 2: {
                return DBIdentifier.getTwoPartIdentifier(names, resultType);
            }
            case 3: {
                return DBIdentifier.getThreePartIdentifier(names, resultType);
            }
            case 4: {
                return DBIdentifier.getFourPartIdentifier(names, resultType);
            }
        }
        return new DBIdentifier[]{new DBIdentifier(name, resultType)};
    }

    private static DBIdentifier[] getTwoPartIdentifier(String[] names, DBIdentifierType baseId) {
        DBIdentifier[] sNames = new DBIdentifier[2];
        DBIdentifierType id0 = DBIdentifierType.DEFAULT;
        DBIdentifierType id1 = baseId;
        if (baseId != DBIdentifierType.COLUMN && baseId != DBIdentifierType.SCHEMA) {
            id0 = DBIdentifierType.SCHEMA;
        } else if (baseId == DBIdentifierType.COLUMN) {
            id0 = DBIdentifierType.TABLE;
        } else if (baseId == DBIdentifierType.SCHEMA) {
            id0 = DBIdentifierType.DATABASE;
        }
        sNames[0] = new DBIdentifier(names[0], id0);
        sNames[1] = new DBIdentifier(names[1], id1);
        return sNames;
    }

    private static DBIdentifier[] getThreePartIdentifier(String[] names, DBIdentifierType baseId) {
        DBIdentifier[] sNames = new DBIdentifier[3];
        DBIdentifierType id0 = DBIdentifierType.DEFAULT;
        DBIdentifierType id1 = DBIdentifierType.DEFAULT;
        DBIdentifierType id2 = baseId;
        if (baseId != DBIdentifierType.SCHEMA && baseId != DBIdentifierType.COLUMN) {
            id0 = DBIdentifierType.DATABASE;
            id1 = DBIdentifierType.SCHEMA;
        } else if (baseId == DBIdentifierType.COLUMN) {
            id0 = DBIdentifierType.SCHEMA;
            id1 = DBIdentifierType.TABLE;
        }
        sNames[0] = new DBIdentifier(names[0], id0);
        sNames[1] = new DBIdentifier(names[1], id1);
        sNames[2] = new DBIdentifier(names[2], id2);
        return sNames;
    }

    private static DBIdentifier[] getFourPartIdentifier(String[] names, DBIdentifierType baseId) {
        DBIdentifier[] sNames = new DBIdentifier[4];
        DBIdentifierType id0 = DBIdentifierType.DEFAULT;
        DBIdentifierType id1 = DBIdentifierType.DEFAULT;
        DBIdentifierType id2 = DBIdentifierType.DEFAULT;
        DBIdentifierType id3 = baseId;
        if (baseId == DBIdentifierType.COLUMN) {
            id0 = DBIdentifierType.DATABASE;
            id1 = DBIdentifierType.SCHEMA;
            id2 = DBIdentifierType.TABLE;
        }
        sNames[0] = new DBIdentifier(names[0], id0);
        sNames[1] = new DBIdentifier(names[1], id1);
        sNames[2] = new DBIdentifier(names[2], id2);
        sNames[3] = new DBIdentifier(names[3], id3);
        return sNames;
    }

    public static boolean isEmpty(DBIdentifier name) {
        if (DBIdentifier.isNull(name)) {
            return true;
        }
        return StringUtil.isEmpty((String)name.getName());
    }

    public static boolean isNull(DBIdentifier name) {
        return name == null || name.getType() == DBIdentifierType.NULL;
    }

    public DBIdentifier clone() {
        DBIdentifier sName = new DBIdentifier();
        sName.setNameInternal(this.getNameInternal());
        sName.setType(this.getType());
        sName.setIgnoreCase(this.getIgnoreCase());
        sName.setNameDelimited(this.isNameDelimited());
        return sName;
    }

    private void setNameInternal(String name) {
        super.setName(name);
    }

    private String getNameInternal() {
        return super.getName();
    }

    public static DBIdentifier trimToNull(DBIdentifier name) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        DBIdentifier sName = name.clone();
        sName.setNameInternal(StringUtil.trimToNull((String)sName.getNameInternal()));
        return sName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof DBIdentifier) {
            DBIdentifier sName = (DBIdentifier)obj;
            return this.equals(sName, this.getIgnoreCase() || sName.getIgnoreCase());
        }
        if (obj instanceof String) {
            return obj.equals(this.getNameInternal());
        }
        throw new IllegalArgumentException("Unsupported type comparison: " + obj.getClass().getName());
    }

    public boolean isNull() {
        return this._type == DBIdentifierType.NULL || this.getName() == null;
    }

    public int compareTo(Identifier o) {
        if (o instanceof DBIdentifier) {
            if (this == NULL && (o == null || o == NULL)) {
                return 0;
            }
            if (this == NULL) {
                return 1;
            }
            if (o == null || o == NULL) {
                return -1;
            }
        }
        return super.compareTo(o);
    }

    public static DBIdentifier[] toArray(String[] columnNames, DBIdentifierType id) {
        return DBIdentifier.toArray(columnNames, id, false);
    }

    public static DBIdentifier[] toArray(String[] names, DBIdentifierType id, boolean delimit) {
        if (names == null) {
            return null;
        }
        DBIdentifier[] sNames = new DBIdentifier[names.length];
        for (int i = 0; i < names.length; ++i) {
            sNames[i] = new DBIdentifier(names[i].trim(), id, delimit);
        }
        return sNames;
    }

    public static String[] toStringArray(DBIdentifier[] sNames) {
        if (sNames == null) {
            return null;
        }
        String[] names = new String[sNames.length];
        for (int i = 0; i < sNames.length; ++i) {
            names[i] = sNames[i].getName();
        }
        return names;
    }

    public static DBIdentifier newCatalog(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.CATALOG);
    }

    public static DBIdentifier newCatalog(String name, boolean delimit) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.CATALOG, false, delimit);
    }

    public static DBIdentifier newTable(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.TABLE);
    }

    public static DBIdentifier newTable(String name, boolean delimit) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.TABLE, false, delimit);
    }

    public static DBIdentifier newColumn(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.COLUMN);
    }

    public static DBIdentifier newColumn(String name, boolean delimit) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.COLUMN, false, delimit);
    }

    public static DBIdentifier newSchema(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.SCHEMA);
    }

    public static DBIdentifier newSchema(String name, boolean delimit) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.SCHEMA, false, delimit);
    }

    public static DBIdentifier newIndex(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.INDEX);
    }

    public static DBIdentifier newIndex(String name, boolean delimit) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.INDEX, false, delimit);
    }

    public static DBIdentifier newSequence(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.SEQUENCE);
    }

    public static DBIdentifier newSequence(String name, boolean delimit) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.SEQUENCE, false, delimit);
    }

    public static DBIdentifier newForeignKey(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.FOREIGN_KEY);
    }

    public static DBIdentifier newForeignKey(String name, boolean delimit) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.FOREIGN_KEY, false, delimit);
    }

    public static DBIdentifier newConstraint(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.CONSTRAINT);
    }

    public static DBIdentifier newConstraint(String name, boolean delimit) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.CONSTRAINT, false, delimit);
    }

    public static DBIdentifier newConstant(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.CONSTANT);
    }

    public static DBIdentifier newColumnDefinition(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.COLUMN_DEFINITION);
    }

    public static DBIdentifier newDefault(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.DEFAULT);
    }

    protected static DBIdentifier newIdentifier(String name, DBIdentifierType id) {
        return DBIdentifier.newIdentifier(name, id, false, false);
    }

    public static DBIdentifier newIdentifier(String name, DBIdentifierType id, boolean toUpper) {
        return DBIdentifier.newIdentifier(name, id, toUpper, false);
    }

    protected static DBIdentifier newIdentifier(String name, DBIdentifierType id, boolean toUpper, boolean delimit) {
        return DBIdentifier.newIdentifier(name, id, toUpper, delimit, false);
    }

    public static DBIdentifier newProcedure(String name) {
        return DBIdentifier.newIdentifier(name, DBIdentifierType.PROCEDURE);
    }

    protected static DBIdentifier newIdentifier(String name, DBIdentifierType id, boolean toUpper, boolean delimit, boolean ignoreCase) {
        if (name == null) {
            return NULL;
        }
        DBIdentifier dbId = NULL;
        if (!_compoundIdentifier[id.ordinal()] || delimit) {
            dbId = new DBIdentifier(name, id, delimit);
            dbId.setIgnoreCase(ignoreCase);
            if (toUpper) {
                return DBIdentifier.toUpper(dbId);
            }
        } else {
            DBIdentifier[] sNames = DBIdentifier.split(id, name);
            dbId = new QualifiedDBIdentifier(sNames);
            dbId.setIgnoreCase(ignoreCase);
        }
        return dbId;
    }

    public static boolean equal(DBIdentifier name1, DBIdentifier name2) {
        boolean name1Null = DBIdentifier.isNull(name1);
        if (name1Null && DBIdentifier.isNull(name2)) {
            return true;
        }
        if (name1Null) {
            return false;
        }
        return name1.equals(name2, false);
    }

    private void assertNotNull() {
        if (this == NULL || this.getType() == DBIdentifierType.NULL) {
            throw new IllegalStateException("Cannot modify NULL instance");
        }
    }

    public static DBIdentifier truncate(DBIdentifier name, int length) {
        DBIdentifier sName = name.clone();
        String strName = sName.getNameInternal();
        if (StringUtil.isEmpty((String)strName)) {
            return sName;
        }
        strName = Normalizer.truncate(strName, length);
        sName.setNameInternal(strName);
        return sName;
    }

    public static DBIdentifier append(DBIdentifier name, String str) {
        DBIdentifier sName = name.clone();
        String strName = sName.getNameInternal();
        strName = Normalizer.append(strName, str);
        sName.setNameInternal(strName);
        return sName;
    }

    public static DBIdentifier combine(DBIdentifier name, String str) {
        DBIdentifier sName = name.clone();
        String strName = sName.getNameInternal();
        strName = Normalizer.combine(strName, str);
        sName.setNameInternal(strName);
        return sName;
    }

    public static DBIdentifier toLower(DBIdentifier name) {
        return DBIdentifier.toLower(name, false);
    }

    public static DBIdentifier toLower(DBIdentifier name, boolean force) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        DBIdentifier sName = name.clone();
        if (sName.getNameInternal() == null) {
            return sName;
        }
        if (force || !Normalizer.isDelimited(sName.getNameInternal())) {
            sName.setNameInternal(sName.getNameInternal().toLowerCase());
        }
        return sName;
    }

    public static DBIdentifier toUpper(DBIdentifier name) {
        return DBIdentifier.toUpper(name, false);
    }

    public static DBIdentifier toUpper(DBIdentifier name, boolean force) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        if (name.getNameInternal() == null) {
            return name;
        }
        if (force || !Normalizer.isDelimited(name.getNameInternal())) {
            DBIdentifier sName = name.clone();
            sName.setNameInternal(sName.getNameInternal().toUpperCase());
            return sName;
        }
        return name;
    }

    public static DBIdentifier removeLeading(DBIdentifier name, String leadingStr) {
        DBIdentifier sName = name.clone();
        if (DBIdentifier.isEmpty(sName)) {
            return sName;
        }
        String strName = sName.getNameInternal();
        int leadingLen = leadingStr.length();
        while (strName.startsWith(leadingStr)) {
            strName = strName.substring(leadingLen);
        }
        sName.setNameInternal(strName);
        return sName;
    }

    public static DBIdentifier removeHungarianNotation(DBIdentifier name) {
        DBIdentifier hName = name.clone();
        if (DBIdentifier.isEmpty(hName)) {
            return hName;
        }
        String strName = hName.getNameInternal();
        strName = Normalizer.removeHungarianNotation(strName);
        hName.setNameInternal(strName);
        return hName;
    }

    public boolean equalsIgnoreCase(DBIdentifier name) {
        return this.equals(name, true);
    }

    public static boolean equalsIgnoreCase(DBIdentifier name1, DBIdentifier name2) {
        boolean name1Null = DBIdentifier.isNull(name1);
        if (name1Null && DBIdentifier.isNull(name2)) {
            return true;
        }
        if (name1Null) {
            return false;
        }
        return name1.equals(name2, true);
    }

    private boolean equals(DBIdentifier sName, boolean ignoreCase) {
        if (sName.getNameInternal() == null && this.getNameInternal() == null) {
            return true;
        }
        if (this.getNameInternal() == null) {
            return false;
        }
        if (this.getIgnoreCase() || sName.getIgnoreCase() || ignoreCase || !Normalizer.isDelimited(this.getNameInternal())) {
            return this.getNameInternal().equalsIgnoreCase(sName.getNameInternal());
        }
        return this.getNameInternal().equals(sName.getNameInternal());
    }

    public static DBIdentifier preCombine(DBIdentifier name, String prefix) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        DBIdentifier sName = name.clone();
        String strName = sName.getNameInternal();
        strName = Normalizer.combine(prefix, strName);
        sName.setNameInternal(strName);
        return sName;
    }

    public static DBIdentifier removeDelimiters(DBIdentifier name) {
        if (DBIdentifier.isNull(name) || !name.isDelimited()) {
            return name;
        }
        if (!name.isDelimited()) {
            return name;
        }
        String strName = Normalizer.removeDelimiters(name.getNameInternal());
        DBIdentifier sName = name.clone();
        sName.setNameInternal(strName);
        return sName;
    }

    public static DBIdentifier removeDelimitersAndMakeUpper(DBIdentifier name) {
        if (DBIdentifier.isNull(name) || name.getNameInternal() == null) {
            return name;
        }
        if (!name.isDelimited()) {
            return DBIdentifier.toUpper(name, true);
        }
        String strName = Normalizer.removeDelimiters(name.getNameInternal());
        DBIdentifier sName = name.clone();
        sName.setNameInternal(strName.toUpperCase());
        return sName;
    }

    public static DBIdentifier trim(DBIdentifier name) {
        if (DBIdentifier.isNull(name)) {
            return name;
        }
        DBIdentifier sName = name.clone();
        if (DBIdentifier.isEmpty(sName)) {
            return sName;
        }
        String strName = sName.getNameInternal();
        strName = strName.trim();
        sName.setNameInternal(strName);
        return sName;
    }

    public int length() {
        if (DBIdentifier.isNull(this)) {
            return 0;
        }
        return super.length();
    }

    public boolean isDelimited() {
        if (DBIdentifier.isEmpty(this)) {
            return false;
        }
        return this.isNameDelimited() || Normalizer.isDelimited(this.getNameInternal());
    }

    public static DBIdentifier combine(DBIdentifierType id, String ... names) {
        return DBIdentifier.newIdentifier(Normalizer.combine(names), id);
    }

    public DBIdentifier getUnqualifiedName() {
        return this;
    }

    static {
        DBIdentifier._compoundIdentifier[DBIdentifierType.TABLE.ordinal()] = true;
        DBIdentifier._compoundIdentifier[DBIdentifierType.COLUMN.ordinal()] = true;
        DBIdentifier._compoundIdentifier[DBIdentifierType.SEQUENCE.ordinal()] = true;
        DBIdentifier._compoundIdentifier[DBIdentifierType.CONSTRAINT.ordinal()] = true;
        DBIdentifier._compoundIdentifier[DBIdentifierType.INDEX.ordinal()] = true;
        NULL = new DBIdentifier(DBIdentifierType.NULL);
    }

    public static enum DBIdentifierType {
        DEFAULT,
        TABLE,
        SCHEMA,
        CATALOG,
        DATABASE,
        COLUMN,
        COLUMN_DEFINITION,
        SEQUENCE,
        CONSTRAINT,
        INDEX,
        FOREIGN_KEY,
        CONSTANT,
        PROCEDURE,
        NULL;

    }
}

