/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.springmodules.cache.CacheModel;
import org.springmodules.cache.util.TextMatcher;

public final class NameMatchCacheModelSource {
    private Map models;

    public void setModels(Map m) {
        this.models = m;
    }

    public CacheModel model(Method m) {
        String key = m.getName();
        CacheModel model = this.model(key);
        if (model != null) {
            return model;
        }
        return this.mostSpecificModel(key);
    }

    private CacheModel mostSpecificModel(String method) {
        CacheModel model = null;
        String bestMatch = null;
        Iterator i = this.models.keySet().iterator();
        while (i.hasNext()) {
            String mapped = (String)i.next();
            if (!this.mostSpecificMethodFound(method, bestMatch, mapped)) continue;
            model = this.model(mapped);
            bestMatch = mapped;
        }
        return model;
    }

    private boolean mostSpecificMethodFound(String method, String bestMatch, String mapped) {
        return TextMatcher.isMatch(method, mapped) && (bestMatch == null || bestMatch.length() <= mapped.length());
    }

    private CacheModel model(String key) {
        return (CacheModel)this.models.get(key);
    }
}

