/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20AccessTokenAtHashGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.AuthenticatedServicesAwareTicketGrantingTicket;
import org.apereo.cas.ticket.BaseIdTokenGeneratorService;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.Assert;

public class OidcIdTokenGeneratorService
extends BaseIdTokenGeneratorService<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenGeneratorService.class);

    public OidcIdTokenGeneratorService(ObjectProvider<OidcConfigurationContext> configurationContext) {
        super(configurationContext);
    }

    private static void setClaim(JwtClaims claims, String claimName, Object claimValue) {
        if (claimValue != null && StringUtils.isNotBlank((CharSequence)claimValue.toString())) {
            claims.setClaim(claimName, claimValue);
        }
    }

    public String generate(OAuth20AccessToken accessToken, UserProfile userProfile, OAuth20ResponseTypes responseType, OAuth20GrantTypes grantType, OAuthRegisteredService registeredService) throws Exception {
        Long timeout = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenExpirationPolicy().buildTicketExpirationPolicy().getTimeToLive();
        Assert.isAssignable(OidcRegisteredService.class, registeredService.getClass(), (String)"Registered service instance is not an OIDC service");
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
        LOGGER.trace("Attempting to produce claims for the id token [{}]", (Object)accessToken);
        JwtClaims claims = this.buildJwtClaims(accessToken, timeout, oidcRegisteredService, responseType, grantType);
        return this.encodeAndFinalizeToken(claims, (OAuthRegisteredService)oidcRegisteredService, accessToken);
    }

    protected JwtClaims buildJwtClaims(OAuth20AccessToken accessToken, long timeoutInSeconds, OidcRegisteredService registeredService, OAuth20ResponseTypes responseType, OAuth20GrantTypes grantType) {
        boolean includeClaims;
        Authentication authentication = accessToken.getAuthentication();
        Principal principal = ((OidcConfigurationContext)this.getConfigurationContext()).getProfileScopeToAttributesFilter().filter(accessToken.getService(), authentication.getPrincipal(), (RegisteredService)registeredService, accessToken);
        LOGGER.debug("Principal to use to build the ID token is [{}]", (Object)principal);
        OidcProperties oidc = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc();
        JwtClaims claims = new JwtClaims();
        TicketGrantingTicket tgt = accessToken.getTicketGrantingTicket();
        String jwtId = this.getJwtId(tgt);
        LOGGER.debug("Calculated ID token jti claim to be [{}]", (Object)jwtId);
        claims.setJwtId(jwtId);
        claims.setClaim("sid", (Object)DigestUtils.sha((String)jwtId));
        claims.setIssuer(((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().determineIssuer(Optional.ofNullable(registeredService)));
        claims.setAudience(accessToken.getClientId());
        NumericDate expirationDate = NumericDate.now();
        expirationDate.addSeconds(timeoutInSeconds);
        claims.setExpirationTime(expirationDate);
        LOGGER.debug("Calculated ID token expiration claim to be [{}]", (Object)expirationDate);
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast((float)Beans.newDuration((String)oidc.getCore().getSkew()).toMinutes());
        String subject = registeredService.getUsernameAttributeProvider().resolveUsername(principal, accessToken.getService(), (RegisteredService)registeredService);
        LOGGER.debug("Calculated ID token subject claim to be [{}]", (Object)subject);
        claims.setSubject(principal.getId());
        MultifactorAuthenticationProperties mfa = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getMfa();
        Map attributes = authentication.getAttributes();
        if (attributes.containsKey(mfa.getCore().getAuthenticationContextAttribute())) {
            Set acrValues = CollectionUtils.toCollection(attributes.get(mfa.getCore().getAuthenticationContextAttribute()));
            List authnContexts = oidc.getCore().getAuthenticationContextReferenceMappings();
            Map mappings = CollectionUtils.convertDirectedListToMap((Collection)authnContexts);
            String acrMapped = acrValues.stream().map(acrValue -> mappings.entrySet().stream().filter(entry -> ((String)entry.getValue()).equalsIgnoreCase(acrValue.toString())).map(Map.Entry::getKey).findFirst().orElseGet(acrValue::toString)).collect(Collectors.joining(" "));
            LOGGER.debug("ID token acr claim calculated as [{}]", (Object)acrMapped);
            claims.setStringClaim("acr", acrMapped);
        }
        if (attributes.containsKey("successfulAuthenticationHandlers")) {
            Set val = CollectionUtils.toCollection(attributes.get("successfulAuthenticationHandlers"));
            LOGGER.debug("ID token amr claim calculated as [{}]", (Object)val);
            claims.setStringListClaim("amr", val.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        claims.setStringClaim("client_id", registeredService.getClientId());
        claims.setClaim("auth_time", (Object)tgt.getAuthentication().getAuthenticationDate().toEpochSecond());
        if (attributes.containsKey("state")) {
            OidcIdTokenGeneratorService.setClaim(claims, "state", ((List)attributes.get("state")).get(0));
        }
        if (attributes.containsKey("nonce")) {
            OidcIdTokenGeneratorService.setClaim(claims, "nonce", ((List)attributes.get("nonce")).get(0));
        }
        this.generateAccessTokenHash(accessToken, registeredService, claims);
        boolean bl = includeClaims = responseType != OAuth20ResponseTypes.CODE && grantType != OAuth20GrantTypes.AUTHORIZATION_CODE;
        if (includeClaims || oidc.getIdToken().isIncludeIdTokenClaims()) {
            FunctionUtils.doIf((boolean)oidc.getIdToken().isIncludeIdTokenClaims(), ignore -> LOGGER.warn("Individual claims requested by OpenID scopes are forced to be included in the ID token. This is a violation of the OpenID Connect specification and a workaround via dedicated CAS configuration. Claims should be requested from the userinfo/profile endpoints in exchange for an access token.")).accept(claims);
            this.collectIdTokenClaims(principal, (RegisteredService)registeredService, claims);
        } else {
            LOGGER.debug("Per OpenID Connect specification, individual claims requested by OpenID scopes such as profile, email, address, etc. are only put into the OpenID Connect ID token when the response type is set to id_token.");
        }
        return claims;
    }

    protected void collectIdTokenClaims(Principal principal, RegisteredService registeredService, JwtClaims claims) {
        OidcProperties oidc = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc();
        LOGGER.trace("Comparing principal attributes [{}] with supported claims [{}]", (Object)principal.getAttributes(), (Object)oidc.getDiscovery().getClaims());
        principal.getAttributes().entrySet().stream().filter(entry -> {
            if (oidc.getDiscovery().getClaims().contains(entry.getKey())) {
                LOGGER.trace("Found supported claim [{}]", entry.getKey());
                return true;
            }
            LOGGER.debug("Claim [{}] is not defined as a supported claim among [{}]. Skipping...", entry.getKey(), (Object)oidc.getDiscovery().getClaims());
            return false;
        }).forEach(entry -> this.handleMappedClaimOrDefault((String)entry.getKey(), registeredService, principal, claims, entry.getValue()));
        if (!claims.hasClaim("preferred_username")) {
            this.handleMappedClaimOrDefault("preferred_username", registeredService, principal, claims, principal.getId());
        }
    }

    protected void handleMappedClaimOrDefault(String claimName, RegisteredService registeredService, Principal principal, JwtClaims claims, Object defaultValue) {
        OidcAttributeToScopeClaimMapper mapper = ((OidcConfigurationContext)this.getConfigurationContext()).getAttributeToScopeClaimMapper();
        List collectionValues = mapper.mapClaim(claimName, registeredService, principal, defaultValue);
        ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenClaimCollector().collect(claims, claimName, collectionValues);
    }

    protected String getJwtId(TicketGrantingTicket tgt) {
        String oAuthCallbackUrl = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
        LinkedHashMap streamServices = new LinkedHashMap();
        if (tgt instanceof AuthenticatedServicesAwareTicketGrantingTicket) {
            Map services = ((AuthenticatedServicesAwareTicketGrantingTicket)tgt).getServices();
            streamServices.putAll(services);
        }
        streamServices.putAll(tgt.getProxyGrantingTickets());
        Optional<Map.Entry> oAuthServiceTicket = streamServices.entrySet().stream().filter(e -> {
            RegisteredService service = ((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager().findServiceBy((Service)e.getValue());
            return service != null && service.getServiceId().equals(oAuthCallbackUrl);
        }).findFirst();
        if (oAuthServiceTicket.isEmpty()) {
            LOGGER.trace("Cannot find ticket issued to [{}] as part of the authentication context", (Object)oAuthCallbackUrl);
            return tgt.getId();
        }
        return (String)oAuthServiceTicket.get().getKey();
    }

    protected void generateAccessTokenHash(OAuth20AccessToken accessToken, OidcRegisteredService registeredService, JwtClaims claims) {
        String encodedAccessToken = (String)OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService((RegisteredService)registeredService).service(accessToken.getService()).accessTokenJwtBuilder(((OidcConfigurationContext)this.getConfigurationContext()).getAccessTokenJwtBuilder()).profileScopeToAttributesFilter(((OidcConfigurationContext)this.getConfigurationContext()).getProfileScopeToAttributesFilter()).casProperties(((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties()).issuer(((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().determineIssuer(Optional.of(registeredService))).build().encode((Object)accessToken.getId());
        String alg = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().getJsonWebKeySigningAlgorithm((OAuthRegisteredService)registeredService);
        String hash = OAuth20AccessTokenAtHashGenerator.builder().encodedAccessToken(encodedAccessToken).algorithm(alg).registeredService((RegisteredService)registeredService).build().generate();
        claims.setClaim("at_hash", (Object)hash);
    }
}

